<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceMove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named moveCardToBacklog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceMoveCardToBacklogDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardToBacklogResponse|bool
     */
    public function moveCardToBacklog(\KanbanCardService\StructType\KanbanCardServiceMoveCardToBacklogDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveCardToBacklog($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveMultipleCardToBacklog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToBacklogInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToBacklogResponse|bool
     */
    public function moveMultipleCardToBacklog(\KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToBacklogInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveMultipleCardToBacklog($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveCardOnBoard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardResponse|bool
     */
    public function moveCardOnBoard(\KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveCardOnBoard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveMultipleCardOnBoard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardResponse|bool
     */
    public function moveMultipleCardOnBoard(\KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveMultipleCardOnBoard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveCardtoReady
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceMoveCardtoReadyDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardtoReadyResponse|bool
     */
    public function moveCardtoReady(\KanbanCardService\StructType\KanbanCardServiceMoveCardtoReadyDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveCardtoReady($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveMultipleCardToReady
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToReadyInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToReadyResponse|bool
     */
    public function moveMultipleCardToReady(\KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToReadyInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->moveMultipleCardToReady($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardResponse|\KanbanCardService\StructType\KanbanCardServiceMoveCardToBacklogResponse|\KanbanCardService\StructType\KanbanCardServiceMoveCardtoReadyResponse|\KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardResponse|\KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToBacklogResponse|\KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToReadyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
