<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceDelete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceDeleteCardInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceDeleteCardResponse|bool
     */
    public function deleteCard(\KanbanCardService\StructType\KanbanCardServiceDeleteCardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteMultipleCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceDeleteMultipleCardInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceDeleteMultipleCardResponse|bool
     */
    public function deleteMultipleCard(\KanbanCardService\StructType\KanbanCardServiceDeleteMultipleCardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteMultipleCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceDeleteCardResponse|\KanbanCardService\StructType\KanbanCardServiceDeleteMultipleCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
