<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Convert ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceConvert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named convertCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceConvertCardInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceConvertCardResponse|bool
     */
    public function convertCard(\KanbanCardService\StructType\KanbanCardServiceConvertCardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->convertCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceConvertCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
