<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Block ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceBlock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named blockCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceBlockCardDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceBlockCardResponse|bool
     */
    public function blockCard(\KanbanCardService\StructType\KanbanCardServiceBlockCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->blockCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceBlockCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
