<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceAdd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceAddCardDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardResponse|bool
     */
    public function addCard(\KanbanCardService\StructType\KanbanCardServiceAddCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->addCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMultipleCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceAddMultipleCardInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceAddMultipleCardResponse|bool
     */
    public function addMultipleCard(\KanbanCardService\StructType\KanbanCardServiceAddMultipleCardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->addMultipleCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardResponse|\KanbanCardService\StructType\KanbanCardServiceAddMultipleCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
