<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifyTicketIsForwardableToOwnerResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VerifyTicketIsForwardableToOwnerResponse
 * @subpackage Structs
 */
class VerifyTicketIsForwardableToOwnerResponse extends AbstractStructBase
{
    /**
     * The CanBeForwarded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanBeForwarded;
    /**
     * The ErrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrCode;
    /**
     * The ErrMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrMessage;
    /**
     * Constructor method for VerifyTicketIsForwardableToOwnerResponse
     * @uses VerifyTicketIsForwardableToOwnerResponse::setCanBeForwarded()
     * @uses VerifyTicketIsForwardableToOwnerResponse::setErrCode()
     * @uses VerifyTicketIsForwardableToOwnerResponse::setErrMessage()
     * @param bool $canBeForwarded
     * @param string $errCode
     * @param string $errMessage
     */
    public function __construct($canBeForwarded = null, $errCode = null, $errMessage = null)
    {
        $this
            ->setCanBeForwarded($canBeForwarded)
            ->setErrCode($errCode)
            ->setErrMessage($errMessage);
    }
    /**
     * Get CanBeForwarded value
     * @return bool|null
     */
    public function getCanBeForwarded()
    {
        return $this->CanBeForwarded;
    }
    /**
     * Set CanBeForwarded value
     * @param bool $canBeForwarded
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerResponse
     */
    public function setCanBeForwarded($canBeForwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeForwarded) && !is_bool($canBeForwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeForwarded, true), gettype($canBeForwarded)), __LINE__);
        }
        $this->CanBeForwarded = $canBeForwarded;
        return $this;
    }
    /**
     * Get ErrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrCode()
    {
        return isset($this->ErrCode) ? $this->ErrCode : null;
    }
    /**
     * Set ErrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errCode
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerResponse
     */
    public function setErrCode($errCode = null)
    {
        // validation for constraint: string
        if (!is_null($errCode) && !is_string($errCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errCode, true), gettype($errCode)), __LINE__);
        }
        if (is_null($errCode) || (is_array($errCode) && empty($errCode))) {
            unset($this->ErrCode);
        } else {
            $this->ErrCode = $errCode;
        }
        return $this;
    }
    /**
     * Get ErrMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrMessage()
    {
        return isset($this->ErrMessage) ? $this->ErrMessage : null;
    }
    /**
     * Set ErrMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errMessage
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerResponse
     */
    public function setErrMessage($errMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errMessage) && !is_string($errMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errMessage, true), gettype($errMessage)), __LINE__);
        }
        if (is_null($errMessage) || (is_array($errMessage) && empty($errMessage))) {
            unset($this->ErrMessage);
        } else {
            $this->ErrMessage = $errMessage;
        }
        return $this;
    }
}
