<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifyAndSaveDeviceIdsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VerifyAndSaveDeviceIdsRequest
 * @subpackage Structs
 */
class VerifyAndSaveDeviceIdsRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceId;
    /**
     * The DeviceRegistrationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceRegistrationId;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceType;
    /**
     * The NotificationSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationSystem;
    /**
     * Constructor method for VerifyAndSaveDeviceIdsRequest
     * @uses VerifyAndSaveDeviceIdsRequest::setClientId()
     * @uses VerifyAndSaveDeviceIdsRequest::setDeviceId()
     * @uses VerifyAndSaveDeviceIdsRequest::setDeviceRegistrationId()
     * @uses VerifyAndSaveDeviceIdsRequest::setDeviceType()
     * @uses VerifyAndSaveDeviceIdsRequest::setNotificationSystem()
     * @param string $clientId
     * @param string $deviceId
     * @param string $deviceRegistrationId
     * @param string $deviceType
     * @param string $notificationSystem
     */
    public function __construct($clientId = null, $deviceId = null, $deviceRegistrationId = null, $deviceType = null, $notificationSystem = null)
    {
        $this
            ->setClientId($clientId)
            ->setDeviceId($deviceId)
            ->setDeviceRegistrationId($deviceRegistrationId)
            ->setDeviceType($deviceType)
            ->setNotificationSystem($notificationSystem);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\VerifyAndSaveDeviceIdsRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get DeviceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceId()
    {
        return isset($this->DeviceId) ? $this->DeviceId : null;
    }
    /**
     * Set DeviceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceId
     * @return \patest\StructType\VerifyAndSaveDeviceIdsRequest
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceId) && !is_string($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        if (is_null($deviceId) || (is_array($deviceId) && empty($deviceId))) {
            unset($this->DeviceId);
        } else {
            $this->DeviceId = $deviceId;
        }
        return $this;
    }
    /**
     * Get DeviceRegistrationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceRegistrationId()
    {
        return isset($this->DeviceRegistrationId) ? $this->DeviceRegistrationId : null;
    }
    /**
     * Set DeviceRegistrationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceRegistrationId
     * @return \patest\StructType\VerifyAndSaveDeviceIdsRequest
     */
    public function setDeviceRegistrationId($deviceRegistrationId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceRegistrationId) && !is_string($deviceRegistrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceRegistrationId, true), gettype($deviceRegistrationId)), __LINE__);
        }
        if (is_null($deviceRegistrationId) || (is_array($deviceRegistrationId) && empty($deviceRegistrationId))) {
            unset($this->DeviceRegistrationId);
        } else {
            $this->DeviceRegistrationId = $deviceRegistrationId;
        }
        return $this;
    }
    /**
     * Get DeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceType()
    {
        return isset($this->DeviceType) ? $this->DeviceType : null;
    }
    /**
     * Set DeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceType
     * @return \patest\StructType\VerifyAndSaveDeviceIdsRequest
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: string
        if (!is_null($deviceType) && !is_string($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceType, true), gettype($deviceType)), __LINE__);
        }
        if (is_null($deviceType) || (is_array($deviceType) && empty($deviceType))) {
            unset($this->DeviceType);
        } else {
            $this->DeviceType = $deviceType;
        }
        return $this;
    }
    /**
     * Get NotificationSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationSystem()
    {
        return isset($this->NotificationSystem) ? $this->NotificationSystem : null;
    }
    /**
     * Set NotificationSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationSystem
     * @return \patest\StructType\VerifyAndSaveDeviceIdsRequest
     */
    public function setNotificationSystem($notificationSystem = null)
    {
        // validation for constraint: string
        if (!is_null($notificationSystem) && !is_string($notificationSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationSystem, true), gettype($notificationSystem)), __LINE__);
        }
        if (is_null($notificationSystem) || (is_array($notificationSystem) && empty($notificationSystem))) {
            unset($this->NotificationSystem);
        } else {
            $this->NotificationSystem = $notificationSystem;
        }
        return $this;
    }
}
