<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateWithdrawPendingTransferTickets-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateWithdrawPendingTransferTickets-Response
 * @subpackage Structs
 */
class ValidateWithdrawPendingTransferTickets_Response extends AbstractStructBase
{
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The GroupTransferRequestsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $GroupTransferRequestsIds;
    /**
     * Constructor method for ValidateWithdrawPendingTransferTickets-Response
     * @uses ValidateWithdrawPendingTransferTickets_Response::setErrorMessage()
     * @uses ValidateWithdrawPendingTransferTickets_Response::setGroupTransferRequestsIds()
     * @param string $errorMessage
     * @param \patest\ArrayType\ArrayOfguid $groupTransferRequestsIds
     */
    public function __construct($errorMessage = null, \patest\ArrayType\ArrayOfguid $groupTransferRequestsIds = null)
    {
        $this
            ->setErrorMessage($errorMessage)
            ->setGroupTransferRequestsIds($groupTransferRequestsIds);
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \patest\StructType\ValidateWithdrawPendingTransferTickets_Response
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get GroupTransferRequestsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getGroupTransferRequestsIds()
    {
        return isset($this->GroupTransferRequestsIds) ? $this->GroupTransferRequestsIds : null;
    }
    /**
     * Set GroupTransferRequestsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $groupTransferRequestsIds
     * @return \patest\StructType\ValidateWithdrawPendingTransferTickets_Response
     */
    public function setGroupTransferRequestsIds(\patest\ArrayType\ArrayOfguid $groupTransferRequestsIds = null)
    {
        if (is_null($groupTransferRequestsIds) || (is_array($groupTransferRequestsIds) && empty($groupTransferRequestsIds))) {
            unset($this->GroupTransferRequestsIds);
        } else {
            $this->GroupTransferRequestsIds = $groupTransferRequestsIds;
        }
        return $this;
    }
}
