<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateTransactionAccessControlDataResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateTransactionAccessControlDataResponse
 * @subpackage Structs
 */
class ValidateTransactionAccessControlDataResponse extends ExtensibleDataContract
{
    /**
     * The ItemsAccessControlData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBasketItemAccessControlData
     */
    public $ItemsAccessControlData;
    /**
     * The ValidationErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBasketItemAccessControlValidationErrors
     */
    public $ValidationErrors;
    /**
     * Constructor method for ValidateTransactionAccessControlDataResponse
     * @uses ValidateTransactionAccessControlDataResponse::setItemsAccessControlData()
     * @uses ValidateTransactionAccessControlDataResponse::setValidationErrors()
     * @param \patest\ArrayType\ArrayOfBasketItemAccessControlData $itemsAccessControlData
     * @param \patest\ArrayType\ArrayOfBasketItemAccessControlValidationErrors $validationErrors
     */
    public function __construct(\patest\ArrayType\ArrayOfBasketItemAccessControlData $itemsAccessControlData = null, \patest\ArrayType\ArrayOfBasketItemAccessControlValidationErrors $validationErrors = null)
    {
        $this
            ->setItemsAccessControlData($itemsAccessControlData)
            ->setValidationErrors($validationErrors);
    }
    /**
     * Get ItemsAccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBasketItemAccessControlData|null
     */
    public function getItemsAccessControlData()
    {
        return isset($this->ItemsAccessControlData) ? $this->ItemsAccessControlData : null;
    }
    /**
     * Set ItemsAccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBasketItemAccessControlData $itemsAccessControlData
     * @return \patest\StructType\ValidateTransactionAccessControlDataResponse
     */
    public function setItemsAccessControlData(\patest\ArrayType\ArrayOfBasketItemAccessControlData $itemsAccessControlData = null)
    {
        if (is_null($itemsAccessControlData) || (is_array($itemsAccessControlData) && empty($itemsAccessControlData))) {
            unset($this->ItemsAccessControlData);
        } else {
            $this->ItemsAccessControlData = $itemsAccessControlData;
        }
        return $this;
    }
    /**
     * Get ValidationErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBasketItemAccessControlValidationErrors|null
     */
    public function getValidationErrors()
    {
        return isset($this->ValidationErrors) ? $this->ValidationErrors : null;
    }
    /**
     * Set ValidationErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBasketItemAccessControlValidationErrors $validationErrors
     * @return \patest\StructType\ValidateTransactionAccessControlDataResponse
     */
    public function setValidationErrors(\patest\ArrayType\ArrayOfBasketItemAccessControlValidationErrors $validationErrors = null)
    {
        if (is_null($validationErrors) || (is_array($validationErrors) && empty($validationErrors))) {
            unset($this->ValidationErrors);
        } else {
            $this->ValidationErrors = $validationErrors;
        }
        return $this;
    }
}
