<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateSelectedProductsForBundleRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateSelectedProductsForBundleRequest
 * @subpackage Structs
 */
class ValidateSelectedProductsForBundleRequest extends ExtensibleDataContract
{
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The QuantityOfBundles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfBundles;
    /**
     * The SelectedProducts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBundleElementConfiguration
     */
    public $SelectedProducts;
    /**
     * Constructor method for ValidateSelectedProductsForBundleRequest
     * @uses ValidateSelectedProductsForBundleRequest::setBundleId()
     * @uses ValidateSelectedProductsForBundleRequest::setQuantityOfBundles()
     * @uses ValidateSelectedProductsForBundleRequest::setSelectedProducts()
     * @param string $bundleId
     * @param int $quantityOfBundles
     * @param \patest\ArrayType\ArrayOfBundleElementConfiguration $selectedProducts
     */
    public function __construct($bundleId = null, $quantityOfBundles = null, \patest\ArrayType\ArrayOfBundleElementConfiguration $selectedProducts = null)
    {
        $this
            ->setBundleId($bundleId)
            ->setQuantityOfBundles($quantityOfBundles)
            ->setSelectedProducts($selectedProducts);
    }
    /**
     * Get BundleId value
     * @return string|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param string $bundleId
     * @return \patest\StructType\ValidateSelectedProductsForBundleRequest
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get QuantityOfBundles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfBundles()
    {
        return isset($this->QuantityOfBundles) ? $this->QuantityOfBundles : null;
    }
    /**
     * Set QuantityOfBundles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfBundles
     * @return \patest\StructType\ValidateSelectedProductsForBundleRequest
     */
    public function setQuantityOfBundles($quantityOfBundles = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfBundles) && !(is_int($quantityOfBundles) || ctype_digit($quantityOfBundles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfBundles, true), gettype($quantityOfBundles)), __LINE__);
        }
        if (is_null($quantityOfBundles) || (is_array($quantityOfBundles) && empty($quantityOfBundles))) {
            unset($this->QuantityOfBundles);
        } else {
            $this->QuantityOfBundles = $quantityOfBundles;
        }
        return $this;
    }
    /**
     * Get SelectedProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBundleElementConfiguration|null
     */
    public function getSelectedProducts()
    {
        return isset($this->SelectedProducts) ? $this->SelectedProducts : null;
    }
    /**
     * Set SelectedProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBundleElementConfiguration $selectedProducts
     * @return \patest\StructType\ValidateSelectedProductsForBundleRequest
     */
    public function setSelectedProducts(\patest\ArrayType\ArrayOfBundleElementConfiguration $selectedProducts = null)
    {
        if (is_null($selectedProducts) || (is_array($selectedProducts) && empty($selectedProducts))) {
            unset($this->SelectedProducts);
        } else {
            $this->SelectedProducts = $selectedProducts;
        }
        return $this;
    }
}
