<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateJwtTokenForExternalService-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateJwtTokenForExternalService-Request
 * @subpackage Structs
 */
class ValidateJwtTokenForExternalService_Request extends ExtensibleDataContract
{
    /**
     * The JwtToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JwtToken;
    /**
     * The ServiceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceId;
    /**
     * Constructor method for ValidateJwtTokenForExternalService-Request
     * @uses ValidateJwtTokenForExternalService_Request::setJwtToken()
     * @uses ValidateJwtTokenForExternalService_Request::setServiceId()
     * @param string $jwtToken
     * @param string $serviceId
     */
    public function __construct($jwtToken = null, $serviceId = null)
    {
        $this
            ->setJwtToken($jwtToken)
            ->setServiceId($serviceId);
    }
    /**
     * Get JwtToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJwtToken()
    {
        return isset($this->JwtToken) ? $this->JwtToken : null;
    }
    /**
     * Set JwtToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jwtToken
     * @return \patest\StructType\ValidateJwtTokenForExternalService_Request
     */
    public function setJwtToken($jwtToken = null)
    {
        // validation for constraint: string
        if (!is_null($jwtToken) && !is_string($jwtToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jwtToken, true), gettype($jwtToken)), __LINE__);
        }
        if (is_null($jwtToken) || (is_array($jwtToken) && empty($jwtToken))) {
            unset($this->JwtToken);
        } else {
            $this->JwtToken = $jwtToken;
        }
        return $this;
    }
    /**
     * Get ServiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceId()
    {
        return isset($this->ServiceId) ? $this->ServiceId : null;
    }
    /**
     * Set ServiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceId
     * @return \patest\StructType\ValidateJwtTokenForExternalService_Request
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        if (is_null($serviceId) || (is_array($serviceId) && empty($serviceId))) {
            unset($this->ServiceId);
        } else {
            $this->ServiceId = $serviceId;
        }
        return $this;
    }
}
