<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * ValidateForClientContainedInAnotherBallotApplicationRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateForClientContainedInAnotherBallotApplicationRequest
 * @subpackage Structs
 */
class ValidateForClientContainedInAnotherBallotApplicationRequest extends AbstractStructBase
{
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * Constructor method for
     * ValidateForClientContainedInAnotherBallotApplicationRequest
     * @uses ValidateForClientContainedInAnotherBallotApplicationRequest::setBallotId()
     * @uses ValidateForClientContainedInAnotherBallotApplicationRequest::setClientId()
     * @param string $ballotId
     * @param string $clientId
     */
    public function __construct($ballotId = null, $clientId = null)
    {
        $this
            ->setBallotId($ballotId)
            ->setClientId($clientId);
    }
    /**
     * Get BallotId value
     * @return string|null
     */
    public function getBallotId()
    {
        return $this->BallotId;
    }
    /**
     * Set BallotId value
     * @param string $ballotId
     * @return \patest\StructType\ValidateForClientContainedInAnotherBallotApplicationRequest
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        $this->BallotId = $ballotId;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\ValidateForClientContainedInAnotherBallotApplicationRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
}
