<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateContactDetail-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateContactDetail-Response
 * @subpackage Structs
 */
class ValidateContactDetail_Response extends AbstractStructBase
{
    /**
     * The AdditionalData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $AdditionalData;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Info;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for ValidateContactDetail-Response
     * @uses ValidateContactDetail_Response::setAdditionalData()
     * @uses ValidateContactDetail_Response::setInfo()
     * @uses ValidateContactDetail_Response::setStatus()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $additionalData
     * @param string $info
     * @param string $status
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringstring $additionalData = null, $info = null, $status = null)
    {
        $this
            ->setAdditionalData($additionalData)
            ->setInfo($info)
            ->setStatus($status);
    }
    /**
     * Get AdditionalData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getAdditionalData()
    {
        return isset($this->AdditionalData) ? $this->AdditionalData : null;
    }
    /**
     * Set AdditionalData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $additionalData
     * @return \patest\StructType\ValidateContactDetail_Response
     */
    public function setAdditionalData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $additionalData = null)
    {
        if (is_null($additionalData) || (is_array($additionalData) && empty($additionalData))) {
            unset($this->AdditionalData);
        } else {
            $this->AdditionalData = $additionalData;
        }
        return $this;
    }
    /**
     * Get Info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfo()
    {
        return isset($this->Info) ? $this->Info : null;
    }
    /**
     * Set Info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $info
     * @return \patest\StructType\ValidateContactDetail_Response
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->Info);
        } else {
            $this->Info = $info;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\ValidationStatus::valueIsValid()
     * @uses \patest\EnumType\ValidationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\ValidateContactDetail_Response
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ValidationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ValidationStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ValidationStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
