<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateBreakingHallDesignChangesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateBreakingHallDesignChangesRequest
 * @subpackage Structs
 */
class ValidateBreakingHallDesignChangesRequest extends ExtensibleDataContract
{
    /**
     * The ChangeLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ChangeLevel;
    /**
     * The ChangeObjectId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChangeObjectId;
    /**
     * The ChangesToValidate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfHallDesignBreakingChangeInfo
     */
    public $ChangesToValidate;
    /**
     * Constructor method for ValidateBreakingHallDesignChangesRequest
     * @uses ValidateBreakingHallDesignChangesRequest::setChangeLevel()
     * @uses ValidateBreakingHallDesignChangesRequest::setChangeObjectId()
     * @uses ValidateBreakingHallDesignChangesRequest::setChangesToValidate()
     * @param string $changeLevel
     * @param string $changeObjectId
     * @param \patest\ArrayType\ArrayOfHallDesignBreakingChangeInfo $changesToValidate
     */
    public function __construct($changeLevel = null, $changeObjectId = null, \patest\ArrayType\ArrayOfHallDesignBreakingChangeInfo $changesToValidate = null)
    {
        $this
            ->setChangeLevel($changeLevel)
            ->setChangeObjectId($changeObjectId)
            ->setChangesToValidate($changesToValidate);
    }
    /**
     * Get ChangeLevel value
     * @return string|null
     */
    public function getChangeLevel()
    {
        return $this->ChangeLevel;
    }
    /**
     * Set ChangeLevel value
     * @uses \patest\EnumType\HallDataResolutionLevel::valueIsValid()
     * @uses \patest\EnumType\HallDataResolutionLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changeLevel
     * @return \patest\StructType\ValidateBreakingHallDesignChangesRequest
     */
    public function setChangeLevel($changeLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallDataResolutionLevel::valueIsValid($changeLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallDataResolutionLevel', is_array($changeLevel) ? implode(', ', $changeLevel) : var_export($changeLevel, true), implode(', ', \patest\EnumType\HallDataResolutionLevel::getValidValues())), __LINE__);
        }
        $this->ChangeLevel = $changeLevel;
        return $this;
    }
    /**
     * Get ChangeObjectId value
     * @return string|null
     */
    public function getChangeObjectId()
    {
        return $this->ChangeObjectId;
    }
    /**
     * Set ChangeObjectId value
     * @param string $changeObjectId
     * @return \patest\StructType\ValidateBreakingHallDesignChangesRequest
     */
    public function setChangeObjectId($changeObjectId = null)
    {
        // validation for constraint: string
        if (!is_null($changeObjectId) && !is_string($changeObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeObjectId, true), gettype($changeObjectId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($changeObjectId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $changeObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($changeObjectId, true)), __LINE__);
        }
        $this->ChangeObjectId = $changeObjectId;
        return $this;
    }
    /**
     * Get ChangesToValidate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfHallDesignBreakingChangeInfo|null
     */
    public function getChangesToValidate()
    {
        return isset($this->ChangesToValidate) ? $this->ChangesToValidate : null;
    }
    /**
     * Set ChangesToValidate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfHallDesignBreakingChangeInfo $changesToValidate
     * @return \patest\StructType\ValidateBreakingHallDesignChangesRequest
     */
    public function setChangesToValidate(\patest\ArrayType\ArrayOfHallDesignBreakingChangeInfo $changesToValidate = null)
    {
        if (is_null($changesToValidate) || (is_array($changesToValidate) && empty($changesToValidate))) {
            unset($this->ChangesToValidate);
        } else {
            $this->ChangesToValidate = $changesToValidate;
        }
        return $this;
    }
}
