<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePaymentStatusItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdatePaymentStatusItem
 * @subpackage Structs
 */
class UpdatePaymentStatusItem extends AbstractStructBase
{
    /**
     * The NewReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewReferenceNumber;
    /**
     * The NewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NewStatus;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * Constructor method for UpdatePaymentStatusItem
     * @uses UpdatePaymentStatusItem::setNewReferenceNumber()
     * @uses UpdatePaymentStatusItem::setNewStatus()
     * @uses UpdatePaymentStatusItem::setPaymentItemId()
     * @param string $newReferenceNumber
     * @param string $newStatus
     * @param string $paymentItemId
     */
    public function __construct($newReferenceNumber = null, $newStatus = null, $paymentItemId = null)
    {
        $this
            ->setNewReferenceNumber($newReferenceNumber)
            ->setNewStatus($newStatus)
            ->setPaymentItemId($paymentItemId);
    }
    /**
     * Get NewReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewReferenceNumber()
    {
        return isset($this->NewReferenceNumber) ? $this->NewReferenceNumber : null;
    }
    /**
     * Set NewReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newReferenceNumber
     * @return \patest\StructType\UpdatePaymentStatusItem
     */
    public function setNewReferenceNumber($newReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($newReferenceNumber) && !is_string($newReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newReferenceNumber, true), gettype($newReferenceNumber)), __LINE__);
        }
        if (is_null($newReferenceNumber) || (is_array($newReferenceNumber) && empty($newReferenceNumber))) {
            unset($this->NewReferenceNumber);
        } else {
            $this->NewReferenceNumber = $newReferenceNumber;
        }
        return $this;
    }
    /**
     * Get NewStatus value
     * @return string|null
     */
    public function getNewStatus()
    {
        return $this->NewStatus;
    }
    /**
     * Set NewStatus value
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newStatus
     * @return \patest\StructType\UpdatePaymentStatusItem
     */
    public function setNewStatus($newStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($newStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($newStatus) ? implode(', ', $newStatus) : var_export($newStatus, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        $this->NewStatus = $newStatus;
        return $this;
    }
    /**
     * Get PaymentItemId value
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return $this->PaymentItemId;
    }
    /**
     * Set PaymentItemId value
     * @param string $paymentItemId
     * @return \patest\StructType\UpdatePaymentStatusItem
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        $this->PaymentItemId = $paymentItemId;
        return $this;
    }
}
