<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePaymentSessionStateRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdatePaymentSessionStateRequest
 * @subpackage Structs
 */
class UpdatePaymentSessionStateRequest extends ExtensibleDataContract
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The FailReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailReason;
    /**
     * The IsOperationStateIndeterminate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOperationStateIndeterminate;
    /**
     * The MessageText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageText;
    /**
     * The PaymentSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentSessionId;
    /**
     * The ResultData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SerializedDefinitionNode
     */
    public $ResultData;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for UpdatePaymentSessionStateRequest
     * @uses UpdatePaymentSessionStateRequest::setAction()
     * @uses UpdatePaymentSessionStateRequest::setFailReason()
     * @uses UpdatePaymentSessionStateRequest::setIsOperationStateIndeterminate()
     * @uses UpdatePaymentSessionStateRequest::setMessageText()
     * @uses UpdatePaymentSessionStateRequest::setPaymentSessionId()
     * @uses UpdatePaymentSessionStateRequest::setResultData()
     * @uses UpdatePaymentSessionStateRequest::setTransactionSnapshotType()
     * @param string $action
     * @param string $failReason
     * @param bool $isOperationStateIndeterminate
     * @param string $messageText
     * @param string $paymentSessionId
     * @param \patest\StructType\SerializedDefinitionNode $resultData
     * @param string $transactionSnapshotType
     */
    public function __construct($action = null, $failReason = null, $isOperationStateIndeterminate = null, $messageText = null, $paymentSessionId = null, \patest\StructType\SerializedDefinitionNode $resultData = null, $transactionSnapshotType = null)
    {
        $this
            ->setAction($action)
            ->setFailReason($failReason)
            ->setIsOperationStateIndeterminate($isOperationStateIndeterminate)
            ->setMessageText($messageText)
            ->setPaymentSessionId($paymentSessionId)
            ->setResultData($resultData)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \patest\EnumType\PaymentSessionAction::valueIsValid()
     * @uses \patest\EnumType\PaymentSessionAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\UpdatePaymentSessionStateRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentSessionAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentSessionAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\PaymentSessionAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get FailReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailReason()
    {
        return isset($this->FailReason) ? $this->FailReason : null;
    }
    /**
     * Set FailReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentSessionActionFailReason::valueIsValid()
     * @uses \patest\EnumType\PaymentSessionActionFailReason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failReason
     * @return \patest\StructType\UpdatePaymentSessionStateRequest
     */
    public function setFailReason($failReason = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentSessionActionFailReason::valueIsValid($failReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentSessionActionFailReason', is_array($failReason) ? implode(', ', $failReason) : var_export($failReason, true), implode(', ', \patest\EnumType\PaymentSessionActionFailReason::getValidValues())), __LINE__);
        }
        if (is_null($failReason) || (is_array($failReason) && empty($failReason))) {
            unset($this->FailReason);
        } else {
            $this->FailReason = $failReason;
        }
        return $this;
    }
    /**
     * Get IsOperationStateIndeterminate value
     * @return bool|null
     */
    public function getIsOperationStateIndeterminate()
    {
        return $this->IsOperationStateIndeterminate;
    }
    /**
     * Set IsOperationStateIndeterminate value
     * @param bool $isOperationStateIndeterminate
     * @return \patest\StructType\UpdatePaymentSessionStateRequest
     */
    public function setIsOperationStateIndeterminate($isOperationStateIndeterminate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOperationStateIndeterminate) && !is_bool($isOperationStateIndeterminate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOperationStateIndeterminate, true), gettype($isOperationStateIndeterminate)), __LINE__);
        }
        $this->IsOperationStateIndeterminate = $isOperationStateIndeterminate;
        return $this;
    }
    /**
     * Get MessageText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageText()
    {
        return isset($this->MessageText) ? $this->MessageText : null;
    }
    /**
     * Set MessageText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageText
     * @return \patest\StructType\UpdatePaymentSessionStateRequest
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageText, true), gettype($messageText)), __LINE__);
        }
        if (is_null($messageText) || (is_array($messageText) && empty($messageText))) {
            unset($this->MessageText);
        } else {
            $this->MessageText = $messageText;
        }
        return $this;
    }
    /**
     * Get PaymentSessionId value
     * @return string|null
     */
    public function getPaymentSessionId()
    {
        return $this->PaymentSessionId;
    }
    /**
     * Set PaymentSessionId value
     * @param string $paymentSessionId
     * @return \patest\StructType\UpdatePaymentSessionStateRequest
     */
    public function setPaymentSessionId($paymentSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSessionId) && !is_string($paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSessionId, true), gettype($paymentSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentSessionId, true)), __LINE__);
        }
        $this->PaymentSessionId = $paymentSessionId;
        return $this;
    }
    /**
     * Get ResultData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SerializedDefinitionNode|null
     */
    public function getResultData()
    {
        return isset($this->ResultData) ? $this->ResultData : null;
    }
    /**
     * Set ResultData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SerializedDefinitionNode $resultData
     * @return \patest\StructType\UpdatePaymentSessionStateRequest
     */
    public function setResultData(\patest\StructType\SerializedDefinitionNode $resultData = null)
    {
        if (is_null($resultData) || (is_array($resultData) && empty($resultData))) {
            unset($this->ResultData);
        } else {
            $this->ResultData = $resultData;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\UpdatePaymentSessionStateRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
