<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePaymentPlanInstallments-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdatePaymentPlanInstallments-Request
 * @subpackage Structs
 */
class UpdatePaymentPlanInstallments_Request extends AbstractStructBase
{
    /**
     * The InstallmentItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInstallmentItem
     */
    public $InstallmentItems;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentItemId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for UpdatePaymentPlanInstallments-Request
     * @uses UpdatePaymentPlanInstallments_Request::setInstallmentItems()
     * @uses UpdatePaymentPlanInstallments_Request::setPaymentItemId()
     * @uses UpdatePaymentPlanInstallments_Request::setTransactionGuid()
     * @uses UpdatePaymentPlanInstallments_Request::setTransactionSnapshotType()
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @param int $paymentItemId
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null, $paymentItemId = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setInstallmentItems($installmentItems)
            ->setPaymentItemId($paymentItemId)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get InstallmentItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInstallmentItem|null
     */
    public function getInstallmentItems()
    {
        return isset($this->InstallmentItems) ? $this->InstallmentItems : null;
    }
    /**
     * Set InstallmentItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @return \patest\StructType\UpdatePaymentPlanInstallments_Request
     */
    public function setInstallmentItems(\patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null)
    {
        if (is_null($installmentItems) || (is_array($installmentItems) && empty($installmentItems))) {
            unset($this->InstallmentItems);
        } else {
            $this->InstallmentItems = $installmentItems;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * @return int|null
     */
    public function getPaymentItemId()
    {
        return $this->PaymentItemId;
    }
    /**
     * Set PaymentItemId value
     * @param int $paymentItemId
     * @return \patest\StructType\UpdatePaymentPlanInstallments_Request
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentItemId) && !(is_int($paymentItemId) || ctype_digit($paymentItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        $this->PaymentItemId = $paymentItemId;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\UpdatePaymentPlanInstallments_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\UpdatePaymentPlanInstallments_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
