<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateParameters-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateParameters-Request
 * @subpackage Structs
 */
class UpdateParameters_Request extends ExtensibleDataContract
{
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Owner;
    /**
     * The ParameterValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfParameterInfo
     */
    public $ParameterValues;
    /**
     * Constructor method for UpdateParameters-Request
     * @uses UpdateParameters_Request::setOwner()
     * @uses UpdateParameters_Request::setParameterValues()
     * @param string $owner
     * @param \patest\ArrayType\ArrayOfParameterInfo $parameterValues
     */
    public function __construct($owner = null, \patest\ArrayType\ArrayOfParameterInfo $parameterValues = null)
    {
        $this
            ->setOwner($owner)
            ->setParameterValues($parameterValues);
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $owner
     * @return \patest\StructType\UpdateParameters_Request
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get ParameterValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfParameterInfo|null
     */
    public function getParameterValues()
    {
        return isset($this->ParameterValues) ? $this->ParameterValues : null;
    }
    /**
     * Set ParameterValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfParameterInfo $parameterValues
     * @return \patest\StructType\UpdateParameters_Request
     */
    public function setParameterValues(\patest\ArrayType\ArrayOfParameterInfo $parameterValues = null)
    {
        if (is_null($parameterValues) || (is_array($parameterValues) && empty($parameterValues))) {
            unset($this->ParameterValues);
        } else {
            $this->ParameterValues = $parameterValues;
        }
        return $this;
    }
}
