<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnionSubsidyPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UnionSubsidyPaymentItem
 * @subpackage Structs
 */
class UnionSubsidyPaymentItem extends AbstractPaymentItem
{
    /**
     * The SubsidizingAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizingAccountId;
    /**
     * The SubsidizingAccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubsidizingAccountName;
    /**
     * Constructor method for UnionSubsidyPaymentItem
     * @uses UnionSubsidyPaymentItem::setSubsidizingAccountId()
     * @uses UnionSubsidyPaymentItem::setSubsidizingAccountName()
     * @param string $subsidizingAccountId
     * @param string $subsidizingAccountName
     */
    public function __construct($subsidizingAccountId = null, $subsidizingAccountName = null)
    {
        $this
            ->setSubsidizingAccountId($subsidizingAccountId)
            ->setSubsidizingAccountName($subsidizingAccountName);
    }
    /**
     * Get SubsidizingAccountId value
     * @return string|null
     */
    public function getSubsidizingAccountId()
    {
        return $this->SubsidizingAccountId;
    }
    /**
     * Set SubsidizingAccountId value
     * @param string $subsidizingAccountId
     * @return \patest\StructType\UnionSubsidyPaymentItem
     */
    public function setSubsidizingAccountId($subsidizingAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingAccountId) && !is_string($subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingAccountId, true), gettype($subsidizingAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizingAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizingAccountId, true)), __LINE__);
        }
        $this->SubsidizingAccountId = $subsidizingAccountId;
        return $this;
    }
    /**
     * Get SubsidizingAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizingAccountName()
    {
        return isset($this->SubsidizingAccountName) ? $this->SubsidizingAccountName : null;
    }
    /**
     * Set SubsidizingAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizingAccountName
     * @return \patest\StructType\UnionSubsidyPaymentItem
     */
    public function setSubsidizingAccountName($subsidizingAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingAccountName) && !is_string($subsidizingAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingAccountName, true), gettype($subsidizingAccountName)), __LINE__);
        }
        if (is_null($subsidizingAccountName) || (is_array($subsidizingAccountName) && empty($subsidizingAccountName))) {
            unset($this->SubsidizingAccountName);
        } else {
            $this->SubsidizingAccountName = $subsidizingAccountName;
        }
        return $this;
    }
}
