<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionInteractionFlowResponseItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionInteractionFlowResponseItem
 * @subpackage Structs
 */
class TransactionInteractionFlowResponseItem extends AbstractStructBase
{
    /**
     * The ElementMetadata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SerializedDefinitionNode
     */
    public $ElementMetadata;
    /**
     * The ElementName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ElementName;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\FailureInformation
     */
    public $Error;
    /**
     * The RequiredInteractionInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SerializedObject
     */
    public $RequiredInteractionInfo;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SerializedObject
     */
    public $State;
    /**
     * Constructor method for TransactionInteractionFlowResponseItem
     * @uses TransactionInteractionFlowResponseItem::setElementMetadata()
     * @uses TransactionInteractionFlowResponseItem::setElementName()
     * @uses TransactionInteractionFlowResponseItem::setError()
     * @uses TransactionInteractionFlowResponseItem::setRequiredInteractionInfo()
     * @uses TransactionInteractionFlowResponseItem::setState()
     * @param \patest\StructType\SerializedDefinitionNode $elementMetadata
     * @param string $elementName
     * @param \patest\StructType\FailureInformation $error
     * @param \patest\StructType\SerializedObject $requiredInteractionInfo
     * @param \patest\StructType\SerializedObject $state
     */
    public function __construct(\patest\StructType\SerializedDefinitionNode $elementMetadata = null, $elementName = null, \patest\StructType\FailureInformation $error = null, \patest\StructType\SerializedObject $requiredInteractionInfo = null, \patest\StructType\SerializedObject $state = null)
    {
        $this
            ->setElementMetadata($elementMetadata)
            ->setElementName($elementName)
            ->setError($error)
            ->setRequiredInteractionInfo($requiredInteractionInfo)
            ->setState($state);
    }
    /**
     * Get ElementMetadata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SerializedDefinitionNode|null
     */
    public function getElementMetadata()
    {
        return isset($this->ElementMetadata) ? $this->ElementMetadata : null;
    }
    /**
     * Set ElementMetadata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SerializedDefinitionNode $elementMetadata
     * @return \patest\StructType\TransactionInteractionFlowResponseItem
     */
    public function setElementMetadata(\patest\StructType\SerializedDefinitionNode $elementMetadata = null)
    {
        if (is_null($elementMetadata) || (is_array($elementMetadata) && empty($elementMetadata))) {
            unset($this->ElementMetadata);
        } else {
            $this->ElementMetadata = $elementMetadata;
        }
        return $this;
    }
    /**
     * Get ElementName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElementName()
    {
        return isset($this->ElementName) ? $this->ElementName : null;
    }
    /**
     * Set ElementName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $elementName
     * @return \patest\StructType\TransactionInteractionFlowResponseItem
     */
    public function setElementName($elementName = null)
    {
        // validation for constraint: string
        if (!is_null($elementName) && !is_string($elementName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementName, true), gettype($elementName)), __LINE__);
        }
        if (is_null($elementName) || (is_array($elementName) && empty($elementName))) {
            unset($this->ElementName);
        } else {
            $this->ElementName = $elementName;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\FailureInformation|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\FailureInformation $error
     * @return \patest\StructType\TransactionInteractionFlowResponseItem
     */
    public function setError(\patest\StructType\FailureInformation $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get RequiredInteractionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SerializedObject|null
     */
    public function getRequiredInteractionInfo()
    {
        return isset($this->RequiredInteractionInfo) ? $this->RequiredInteractionInfo : null;
    }
    /**
     * Set RequiredInteractionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SerializedObject $requiredInteractionInfo
     * @return \patest\StructType\TransactionInteractionFlowResponseItem
     */
    public function setRequiredInteractionInfo(\patest\StructType\SerializedObject $requiredInteractionInfo = null)
    {
        if (is_null($requiredInteractionInfo) || (is_array($requiredInteractionInfo) && empty($requiredInteractionInfo))) {
            unset($this->RequiredInteractionInfo);
        } else {
            $this->RequiredInteractionInfo = $requiredInteractionInfo;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SerializedObject|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SerializedObject $state
     * @return \patest\StructType\TransactionInteractionFlowResponseItem
     */
    public function setState(\patest\StructType\SerializedObject $state = null)
    {
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
}
