<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionDataMin StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionDataMin
 * @subpackage Structs
 */
class TransactionDataMin extends TransactionGuidData
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The ClientCreditItemDataInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfClientCreditItemData
     */
    public $ClientCreditItemDataInfo;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactId;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The DonationItemDataInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfDonationSaleItem
     */
    public $DonationItemDataInfo;
    /**
     * The MerchandiseItemDataInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfMerchandiseSaleItem
     */
    public $MerchandiseItemDataInfo;
    /**
     * The NumberOfActiveItemsInThisTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfActiveItemsInThisTransaction;
    /**
     * The NumberOfItemsReturnedInThisTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfItemsReturnedInThisTransaction;
    /**
     * The NumberOfItemsSoldInThisTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfItemsSoldInThisTransaction;
    /**
     * The NumberOfItemsSoldInTransactionAndReturnedLater
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfItemsSoldInTransactionAndReturnedLater;
    /**
     * The PaymentItemDataInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPaymentItemData
     */
    public $PaymentItemDataInfo;
    /**
     * The TicketsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketItemDataFromSaleService
     */
    public $TicketsInfo;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionNumber;
    /**
     * The NumberOfItemsContinuedInThisTransactionOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfItemsContinuedInThisTransactionOnly;
    /**
     * The NumberOfItemsSoldInThisTransactionOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfItemsSoldInThisTransactionOnly;
    /**
     * Constructor method for TransactionDataMin
     * @uses TransactionDataMin::setApplicationChannel()
     * @uses TransactionDataMin::setClientCreditItemDataInfo()
     * @uses TransactionDataMin::setContactId()
     * @uses TransactionDataMin::setDate()
     * @uses TransactionDataMin::setDonationItemDataInfo()
     * @uses TransactionDataMin::setMerchandiseItemDataInfo()
     * @uses TransactionDataMin::setNumberOfActiveItemsInThisTransaction()
     * @uses TransactionDataMin::setNumberOfItemsReturnedInThisTransaction()
     * @uses TransactionDataMin::setNumberOfItemsSoldInThisTransaction()
     * @uses TransactionDataMin::setNumberOfItemsSoldInTransactionAndReturnedLater()
     * @uses TransactionDataMin::setPaymentItemDataInfo()
     * @uses TransactionDataMin::setTicketsInfo()
     * @uses TransactionDataMin::setTransactionNumber()
     * @uses TransactionDataMin::setNumberOfItemsContinuedInThisTransactionOnly()
     * @uses TransactionDataMin::setNumberOfItemsSoldInThisTransactionOnly()
     * @param string $applicationChannel
     * @param \patest\ArrayType\ArrayOfClientCreditItemData $clientCreditItemDataInfo
     * @param string $contactId
     * @param string $date
     * @param \patest\ArrayType\ArrayOfDonationSaleItem $donationItemDataInfo
     * @param \patest\ArrayType\ArrayOfMerchandiseSaleItem $merchandiseItemDataInfo
     * @param int $numberOfActiveItemsInThisTransaction
     * @param int $numberOfItemsReturnedInThisTransaction
     * @param int $numberOfItemsSoldInThisTransaction
     * @param int $numberOfItemsSoldInTransactionAndReturnedLater
     * @param \patest\ArrayType\ArrayOfPaymentItemData $paymentItemDataInfo
     * @param \patest\ArrayType\ArrayOfTicketItemDataFromSaleService $ticketsInfo
     * @param int $transactionNumber
     * @param int $numberOfItemsContinuedInThisTransactionOnly
     * @param int $numberOfItemsSoldInThisTransactionOnly
     */
    public function __construct($applicationChannel = null, \patest\ArrayType\ArrayOfClientCreditItemData $clientCreditItemDataInfo = null, $contactId = null, $date = null, \patest\ArrayType\ArrayOfDonationSaleItem $donationItemDataInfo = null, \patest\ArrayType\ArrayOfMerchandiseSaleItem $merchandiseItemDataInfo = null, $numberOfActiveItemsInThisTransaction = null, $numberOfItemsReturnedInThisTransaction = null, $numberOfItemsSoldInThisTransaction = null, $numberOfItemsSoldInTransactionAndReturnedLater = null, \patest\ArrayType\ArrayOfPaymentItemData $paymentItemDataInfo = null, \patest\ArrayType\ArrayOfTicketItemDataFromSaleService $ticketsInfo = null, $transactionNumber = null, $numberOfItemsContinuedInThisTransactionOnly = null, $numberOfItemsSoldInThisTransactionOnly = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setClientCreditItemDataInfo($clientCreditItemDataInfo)
            ->setContactId($contactId)
            ->setDate($date)
            ->setDonationItemDataInfo($donationItemDataInfo)
            ->setMerchandiseItemDataInfo($merchandiseItemDataInfo)
            ->setNumberOfActiveItemsInThisTransaction($numberOfActiveItemsInThisTransaction)
            ->setNumberOfItemsReturnedInThisTransaction($numberOfItemsReturnedInThisTransaction)
            ->setNumberOfItemsSoldInThisTransaction($numberOfItemsSoldInThisTransaction)
            ->setNumberOfItemsSoldInTransactionAndReturnedLater($numberOfItemsSoldInTransactionAndReturnedLater)
            ->setPaymentItemDataInfo($paymentItemDataInfo)
            ->setTicketsInfo($ticketsInfo)
            ->setTransactionNumber($transactionNumber)
            ->setNumberOfItemsContinuedInThisTransactionOnly($numberOfItemsContinuedInThisTransactionOnly)
            ->setNumberOfItemsSoldInThisTransactionOnly($numberOfItemsSoldInThisTransactionOnly);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\TransactionDataMin
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get ClientCreditItemDataInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfClientCreditItemData|null
     */
    public function getClientCreditItemDataInfo()
    {
        return isset($this->ClientCreditItemDataInfo) ? $this->ClientCreditItemDataInfo : null;
    }
    /**
     * Set ClientCreditItemDataInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfClientCreditItemData $clientCreditItemDataInfo
     * @return \patest\StructType\TransactionDataMin
     */
    public function setClientCreditItemDataInfo(\patest\ArrayType\ArrayOfClientCreditItemData $clientCreditItemDataInfo = null)
    {
        if (is_null($clientCreditItemDataInfo) || (is_array($clientCreditItemDataInfo) && empty($clientCreditItemDataInfo))) {
            unset($this->ClientCreditItemDataInfo);
        } else {
            $this->ClientCreditItemDataInfo = $clientCreditItemDataInfo;
        }
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \patest\StructType\TransactionDataMin
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactId, true)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \patest\StructType\TransactionDataMin
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get DonationItemDataInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfDonationSaleItem|null
     */
    public function getDonationItemDataInfo()
    {
        return isset($this->DonationItemDataInfo) ? $this->DonationItemDataInfo : null;
    }
    /**
     * Set DonationItemDataInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfDonationSaleItem $donationItemDataInfo
     * @return \patest\StructType\TransactionDataMin
     */
    public function setDonationItemDataInfo(\patest\ArrayType\ArrayOfDonationSaleItem $donationItemDataInfo = null)
    {
        if (is_null($donationItemDataInfo) || (is_array($donationItemDataInfo) && empty($donationItemDataInfo))) {
            unset($this->DonationItemDataInfo);
        } else {
            $this->DonationItemDataInfo = $donationItemDataInfo;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemDataInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfMerchandiseSaleItem|null
     */
    public function getMerchandiseItemDataInfo()
    {
        return isset($this->MerchandiseItemDataInfo) ? $this->MerchandiseItemDataInfo : null;
    }
    /**
     * Set MerchandiseItemDataInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfMerchandiseSaleItem $merchandiseItemDataInfo
     * @return \patest\StructType\TransactionDataMin
     */
    public function setMerchandiseItemDataInfo(\patest\ArrayType\ArrayOfMerchandiseSaleItem $merchandiseItemDataInfo = null)
    {
        if (is_null($merchandiseItemDataInfo) || (is_array($merchandiseItemDataInfo) && empty($merchandiseItemDataInfo))) {
            unset($this->MerchandiseItemDataInfo);
        } else {
            $this->MerchandiseItemDataInfo = $merchandiseItemDataInfo;
        }
        return $this;
    }
    /**
     * Get NumberOfActiveItemsInThisTransaction value
     * @return int|null
     */
    public function getNumberOfActiveItemsInThisTransaction()
    {
        return $this->NumberOfActiveItemsInThisTransaction;
    }
    /**
     * Set NumberOfActiveItemsInThisTransaction value
     * @param int $numberOfActiveItemsInThisTransaction
     * @return \patest\StructType\TransactionDataMin
     */
    public function setNumberOfActiveItemsInThisTransaction($numberOfActiveItemsInThisTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfActiveItemsInThisTransaction) && !(is_int($numberOfActiveItemsInThisTransaction) || ctype_digit($numberOfActiveItemsInThisTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfActiveItemsInThisTransaction, true), gettype($numberOfActiveItemsInThisTransaction)), __LINE__);
        }
        $this->NumberOfActiveItemsInThisTransaction = $numberOfActiveItemsInThisTransaction;
        return $this;
    }
    /**
     * Get NumberOfItemsReturnedInThisTransaction value
     * @return int|null
     */
    public function getNumberOfItemsReturnedInThisTransaction()
    {
        return $this->NumberOfItemsReturnedInThisTransaction;
    }
    /**
     * Set NumberOfItemsReturnedInThisTransaction value
     * @param int $numberOfItemsReturnedInThisTransaction
     * @return \patest\StructType\TransactionDataMin
     */
    public function setNumberOfItemsReturnedInThisTransaction($numberOfItemsReturnedInThisTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfItemsReturnedInThisTransaction) && !(is_int($numberOfItemsReturnedInThisTransaction) || ctype_digit($numberOfItemsReturnedInThisTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfItemsReturnedInThisTransaction, true), gettype($numberOfItemsReturnedInThisTransaction)), __LINE__);
        }
        $this->NumberOfItemsReturnedInThisTransaction = $numberOfItemsReturnedInThisTransaction;
        return $this;
    }
    /**
     * Get NumberOfItemsSoldInThisTransaction value
     * @return int|null
     */
    public function getNumberOfItemsSoldInThisTransaction()
    {
        return $this->NumberOfItemsSoldInThisTransaction;
    }
    /**
     * Set NumberOfItemsSoldInThisTransaction value
     * @param int $numberOfItemsSoldInThisTransaction
     * @return \patest\StructType\TransactionDataMin
     */
    public function setNumberOfItemsSoldInThisTransaction($numberOfItemsSoldInThisTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfItemsSoldInThisTransaction) && !(is_int($numberOfItemsSoldInThisTransaction) || ctype_digit($numberOfItemsSoldInThisTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfItemsSoldInThisTransaction, true), gettype($numberOfItemsSoldInThisTransaction)), __LINE__);
        }
        $this->NumberOfItemsSoldInThisTransaction = $numberOfItemsSoldInThisTransaction;
        return $this;
    }
    /**
     * Get NumberOfItemsSoldInTransactionAndReturnedLater value
     * @return int|null
     */
    public function getNumberOfItemsSoldInTransactionAndReturnedLater()
    {
        return $this->NumberOfItemsSoldInTransactionAndReturnedLater;
    }
    /**
     * Set NumberOfItemsSoldInTransactionAndReturnedLater value
     * @param int $numberOfItemsSoldInTransactionAndReturnedLater
     * @return \patest\StructType\TransactionDataMin
     */
    public function setNumberOfItemsSoldInTransactionAndReturnedLater($numberOfItemsSoldInTransactionAndReturnedLater = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfItemsSoldInTransactionAndReturnedLater) && !(is_int($numberOfItemsSoldInTransactionAndReturnedLater) || ctype_digit($numberOfItemsSoldInTransactionAndReturnedLater))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfItemsSoldInTransactionAndReturnedLater, true), gettype($numberOfItemsSoldInTransactionAndReturnedLater)), __LINE__);
        }
        $this->NumberOfItemsSoldInTransactionAndReturnedLater = $numberOfItemsSoldInTransactionAndReturnedLater;
        return $this;
    }
    /**
     * Get PaymentItemDataInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPaymentItemData|null
     */
    public function getPaymentItemDataInfo()
    {
        return isset($this->PaymentItemDataInfo) ? $this->PaymentItemDataInfo : null;
    }
    /**
     * Set PaymentItemDataInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPaymentItemData $paymentItemDataInfo
     * @return \patest\StructType\TransactionDataMin
     */
    public function setPaymentItemDataInfo(\patest\ArrayType\ArrayOfPaymentItemData $paymentItemDataInfo = null)
    {
        if (is_null($paymentItemDataInfo) || (is_array($paymentItemDataInfo) && empty($paymentItemDataInfo))) {
            unset($this->PaymentItemDataInfo);
        } else {
            $this->PaymentItemDataInfo = $paymentItemDataInfo;
        }
        return $this;
    }
    /**
     * Get TicketsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketItemDataFromSaleService|null
     */
    public function getTicketsInfo()
    {
        return isset($this->TicketsInfo) ? $this->TicketsInfo : null;
    }
    /**
     * Set TicketsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketItemDataFromSaleService $ticketsInfo
     * @return \patest\StructType\TransactionDataMin
     */
    public function setTicketsInfo(\patest\ArrayType\ArrayOfTicketItemDataFromSaleService $ticketsInfo = null)
    {
        if (is_null($ticketsInfo) || (is_array($ticketsInfo) && empty($ticketsInfo))) {
            unset($this->TicketsInfo);
        } else {
            $this->TicketsInfo = $ticketsInfo;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return $this->TransactionNumber;
    }
    /**
     * Set TransactionNumber value
     * @param int $transactionNumber
     * @return \patest\StructType\TransactionDataMin
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->TransactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get NumberOfItemsContinuedInThisTransactionOnly value
     * @return int|null
     */
    public function getNumberOfItemsContinuedInThisTransactionOnly()
    {
        return $this->NumberOfItemsContinuedInThisTransactionOnly;
    }
    /**
     * Set NumberOfItemsContinuedInThisTransactionOnly value
     * @param int $numberOfItemsContinuedInThisTransactionOnly
     * @return \patest\StructType\TransactionDataMin
     */
    public function setNumberOfItemsContinuedInThisTransactionOnly($numberOfItemsContinuedInThisTransactionOnly = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfItemsContinuedInThisTransactionOnly) && !(is_int($numberOfItemsContinuedInThisTransactionOnly) || ctype_digit($numberOfItemsContinuedInThisTransactionOnly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfItemsContinuedInThisTransactionOnly, true), gettype($numberOfItemsContinuedInThisTransactionOnly)), __LINE__);
        }
        $this->NumberOfItemsContinuedInThisTransactionOnly = $numberOfItemsContinuedInThisTransactionOnly;
        return $this;
    }
    /**
     * Get NumberOfItemsSoldInThisTransactionOnly value
     * @return int|null
     */
    public function getNumberOfItemsSoldInThisTransactionOnly()
    {
        return $this->NumberOfItemsSoldInThisTransactionOnly;
    }
    /**
     * Set NumberOfItemsSoldInThisTransactionOnly value
     * @param int $numberOfItemsSoldInThisTransactionOnly
     * @return \patest\StructType\TransactionDataMin
     */
    public function setNumberOfItemsSoldInThisTransactionOnly($numberOfItemsSoldInThisTransactionOnly = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfItemsSoldInThisTransactionOnly) && !(is_int($numberOfItemsSoldInThisTransactionOnly) || ctype_digit($numberOfItemsSoldInThisTransactionOnly))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfItemsSoldInThisTransactionOnly, true), gettype($numberOfItemsSoldInThisTransactionOnly)), __LINE__);
        }
        $this->NumberOfItemsSoldInThisTransactionOnly = $numberOfItemsSoldInThisTransactionOnly;
        return $this;
    }
}
