<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Turnstile StructType
 * @subpackage Structs
 */
class Ticketing_Turnstile extends Ticketing_Base
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_EntityAccessControlData
     */
    public $AccessControlData;
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The ClientTypeAreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeAreaIds
     */
    public $ClientTypeAreaIds;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeIds
     */
    public $ClientTypeIds;
    /**
     * The ControlsEntranceTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ControlledEntrance
     * @var string
     */
    public $ControlsEntranceTo;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The ParentRecordId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentRecordId;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * The PrintedName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PrintedName;
    /**
     * The RequiresOuterEntryForInnerEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RequiresOuterEntryForInnerEntry;
    /**
     * Constructor method for Ticketing.Turnstile
     * @uses Ticketing_Turnstile::setAccessControlData()
     * @uses Ticketing_Turnstile::setAreaIds()
     * @uses Ticketing_Turnstile::setClientTypeAreaIds()
     * @uses Ticketing_Turnstile::setClientTypeIds()
     * @uses Ticketing_Turnstile::setControlsEntranceTo()
     * @uses Ticketing_Turnstile::setDescription()
     * @uses Ticketing_Turnstile::setHallId()
     * @uses Ticketing_Turnstile::setHallName()
     * @uses Ticketing_Turnstile::setHallVersionId()
     * @uses Ticketing_Turnstile::setIsActive()
     * @uses Ticketing_Turnstile::setName()
     * @uses Ticketing_Turnstile::setParentRecordId()
     * @uses Ticketing_Turnstile::setPriceLevelIds()
     * @uses Ticketing_Turnstile::setPriceTypeIds()
     * @uses Ticketing_Turnstile::setPrintedName()
     * @uses Ticketing_Turnstile::setRequiresOuterEntryForInnerEntry()
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @param \patest\StructType\AreaIds $areaIds
     * @param \patest\StructType\ClientTypeAreaIds $clientTypeAreaIds
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @param string $controlsEntranceTo
     * @param \patest\StructType\GlobalString $description
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param string $hallVersionId
     * @param bool $isActive
     * @param \patest\StructType\GlobalString $name
     * @param string $parentRecordId
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @param \patest\StructType\GlobalString $printedName
     * @param bool $requiresOuterEntryForInnerEntry
     */
    public function __construct(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null, \patest\StructType\AreaIds $areaIds = null, \patest\StructType\ClientTypeAreaIds $clientTypeAreaIds = null, \patest\StructType\ClientTypeIds $clientTypeIds = null, $controlsEntranceTo = null, \patest\StructType\GlobalString $description = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $hallVersionId = null, $isActive = null, \patest\StructType\GlobalString $name = null, $parentRecordId = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, \patest\StructType\PriceTypeIds $priceTypeIds = null, \patest\StructType\GlobalString $printedName = null, $requiresOuterEntryForInnerEntry = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setAreaIds($areaIds)
            ->setClientTypeAreaIds($clientTypeAreaIds)
            ->setClientTypeIds($clientTypeIds)
            ->setControlsEntranceTo($controlsEntranceTo)
            ->setDescription($description)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setHallVersionId($hallVersionId)
            ->setIsActive($isActive)
            ->setName($name)
            ->setParentRecordId($parentRecordId)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriceTypeIds($priceTypeIds)
            ->setPrintedName($printedName)
            ->setRequiresOuterEntryForInnerEntry($requiresOuterEntryForInnerEntry);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_EntityAccessControlData|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setAccessControlData(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get ClientTypeAreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeAreaIds|null
     */
    public function getClientTypeAreaIds()
    {
        return isset($this->ClientTypeAreaIds) ? $this->ClientTypeAreaIds : null;
    }
    /**
     * Set ClientTypeAreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeAreaIds $clientTypeAreaIds
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setClientTypeAreaIds(\patest\StructType\ClientTypeAreaIds $clientTypeAreaIds = null)
    {
        if (is_null($clientTypeAreaIds) || (is_array($clientTypeAreaIds) && empty($clientTypeAreaIds))) {
            unset($this->ClientTypeAreaIds);
        } else {
            $this->ClientTypeAreaIds = $clientTypeAreaIds;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeIds|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setClientTypeIds(\patest\StructType\ClientTypeIds $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get ControlsEntranceTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getControlsEntranceTo()
    {
        return isset($this->ControlsEntranceTo) ? $this->ControlsEntranceTo : null;
    }
    /**
     * Set ControlsEntranceTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $controlsEntranceTo
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setControlsEntranceTo($controlsEntranceTo = null)
    {
        // validation for constraint: string
        if (!is_null($controlsEntranceTo) && !is_string($controlsEntranceTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($controlsEntranceTo, true), gettype($controlsEntranceTo)), __LINE__);
        }
        if (is_null($controlsEntranceTo) || (is_array($controlsEntranceTo) && empty($controlsEntranceTo))) {
            unset($this->ControlsEntranceTo);
        } else {
            $this->ControlsEntranceTo = $controlsEntranceTo;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ParentRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentRecordId()
    {
        return isset($this->ParentRecordId) ? $this->ParentRecordId : null;
    }
    /**
     * Set ParentRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentRecordId
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setParentRecordId($parentRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($parentRecordId) && !is_string($parentRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRecordId, true), gettype($parentRecordId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentRecordId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentRecordId, true)), __LINE__);
        }
        if (is_null($parentRecordId) || (is_array($parentRecordId) && empty($parentRecordId))) {
            unset($this->ParentRecordId);
        } else {
            $this->ParentRecordId = $parentRecordId;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get PrintedName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPrintedName()
    {
        return isset($this->PrintedName) ? $this->PrintedName : null;
    }
    /**
     * Set PrintedName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $printedName
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setPrintedName(\patest\StructType\GlobalString $printedName = null)
    {
        if (is_null($printedName) || (is_array($printedName) && empty($printedName))) {
            unset($this->PrintedName);
        } else {
            $this->PrintedName = $printedName;
        }
        return $this;
    }
    /**
     * Get RequiresOuterEntryForInnerEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequiresOuterEntryForInnerEntry()
    {
        return isset($this->RequiresOuterEntryForInnerEntry) ? $this->RequiresOuterEntryForInnerEntry : null;
    }
    /**
     * Set RequiresOuterEntryForInnerEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $requiresOuterEntryForInnerEntry
     * @return \patest\StructType\Ticketing_Turnstile
     */
    public function setRequiresOuterEntryForInnerEntry($requiresOuterEntryForInnerEntry = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresOuterEntryForInnerEntry) && !is_bool($requiresOuterEntryForInnerEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiresOuterEntryForInnerEntry, true), gettype($requiresOuterEntryForInnerEntry)), __LINE__);
        }
        if (is_null($requiresOuterEntryForInnerEntry) || (is_array($requiresOuterEntryForInnerEntry) && empty($requiresOuterEntryForInnerEntry))) {
            unset($this->RequiresOuterEntryForInnerEntry);
        } else {
            $this->RequiresOuterEntryForInnerEntry = $requiresOuterEntryForInnerEntry;
        }
        return $this;
    }
}
