<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketWithVersions StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.TicketWithVersions
 * @subpackage Structs
 */
class Ticketing_TicketWithVersions extends Ticketing_Ticket
{
    /**
     * The IsLastVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLastVersion;
    /**
     * The OriginalSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalSubscriptionInstanceId;
    /**
     * The OriginalTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTicketId;
    /**
     * The PartyHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_PartyTicketHistory
     */
    public $PartyHistory;
    /**
     * The PartyState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_PartyTicket
     */
    public $PartyState;
    /**
     * The PreviousVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreviousVersionId;
    /**
     * The SellerBranchId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchId;
    /**
     * The SupplierBranchId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierBranchId;
    /**
     * The VersionCreationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VersionCreationReason;
    /**
     * Constructor method for Ticketing.TicketWithVersions
     * @uses Ticketing_TicketWithVersions::setIsLastVersion()
     * @uses Ticketing_TicketWithVersions::setOriginalSubscriptionInstanceId()
     * @uses Ticketing_TicketWithVersions::setOriginalTicketId()
     * @uses Ticketing_TicketWithVersions::setPartyHistory()
     * @uses Ticketing_TicketWithVersions::setPartyState()
     * @uses Ticketing_TicketWithVersions::setPreviousVersionId()
     * @uses Ticketing_TicketWithVersions::setSellerBranchId()
     * @uses Ticketing_TicketWithVersions::setSupplierBranchId()
     * @uses Ticketing_TicketWithVersions::setVersionCreationReason()
     * @param bool $isLastVersion
     * @param string $originalSubscriptionInstanceId
     * @param string $originalTicketId
     * @param \patest\StructType\RecordSetOfTicketing_PartyTicketHistory $partyHistory
     * @param \patest\StructType\Ticketing_PartyTicket $partyState
     * @param string $previousVersionId
     * @param string $sellerBranchId
     * @param string $supplierBranchId
     * @param string $versionCreationReason
     */
    public function __construct($isLastVersion = null, $originalSubscriptionInstanceId = null, $originalTicketId = null, \patest\StructType\RecordSetOfTicketing_PartyTicketHistory $partyHistory = null, \patest\StructType\Ticketing_PartyTicket $partyState = null, $previousVersionId = null, $sellerBranchId = null, $supplierBranchId = null, $versionCreationReason = null)
    {
        $this
            ->setIsLastVersion($isLastVersion)
            ->setOriginalSubscriptionInstanceId($originalSubscriptionInstanceId)
            ->setOriginalTicketId($originalTicketId)
            ->setPartyHistory($partyHistory)
            ->setPartyState($partyState)
            ->setPreviousVersionId($previousVersionId)
            ->setSellerBranchId($sellerBranchId)
            ->setSupplierBranchId($supplierBranchId)
            ->setVersionCreationReason($versionCreationReason);
    }
    /**
     * Get IsLastVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLastVersion()
    {
        return isset($this->IsLastVersion) ? $this->IsLastVersion : null;
    }
    /**
     * Set IsLastVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLastVersion
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setIsLastVersion($isLastVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLastVersion) && !is_bool($isLastVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLastVersion, true), gettype($isLastVersion)), __LINE__);
        }
        if (is_null($isLastVersion) || (is_array($isLastVersion) && empty($isLastVersion))) {
            unset($this->IsLastVersion);
        } else {
            $this->IsLastVersion = $isLastVersion;
        }
        return $this;
    }
    /**
     * Get OriginalSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalSubscriptionInstanceId()
    {
        return isset($this->OriginalSubscriptionInstanceId) ? $this->OriginalSubscriptionInstanceId : null;
    }
    /**
     * Set OriginalSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setOriginalSubscriptionInstanceId($originalSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($originalSubscriptionInstanceId) && !is_string($originalSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalSubscriptionInstanceId, true), gettype($originalSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($originalSubscriptionInstanceId) || (is_array($originalSubscriptionInstanceId) && empty($originalSubscriptionInstanceId))) {
            unset($this->OriginalSubscriptionInstanceId);
        } else {
            $this->OriginalSubscriptionInstanceId = $originalSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get OriginalTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTicketId()
    {
        return isset($this->OriginalTicketId) ? $this->OriginalTicketId : null;
    }
    /**
     * Set OriginalTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTicketId
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setOriginalTicketId($originalTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketId) && !is_string($originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketId, true), gettype($originalTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTicketId, true)), __LINE__);
        }
        if (is_null($originalTicketId) || (is_array($originalTicketId) && empty($originalTicketId))) {
            unset($this->OriginalTicketId);
        } else {
            $this->OriginalTicketId = $originalTicketId;
        }
        return $this;
    }
    /**
     * Get PartyHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_PartyTicketHistory|null
     */
    public function getPartyHistory()
    {
        return isset($this->PartyHistory) ? $this->PartyHistory : null;
    }
    /**
     * Set PartyHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_PartyTicketHistory $partyHistory
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setPartyHistory(\patest\StructType\RecordSetOfTicketing_PartyTicketHistory $partyHistory = null)
    {
        if (is_null($partyHistory) || (is_array($partyHistory) && empty($partyHistory))) {
            unset($this->PartyHistory);
        } else {
            $this->PartyHistory = $partyHistory;
        }
        return $this;
    }
    /**
     * Get PartyState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_PartyTicket|null
     */
    public function getPartyState()
    {
        return isset($this->PartyState) ? $this->PartyState : null;
    }
    /**
     * Set PartyState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_PartyTicket $partyState
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setPartyState(\patest\StructType\Ticketing_PartyTicket $partyState = null)
    {
        if (is_null($partyState) || (is_array($partyState) && empty($partyState))) {
            unset($this->PartyState);
        } else {
            $this->PartyState = $partyState;
        }
        return $this;
    }
    /**
     * Get PreviousVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousVersionId()
    {
        return isset($this->PreviousVersionId) ? $this->PreviousVersionId : null;
    }
    /**
     * Set PreviousVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousVersionId
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setPreviousVersionId($previousVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($previousVersionId) && !is_string($previousVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousVersionId, true), gettype($previousVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($previousVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $previousVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($previousVersionId, true)), __LINE__);
        }
        if (is_null($previousVersionId) || (is_array($previousVersionId) && empty($previousVersionId))) {
            unset($this->PreviousVersionId);
        } else {
            $this->PreviousVersionId = $previousVersionId;
        }
        return $this;
    }
    /**
     * Get SellerBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerBranchId()
    {
        return isset($this->SellerBranchId) ? $this->SellerBranchId : null;
    }
    /**
     * Set SellerBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerBranchId
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setSellerBranchId($sellerBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchId) && !is_string($sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchId, true), gettype($sellerBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchId, true)), __LINE__);
        }
        if (is_null($sellerBranchId) || (is_array($sellerBranchId) && empty($sellerBranchId))) {
            unset($this->SellerBranchId);
        } else {
            $this->SellerBranchId = $sellerBranchId;
        }
        return $this;
    }
    /**
     * Get SupplierBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierBranchId()
    {
        return isset($this->SupplierBranchId) ? $this->SupplierBranchId : null;
    }
    /**
     * Set SupplierBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierBranchId
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setSupplierBranchId($supplierBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierBranchId) && !is_string($supplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierBranchId, true), gettype($supplierBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierBranchId, true)), __LINE__);
        }
        if (is_null($supplierBranchId) || (is_array($supplierBranchId) && empty($supplierBranchId))) {
            unset($this->SupplierBranchId);
        } else {
            $this->SupplierBranchId = $supplierBranchId;
        }
        return $this;
    }
    /**
     * Get VersionCreationReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersionCreationReason()
    {
        return isset($this->VersionCreationReason) ? $this->VersionCreationReason : null;
    }
    /**
     * Set VersionCreationReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versionCreationReason
     * @return \patest\StructType\Ticketing_TicketWithVersions
     */
    public function setVersionCreationReason($versionCreationReason = null)
    {
        // validation for constraint: string
        if (!is_null($versionCreationReason) && !is_string($versionCreationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionCreationReason, true), gettype($versionCreationReason)), __LINE__);
        }
        if (is_null($versionCreationReason) || (is_array($versionCreationReason) && empty($versionCreationReason))) {
            unset($this->VersionCreationReason);
        } else {
            $this->VersionCreationReason = $versionCreationReason;
        }
        return $this;
    }
}
