<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketWithHolder StructType
 * @subpackage Structs
 */
class Ticketing_TicketWithHolder extends Ticketing_TransactionTicketDetails
{
    /**
     * The CanBeDistributed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanBeDistributed;
    /**
     * The HasTicketHolder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasTicketHolder;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The TicketHolder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public $TicketHolder;
    /**
     * Constructor method for Ticketing.TicketWithHolder
     * @uses Ticketing_TicketWithHolder::setCanBeDistributed()
     * @uses Ticketing_TicketWithHolder::setHasTicketHolder()
     * @uses Ticketing_TicketWithHolder::setIsSelected()
     * @uses Ticketing_TicketWithHolder::setTicketHolder()
     * @param bool $canBeDistributed
     * @param bool $hasTicketHolder
     * @param bool $isSelected
     * @param \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder
     */
    public function __construct($canBeDistributed = null, $hasTicketHolder = null, $isSelected = null, \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder = null)
    {
        $this
            ->setCanBeDistributed($canBeDistributed)
            ->setHasTicketHolder($hasTicketHolder)
            ->setIsSelected($isSelected)
            ->setTicketHolder($ticketHolder);
    }
    /**
     * Get CanBeDistributed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanBeDistributed()
    {
        return isset($this->CanBeDistributed) ? $this->CanBeDistributed : null;
    }
    /**
     * Set CanBeDistributed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canBeDistributed
     * @return \patest\StructType\Ticketing_TicketWithHolder
     */
    public function setCanBeDistributed($canBeDistributed = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeDistributed) && !is_bool($canBeDistributed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeDistributed, true), gettype($canBeDistributed)), __LINE__);
        }
        if (is_null($canBeDistributed) || (is_array($canBeDistributed) && empty($canBeDistributed))) {
            unset($this->CanBeDistributed);
        } else {
            $this->CanBeDistributed = $canBeDistributed;
        }
        return $this;
    }
    /**
     * Get HasTicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasTicketHolder()
    {
        return isset($this->HasTicketHolder) ? $this->HasTicketHolder : null;
    }
    /**
     * Set HasTicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasTicketHolder
     * @return \patest\StructType\Ticketing_TicketWithHolder
     */
    public function setHasTicketHolder($hasTicketHolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTicketHolder) && !is_bool($hasTicketHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTicketHolder, true), gettype($hasTicketHolder)), __LINE__);
        }
        if (is_null($hasTicketHolder) || (is_array($hasTicketHolder) && empty($hasTicketHolder))) {
            unset($this->HasTicketHolder);
        } else {
            $this->HasTicketHolder = $hasTicketHolder;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Ticketing_TicketWithHolder
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get TicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_TicketDistributionJournal|null
     */
    public function getTicketHolder()
    {
        return isset($this->TicketHolder) ? $this->TicketHolder : null;
    }
    /**
     * Set TicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder
     * @return \patest\StructType\Ticketing_TicketWithHolder
     */
    public function setTicketHolder(\patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder = null)
    {
        if (is_null($ticketHolder) || (is_array($ticketHolder) && empty($ticketHolder))) {
            unset($this->TicketHolder);
        } else {
            $this->TicketHolder = $ticketHolder;
        }
        return $this;
    }
}
