<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketViewConfigurationImage StructType
 * @subpackage Structs
 */
class Ticketing_TicketViewConfigurationImage extends PersistableEntity
{
    /**
     * The AdaDominantColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdaDominantColor;
    /**
     * The DeletedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeletedAt;
    /**
     * The ImageFileExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageFileExtension;
    /**
     * The ImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImageGuid;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The TicketViewConfigurationImageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketViewConfigurationImageType;
    /**
     * Constructor method for Ticketing.TicketViewConfigurationImage
     * @uses Ticketing_TicketViewConfigurationImage::setAdaDominantColor()
     * @uses Ticketing_TicketViewConfigurationImage::setDeletedAt()
     * @uses Ticketing_TicketViewConfigurationImage::setImageFileExtension()
     * @uses Ticketing_TicketViewConfigurationImage::setImageGuid()
     * @uses Ticketing_TicketViewConfigurationImage::setIsHidden()
     * @uses Ticketing_TicketViewConfigurationImage::setName()
     * @uses Ticketing_TicketViewConfigurationImage::setOrganizationUnitId()
     * @uses Ticketing_TicketViewConfigurationImage::setTicketViewConfigurationImageType()
     * @param string $adaDominantColor
     * @param string $deletedAt
     * @param string $imageFileExtension
     * @param string $imageGuid
     * @param bool $isHidden
     * @param string $name
     * @param string $organizationUnitId
     * @param string $ticketViewConfigurationImageType
     */
    public function __construct($adaDominantColor = null, $deletedAt = null, $imageFileExtension = null, $imageGuid = null, $isHidden = null, $name = null, $organizationUnitId = null, $ticketViewConfigurationImageType = null)
    {
        $this
            ->setAdaDominantColor($adaDominantColor)
            ->setDeletedAt($deletedAt)
            ->setImageFileExtension($imageFileExtension)
            ->setImageGuid($imageGuid)
            ->setIsHidden($isHidden)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setTicketViewConfigurationImageType($ticketViewConfigurationImageType);
    }
    /**
     * Get AdaDominantColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdaDominantColor()
    {
        return isset($this->AdaDominantColor) ? $this->AdaDominantColor : null;
    }
    /**
     * Set AdaDominantColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adaDominantColor
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setAdaDominantColor($adaDominantColor = null)
    {
        // validation for constraint: string
        if (!is_null($adaDominantColor) && !is_string($adaDominantColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adaDominantColor, true), gettype($adaDominantColor)), __LINE__);
        }
        if (is_null($adaDominantColor) || (is_array($adaDominantColor) && empty($adaDominantColor))) {
            unset($this->AdaDominantColor);
        } else {
            $this->AdaDominantColor = $adaDominantColor;
        }
        return $this;
    }
    /**
     * Get DeletedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletedAt()
    {
        return isset($this->DeletedAt) ? $this->DeletedAt : null;
    }
    /**
     * Set DeletedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deletedAt
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setDeletedAt($deletedAt = null)
    {
        // validation for constraint: string
        if (!is_null($deletedAt) && !is_string($deletedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deletedAt, true), gettype($deletedAt)), __LINE__);
        }
        if (is_null($deletedAt) || (is_array($deletedAt) && empty($deletedAt))) {
            unset($this->DeletedAt);
        } else {
            $this->DeletedAt = $deletedAt;
        }
        return $this;
    }
    /**
     * Get ImageFileExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageFileExtension()
    {
        return isset($this->ImageFileExtension) ? $this->ImageFileExtension : null;
    }
    /**
     * Set ImageFileExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageFileExtension
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setImageFileExtension($imageFileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($imageFileExtension) && !is_string($imageFileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageFileExtension, true), gettype($imageFileExtension)), __LINE__);
        }
        if (is_null($imageFileExtension) || (is_array($imageFileExtension) && empty($imageFileExtension))) {
            unset($this->ImageFileExtension);
        } else {
            $this->ImageFileExtension = $imageFileExtension;
        }
        return $this;
    }
    /**
     * Get ImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageGuid()
    {
        return isset($this->ImageGuid) ? $this->ImageGuid : null;
    }
    /**
     * Set ImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageGuid
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setImageGuid($imageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($imageGuid) && !is_string($imageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageGuid, true), gettype($imageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($imageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $imageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($imageGuid, true)), __LINE__);
        }
        if (is_null($imageGuid) || (is_array($imageGuid) && empty($imageGuid))) {
            unset($this->ImageGuid);
        } else {
            $this->ImageGuid = $imageGuid;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get TicketViewConfigurationImageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketViewConfigurationImageType()
    {
        return isset($this->TicketViewConfigurationImageType) ? $this->TicketViewConfigurationImageType : null;
    }
    /**
     * Set TicketViewConfigurationImageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketViewConfigurationImageType::valueIsValid()
     * @uses \patest\EnumType\TicketViewConfigurationImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketViewConfigurationImageType
     * @return \patest\StructType\Ticketing_TicketViewConfigurationImage
     */
    public function setTicketViewConfigurationImageType($ticketViewConfigurationImageType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewConfigurationImageType::valueIsValid($ticketViewConfigurationImageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewConfigurationImageType', is_array($ticketViewConfigurationImageType) ? implode(', ', $ticketViewConfigurationImageType) : var_export($ticketViewConfigurationImageType, true), implode(', ', \patest\EnumType\TicketViewConfigurationImageType::getValidValues())), __LINE__);
        }
        if (is_null($ticketViewConfigurationImageType) || (is_array($ticketViewConfigurationImageType) && empty($ticketViewConfigurationImageType))) {
            unset($this->TicketViewConfigurationImageType);
        } else {
            $this->TicketViewConfigurationImageType = $ticketViewConfigurationImageType;
        }
        return $this;
    }
}
