<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketBase StructType
 * @subpackage Structs
 */
class Ticketing_TicketBase extends Ticketing_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The AssociatedDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDate;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientIdentification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientIdentification;
    /**
     * The ContinuedByAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContinuedByAction;
    /**
     * The ContinuedByTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContinuedByTicketId;
    /**
     * The EssentialSeatData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_EssentialEventSeatData
     */
    public $EssentialSeatData;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventDateUtc
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateUtc;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventSaleStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $EventSaleStatus;
    /**
     * The EventTimeZone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventTimeZone;
    /**
     * The EventType1Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType1Id;
    /**
     * The EventType2Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType2Id;
    /**
     * The EventType3Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType3Id;
    /**
     * The EventType4Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType4Id;
    /**
     * The EventType5Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType5Id;
    /**
     * The EventTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventTypeId;
    /**
     * The GateIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GateIds;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The HasBackwardContinuation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasBackwardContinuation;
    /**
     * The HasTicketHolder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasTicketHolder;
    /**
     * The InitiatedInSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InitiatedInSubscriptionInstanceId;
    /**
     * The IsAutoCatchInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoCatchInSubscription;
    /**
     * The IsAvailableForChangeOfOwnership
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForChangeOfOwnership;
    /**
     * The IsAvailableForResaleRequest
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForResaleRequest;
    /**
     * The IsAvailableForTicketDistribution
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForTicketDistribution;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsEffectiveInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEffectiveInSubscription;
    /**
     * The IsForResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForResale;
    /**
     * The IsHospitality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitality;
    /**
     * The IsIrregularInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIrregularInSubscription;
    /**
     * The IsMoved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMoved;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The IsOnlineForwarded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnlineForwarded;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResale;
    /**
     * The IsScanned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsScanned;
    /**
     * The IsTurnback
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTurnback;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The ItemAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemAction;
    /**
     * The LastTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastTransactionGuid;
    /**
     * The LastVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastVersionId;
    /**
     * The NumberOfOwnershipChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfOwnershipChanges;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PassbookUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassbookUrl;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceLevelName;
    /**
     * The PriceTypeChangePolicy
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_TicketPriceTypeChangePolicy
     */
    public $PriceTypeChangePolicy;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The PrintedAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedAs;
    /**
     * The PrintMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethod;
    /**
     * The PrintMethodData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethodData;
    /**
     * The RelatedSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedSubscriptionInstanceId;
    /**
     * The ResaleMethod
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleMethod;
    /**
     * The ResaleStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleStatus;
    /**
     * The RestrictionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionGuid;
    /**
     * The RoleInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoleInSubscription;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeatInfo
     */
    public $SeatInfo;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorGlobalName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorGlobalName;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ShowMinutes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowMinutes;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShowName;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * The SlotIdInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SlotIdInSubscription;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StandName;
    /**
     * The SubscriberTicketIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketIcon;
    /**
     * The SubscriberTicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketType;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The SubsidyAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SubsidyAmount;
    /**
     * The TicketHolder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_TicketDistributionJournal
     */
    public $TicketHolder;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TicketPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TicketPrice;
    /**
     * The TicketTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_TicketTransaction
     */
    public $TicketTransactions;
    /**
     * The TurnstileIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstileIds;
    /**
     * The WorthInSubscriptionBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $WorthInSubscriptionBalance;
    /**
     * Constructor method for Ticketing.TicketBase
     * @uses Ticketing_TicketBase::setAclSchemeId()
     * @uses Ticketing_TicketBase::setApplicationChannel()
     * @uses Ticketing_TicketBase::setAreaId()
     * @uses Ticketing_TicketBase::setAreaName()
     * @uses Ticketing_TicketBase::setAssociatedDate()
     * @uses Ticketing_TicketBase::setBarcode()
     * @uses Ticketing_TicketBase::setClientId()
     * @uses Ticketing_TicketBase::setClientIdentification()
     * @uses Ticketing_TicketBase::setContinuedByAction()
     * @uses Ticketing_TicketBase::setContinuedByTicketId()
     * @uses Ticketing_TicketBase::setEssentialSeatData()
     * @uses Ticketing_TicketBase::setEventDate()
     * @uses Ticketing_TicketBase::setEventDateUtc()
     * @uses Ticketing_TicketBase::setEventId()
     * @uses Ticketing_TicketBase::setEventSaleStatus()
     * @uses Ticketing_TicketBase::setEventTimeZone()
     * @uses Ticketing_TicketBase::setEventType1Id()
     * @uses Ticketing_TicketBase::setEventType2Id()
     * @uses Ticketing_TicketBase::setEventType3Id()
     * @uses Ticketing_TicketBase::setEventType4Id()
     * @uses Ticketing_TicketBase::setEventType5Id()
     * @uses Ticketing_TicketBase::setEventTypeId()
     * @uses Ticketing_TicketBase::setGateIds()
     * @uses Ticketing_TicketBase::setHallId()
     * @uses Ticketing_TicketBase::setHallName()
     * @uses Ticketing_TicketBase::setHasBackwardContinuation()
     * @uses Ticketing_TicketBase::setHasTicketHolder()
     * @uses Ticketing_TicketBase::setInitiatedInSubscriptionInstanceId()
     * @uses Ticketing_TicketBase::setIsAutoCatchInSubscription()
     * @uses Ticketing_TicketBase::setIsAvailableForChangeOfOwnership()
     * @uses Ticketing_TicketBase::setIsAvailableForResaleRequest()
     * @uses Ticketing_TicketBase::setIsAvailableForTicketDistribution()
     * @uses Ticketing_TicketBase::setIsComplimentary()
     * @uses Ticketing_TicketBase::setIsEffectiveInSubscription()
     * @uses Ticketing_TicketBase::setIsForResale()
     * @uses Ticketing_TicketBase::setIsHospitality()
     * @uses Ticketing_TicketBase::setIsIrregularInSubscription()
     * @uses Ticketing_TicketBase::setIsMoved()
     * @uses Ticketing_TicketBase::setIsObsolete()
     * @uses Ticketing_TicketBase::setIsOnlineForwarded()
     * @uses Ticketing_TicketBase::setIsPrinting()
     * @uses Ticketing_TicketBase::setIsResale()
     * @uses Ticketing_TicketBase::setIsScanned()
     * @uses Ticketing_TicketBase::setIsTurnback()
     * @uses Ticketing_TicketBase::setIsValid()
     * @uses Ticketing_TicketBase::setItemAction()
     * @uses Ticketing_TicketBase::setLastTransactionGuid()
     * @uses Ticketing_TicketBase::setLastVersionId()
     * @uses Ticketing_TicketBase::setNumberOfOwnershipChanges()
     * @uses Ticketing_TicketBase::setOrganizationUnitId()
     * @uses Ticketing_TicketBase::setPassbookUrl()
     * @uses Ticketing_TicketBase::setPriceLevelId()
     * @uses Ticketing_TicketBase::setPriceLevelName()
     * @uses Ticketing_TicketBase::setPriceTypeChangePolicy()
     * @uses Ticketing_TicketBase::setPriceTypeId()
     * @uses Ticketing_TicketBase::setPrintCount()
     * @uses Ticketing_TicketBase::setPrintedAs()
     * @uses Ticketing_TicketBase::setPrintMethod()
     * @uses Ticketing_TicketBase::setPrintMethodData()
     * @uses Ticketing_TicketBase::setRelatedSubscriptionInstanceId()
     * @uses Ticketing_TicketBase::setResaleMethod()
     * @uses Ticketing_TicketBase::setResaleStatus()
     * @uses Ticketing_TicketBase::setRestrictionGuid()
     * @uses Ticketing_TicketBase::setRoleInSubscription()
     * @uses Ticketing_TicketBase::setRowName()
     * @uses Ticketing_TicketBase::setSalesRepId()
     * @uses Ticketing_TicketBase::setSeatIdInAreaMap()
     * @uses Ticketing_TicketBase::setSeatInfo()
     * @uses Ticketing_TicketBase::setSeatName()
     * @uses Ticketing_TicketBase::setSectorGlobalName()
     * @uses Ticketing_TicketBase::setSectorId()
     * @uses Ticketing_TicketBase::setSeriesId()
     * @uses Ticketing_TicketBase::setShowId()
     * @uses Ticketing_TicketBase::setShowMinutes()
     * @uses Ticketing_TicketBase::setShowName()
     * @uses Ticketing_TicketBase::setShowTypeId()
     * @uses Ticketing_TicketBase::setSlotIdInSubscription()
     * @uses Ticketing_TicketBase::setStandName()
     * @uses Ticketing_TicketBase::setSubscriberTicketIcon()
     * @uses Ticketing_TicketBase::setSubscriberTicketType()
     * @uses Ticketing_TicketBase::setSubscriptionInstanceId()
     * @uses Ticketing_TicketBase::setSubscriptionNumber()
     * @uses Ticketing_TicketBase::setSubsidyAmount()
     * @uses Ticketing_TicketBase::setTicketHolder()
     * @uses Ticketing_TicketBase::setTicketNumber()
     * @uses Ticketing_TicketBase::setTicketPrice()
     * @uses Ticketing_TicketBase::setTicketTransactions()
     * @uses Ticketing_TicketBase::setTurnstileIds()
     * @uses Ticketing_TicketBase::setWorthInSubscriptionBalance()
     * @param int $aclSchemeId
     * @param string $applicationChannel
     * @param string $areaId
     * @param \patest\StructType\GlobalString $areaName
     * @param string $associatedDate
     * @param string $barcode
     * @param string $clientId
     * @param int $clientIdentification
     * @param string $continuedByAction
     * @param string $continuedByTicketId
     * @param \patest\StructType\Ticketing_EssentialEventSeatData $essentialSeatData
     * @param string $eventDate
     * @param string $eventDateUtc
     * @param string $eventId
     * @param string[] $eventSaleStatus
     * @param string $eventTimeZone
     * @param string $eventType1Id
     * @param string $eventType2Id
     * @param string $eventType3Id
     * @param string $eventType4Id
     * @param string $eventType5Id
     * @param string $eventTypeId
     * @param string $gateIds
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param bool $hasBackwardContinuation
     * @param bool $hasTicketHolder
     * @param string $initiatedInSubscriptionInstanceId
     * @param bool $isAutoCatchInSubscription
     * @param bool $isAvailableForChangeOfOwnership
     * @param bool $isAvailableForResaleRequest
     * @param bool $isAvailableForTicketDistribution
     * @param bool $isComplimentary
     * @param bool $isEffectiveInSubscription
     * @param bool $isForResale
     * @param bool $isHospitality
     * @param bool $isIrregularInSubscription
     * @param bool $isMoved
     * @param bool $isObsolete
     * @param bool $isOnlineForwarded
     * @param bool $isPrinting
     * @param bool $isResale
     * @param bool $isScanned
     * @param bool $isTurnback
     * @param bool $isValid
     * @param int $itemAction
     * @param string $lastTransactionGuid
     * @param string $lastVersionId
     * @param int $numberOfOwnershipChanges
     * @param string $organizationUnitId
     * @param string $passbookUrl
     * @param string $priceLevelId
     * @param \patest\StructType\GlobalString $priceLevelName
     * @param \patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy
     * @param string $priceTypeId
     * @param int $printCount
     * @param string $printedAs
     * @param string $printMethod
     * @param string $printMethodData
     * @param string $relatedSubscriptionInstanceId
     * @param string $resaleMethod
     * @param string $resaleStatus
     * @param string $restrictionGuid
     * @param string $roleInSubscription
     * @param string $rowName
     * @param string $salesRepId
     * @param int $seatIdInAreaMap
     * @param \patest\StructType\Ticketing_SeatInfo $seatInfo
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @param string $sectorId
     * @param string $seriesId
     * @param string $showId
     * @param int $showMinutes
     * @param \patest\StructType\GlobalString $showName
     * @param string $showTypeId
     * @param int $slotIdInSubscription
     * @param \patest\StructType\GlobalString $standName
     * @param string $subscriberTicketIcon
     * @param string $subscriberTicketType
     * @param string $subscriptionInstanceId
     * @param string $subscriptionNumber
     * @param \patest\StructType\Money $subsidyAmount
     * @param \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder
     * @param int $ticketNumber
     * @param \patest\StructType\Money $ticketPrice
     * @param \patest\StructType\RecordSetOfTicketing_TicketTransaction $ticketTransactions
     * @param string $turnstileIds
     * @param float $worthInSubscriptionBalance
     */
    public function __construct($aclSchemeId = null, $applicationChannel = null, $areaId = null, \patest\StructType\GlobalString $areaName = null, $associatedDate = null, $barcode = null, $clientId = null, $clientIdentification = null, $continuedByAction = null, $continuedByTicketId = null, \patest\StructType\Ticketing_EssentialEventSeatData $essentialSeatData = null, $eventDate = null, $eventDateUtc = null, $eventId = null, array $eventSaleStatus = array(), $eventTimeZone = null, $eventType1Id = null, $eventType2Id = null, $eventType3Id = null, $eventType4Id = null, $eventType5Id = null, $eventTypeId = null, $gateIds = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $hasBackwardContinuation = null, $hasTicketHolder = null, $initiatedInSubscriptionInstanceId = null, $isAutoCatchInSubscription = null, $isAvailableForChangeOfOwnership = null, $isAvailableForResaleRequest = null, $isAvailableForTicketDistribution = null, $isComplimentary = null, $isEffectiveInSubscription = null, $isForResale = null, $isHospitality = null, $isIrregularInSubscription = null, $isMoved = null, $isObsolete = null, $isOnlineForwarded = null, $isPrinting = null, $isResale = null, $isScanned = null, $isTurnback = null, $isValid = null, $itemAction = null, $lastTransactionGuid = null, $lastVersionId = null, $numberOfOwnershipChanges = null, $organizationUnitId = null, $passbookUrl = null, $priceLevelId = null, \patest\StructType\GlobalString $priceLevelName = null, \patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy = null, $priceTypeId = null, $printCount = null, $printedAs = null, $printMethod = null, $printMethodData = null, $relatedSubscriptionInstanceId = null, $resaleMethod = null, $resaleStatus = null, $restrictionGuid = null, $roleInSubscription = null, $rowName = null, $salesRepId = null, $seatIdInAreaMap = null, \patest\StructType\Ticketing_SeatInfo $seatInfo = null, $seatName = null, \patest\StructType\GlobalString $sectorGlobalName = null, $sectorId = null, $seriesId = null, $showId = null, $showMinutes = null, \patest\StructType\GlobalString $showName = null, $showTypeId = null, $slotIdInSubscription = null, \patest\StructType\GlobalString $standName = null, $subscriberTicketIcon = null, $subscriberTicketType = null, $subscriptionInstanceId = null, $subscriptionNumber = null, \patest\StructType\Money $subsidyAmount = null, \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder = null, $ticketNumber = null, \patest\StructType\Money $ticketPrice = null, \patest\StructType\RecordSetOfTicketing_TicketTransaction $ticketTransactions = null, $turnstileIds = null, $worthInSubscriptionBalance = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setApplicationChannel($applicationChannel)
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setAssociatedDate($associatedDate)
            ->setBarcode($barcode)
            ->setClientId($clientId)
            ->setClientIdentification($clientIdentification)
            ->setContinuedByAction($continuedByAction)
            ->setContinuedByTicketId($continuedByTicketId)
            ->setEssentialSeatData($essentialSeatData)
            ->setEventDate($eventDate)
            ->setEventDateUtc($eventDateUtc)
            ->setEventId($eventId)
            ->setEventSaleStatus($eventSaleStatus)
            ->setEventTimeZone($eventTimeZone)
            ->setEventType1Id($eventType1Id)
            ->setEventType2Id($eventType2Id)
            ->setEventType3Id($eventType3Id)
            ->setEventType4Id($eventType4Id)
            ->setEventType5Id($eventType5Id)
            ->setEventTypeId($eventTypeId)
            ->setGateIds($gateIds)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setHasBackwardContinuation($hasBackwardContinuation)
            ->setHasTicketHolder($hasTicketHolder)
            ->setInitiatedInSubscriptionInstanceId($initiatedInSubscriptionInstanceId)
            ->setIsAutoCatchInSubscription($isAutoCatchInSubscription)
            ->setIsAvailableForChangeOfOwnership($isAvailableForChangeOfOwnership)
            ->setIsAvailableForResaleRequest($isAvailableForResaleRequest)
            ->setIsAvailableForTicketDistribution($isAvailableForTicketDistribution)
            ->setIsComplimentary($isComplimentary)
            ->setIsEffectiveInSubscription($isEffectiveInSubscription)
            ->setIsForResale($isForResale)
            ->setIsHospitality($isHospitality)
            ->setIsIrregularInSubscription($isIrregularInSubscription)
            ->setIsMoved($isMoved)
            ->setIsObsolete($isObsolete)
            ->setIsOnlineForwarded($isOnlineForwarded)
            ->setIsPrinting($isPrinting)
            ->setIsResale($isResale)
            ->setIsScanned($isScanned)
            ->setIsTurnback($isTurnback)
            ->setIsValid($isValid)
            ->setItemAction($itemAction)
            ->setLastTransactionGuid($lastTransactionGuid)
            ->setLastVersionId($lastVersionId)
            ->setNumberOfOwnershipChanges($numberOfOwnershipChanges)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPassbookUrl($passbookUrl)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setPriceTypeChangePolicy($priceTypeChangePolicy)
            ->setPriceTypeId($priceTypeId)
            ->setPrintCount($printCount)
            ->setPrintedAs($printedAs)
            ->setPrintMethod($printMethod)
            ->setPrintMethodData($printMethodData)
            ->setRelatedSubscriptionInstanceId($relatedSubscriptionInstanceId)
            ->setResaleMethod($resaleMethod)
            ->setResaleStatus($resaleStatus)
            ->setRestrictionGuid($restrictionGuid)
            ->setRoleInSubscription($roleInSubscription)
            ->setRowName($rowName)
            ->setSalesRepId($salesRepId)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatInfo($seatInfo)
            ->setSeatName($seatName)
            ->setSectorGlobalName($sectorGlobalName)
            ->setSectorId($sectorId)
            ->setSeriesId($seriesId)
            ->setShowId($showId)
            ->setShowMinutes($showMinutes)
            ->setShowName($showName)
            ->setShowTypeId($showTypeId)
            ->setSlotIdInSubscription($slotIdInSubscription)
            ->setStandName($standName)
            ->setSubscriberTicketIcon($subscriberTicketIcon)
            ->setSubscriberTicketType($subscriberTicketType)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setSubsidyAmount($subsidyAmount)
            ->setTicketHolder($ticketHolder)
            ->setTicketNumber($ticketNumber)
            ->setTicketPrice($ticketPrice)
            ->setTicketTransactions($ticketTransactions)
            ->setTurnstileIds($turnstileIds)
            ->setWorthInSubscriptionBalance($worthInSubscriptionBalance);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get AssociatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDate()
    {
        return isset($this->AssociatedDate) ? $this->AssociatedDate : null;
    }
    /**
     * Set AssociatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDate
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setAssociatedDate($associatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDate) && !is_string($associatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDate, true), gettype($associatedDate)), __LINE__);
        }
        if (is_null($associatedDate) || (is_array($associatedDate) && empty($associatedDate))) {
            unset($this->AssociatedDate);
        } else {
            $this->AssociatedDate = $associatedDate;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientIdentification()
    {
        return isset($this->ClientIdentification) ? $this->ClientIdentification : null;
    }
    /**
     * Set ClientIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientIdentification
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setClientIdentification($clientIdentification = null)
    {
        // validation for constraint: int
        if (!is_null($clientIdentification) && !(is_int($clientIdentification) || ctype_digit($clientIdentification))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientIdentification, true), gettype($clientIdentification)), __LINE__);
        }
        if (is_null($clientIdentification) || (is_array($clientIdentification) && empty($clientIdentification))) {
            unset($this->ClientIdentification);
        } else {
            $this->ClientIdentification = $clientIdentification;
        }
        return $this;
    }
    /**
     * Get ContinuedByAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuedByAction()
    {
        return isset($this->ContinuedByAction) ? $this->ContinuedByAction : null;
    }
    /**
     * Set ContinuedByAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketContinuationAction::valueIsValid()
     * @uses \patest\EnumType\TicketContinuationAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $continuedByAction
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setContinuedByAction($continuedByAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketContinuationAction::valueIsValid($continuedByAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketContinuationAction', is_array($continuedByAction) ? implode(', ', $continuedByAction) : var_export($continuedByAction, true), implode(', ', \patest\EnumType\TicketContinuationAction::getValidValues())), __LINE__);
        }
        if (is_null($continuedByAction) || (is_array($continuedByAction) && empty($continuedByAction))) {
            unset($this->ContinuedByAction);
        } else {
            $this->ContinuedByAction = $continuedByAction;
        }
        return $this;
    }
    /**
     * Get ContinuedByTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuedByTicketId()
    {
        return isset($this->ContinuedByTicketId) ? $this->ContinuedByTicketId : null;
    }
    /**
     * Set ContinuedByTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $continuedByTicketId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setContinuedByTicketId($continuedByTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($continuedByTicketId) && !is_string($continuedByTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continuedByTicketId, true), gettype($continuedByTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($continuedByTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $continuedByTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($continuedByTicketId, true)), __LINE__);
        }
        if (is_null($continuedByTicketId) || (is_array($continuedByTicketId) && empty($continuedByTicketId))) {
            unset($this->ContinuedByTicketId);
        } else {
            $this->ContinuedByTicketId = $continuedByTicketId;
        }
        return $this;
    }
    /**
     * Get EssentialSeatData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_EssentialEventSeatData|null
     */
    public function getEssentialSeatData()
    {
        return isset($this->EssentialSeatData) ? $this->EssentialSeatData : null;
    }
    /**
     * Set EssentialSeatData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_EssentialEventSeatData $essentialSeatData
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEssentialSeatData(\patest\StructType\Ticketing_EssentialEventSeatData $essentialSeatData = null)
    {
        if (is_null($essentialSeatData) || (is_array($essentialSeatData) && empty($essentialSeatData))) {
            unset($this->EssentialSeatData);
        } else {
            $this->EssentialSeatData = $essentialSeatData;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateUtc()
    {
        return isset($this->EventDateUtc) ? $this->EventDateUtc : null;
    }
    /**
     * Set EventDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateUtc
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventDateUtc($eventDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateUtc) && !is_string($eventDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateUtc, true), gettype($eventDateUtc)), __LINE__);
        }
        if (is_null($eventDateUtc) || (is_array($eventDateUtc) && empty($eventDateUtc))) {
            unset($this->EventDateUtc);
        } else {
            $this->EventDateUtc = $eventDateUtc;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getEventSaleStatus()
    {
        return isset($this->EventSaleStatus) ? $this->EventSaleStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventSaleStatusForArrayConstraintsFromSetEventSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_TicketBaseEventSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($ticketing_TicketBaseEventSaleStatusItem)) {
                $invalidValues[] = is_object($ticketing_TicketBaseEventSaleStatusItem) ? get_class($ticketing_TicketBaseEventSaleStatusItem) : sprintf('%s(%s)', gettype($ticketing_TicketBaseEventSaleStatusItem), var_export($ticketing_TicketBaseEventSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $eventSaleStatus
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventSaleStatus(array $eventSaleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($eventSaleStatusArrayErrorMessage = self::validateEventSaleStatusForArrayConstraintsFromSetEventSaleStatus($eventSaleStatus))) {
            throw new \InvalidArgumentException($eventSaleStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($eventSaleStatus) || (is_array($eventSaleStatus) && empty($eventSaleStatus))) {
            unset($this->EventSaleStatus);
        } else {
            $this->EventSaleStatus = is_array($eventSaleStatus) ? implode(' ', $eventSaleStatus) : null;
        }
        return $this;
    }
    /**
     * Get EventTimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTimeZone()
    {
        return isset($this->EventTimeZone) ? $this->EventTimeZone : null;
    }
    /**
     * Set EventTimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTimeZone
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventTimeZone($eventTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($eventTimeZone) && !is_string($eventTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTimeZone, true), gettype($eventTimeZone)), __LINE__);
        }
        if (is_null($eventTimeZone) || (is_array($eventTimeZone) && empty($eventTimeZone))) {
            unset($this->EventTimeZone);
        } else {
            $this->EventTimeZone = $eventTimeZone;
        }
        return $this;
    }
    /**
     * Get EventType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType1Id()
    {
        return isset($this->EventType1Id) ? $this->EventType1Id : null;
    }
    /**
     * Set EventType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType1Id
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventType1Id($eventType1Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType1Id) && !is_string($eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType1Id, true), gettype($eventType1Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType1Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType1Id, true)), __LINE__);
        }
        if (is_null($eventType1Id) || (is_array($eventType1Id) && empty($eventType1Id))) {
            unset($this->EventType1Id);
        } else {
            $this->EventType1Id = $eventType1Id;
        }
        return $this;
    }
    /**
     * Get EventType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType2Id()
    {
        return isset($this->EventType2Id) ? $this->EventType2Id : null;
    }
    /**
     * Set EventType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType2Id
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventType2Id($eventType2Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType2Id) && !is_string($eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType2Id, true), gettype($eventType2Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType2Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType2Id, true)), __LINE__);
        }
        if (is_null($eventType2Id) || (is_array($eventType2Id) && empty($eventType2Id))) {
            unset($this->EventType2Id);
        } else {
            $this->EventType2Id = $eventType2Id;
        }
        return $this;
    }
    /**
     * Get EventType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType3Id()
    {
        return isset($this->EventType3Id) ? $this->EventType3Id : null;
    }
    /**
     * Set EventType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType3Id
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventType3Id($eventType3Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType3Id) && !is_string($eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType3Id, true), gettype($eventType3Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType3Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType3Id, true)), __LINE__);
        }
        if (is_null($eventType3Id) || (is_array($eventType3Id) && empty($eventType3Id))) {
            unset($this->EventType3Id);
        } else {
            $this->EventType3Id = $eventType3Id;
        }
        return $this;
    }
    /**
     * Get EventType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType4Id()
    {
        return isset($this->EventType4Id) ? $this->EventType4Id : null;
    }
    /**
     * Set EventType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType4Id
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventType4Id($eventType4Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType4Id) && !is_string($eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType4Id, true), gettype($eventType4Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType4Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType4Id, true)), __LINE__);
        }
        if (is_null($eventType4Id) || (is_array($eventType4Id) && empty($eventType4Id))) {
            unset($this->EventType4Id);
        } else {
            $this->EventType4Id = $eventType4Id;
        }
        return $this;
    }
    /**
     * Get EventType5Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType5Id()
    {
        return isset($this->EventType5Id) ? $this->EventType5Id : null;
    }
    /**
     * Set EventType5Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType5Id
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventType5Id($eventType5Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType5Id) && !is_string($eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType5Id, true), gettype($eventType5Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType5Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType5Id, true)), __LINE__);
        }
        if (is_null($eventType5Id) || (is_array($eventType5Id) && empty($eventType5Id))) {
            unset($this->EventType5Id);
        } else {
            $this->EventType5Id = $eventType5Id;
        }
        return $this;
    }
    /**
     * Get EventTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTypeId()
    {
        return isset($this->EventTypeId) ? $this->EventTypeId : null;
    }
    /**
     * Set EventTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTypeId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setEventTypeId($eventTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($eventTypeId) && !is_string($eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTypeId, true), gettype($eventTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventTypeId, true)), __LINE__);
        }
        if (is_null($eventTypeId) || (is_array($eventTypeId) && empty($eventTypeId))) {
            unset($this->EventTypeId);
        } else {
            $this->EventTypeId = $eventTypeId;
        }
        return $this;
    }
    /**
     * Get GateIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGateIds()
    {
        return isset($this->GateIds) ? $this->GateIds : null;
    }
    /**
     * Set GateIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gateIds
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setGateIds($gateIds = null)
    {
        // validation for constraint: string
        if (!is_null($gateIds) && !is_string($gateIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gateIds, true), gettype($gateIds)), __LINE__);
        }
        if (is_null($gateIds) || (is_array($gateIds) && empty($gateIds))) {
            unset($this->GateIds);
        } else {
            $this->GateIds = $gateIds;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HasBackwardContinuation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasBackwardContinuation()
    {
        return isset($this->HasBackwardContinuation) ? $this->HasBackwardContinuation : null;
    }
    /**
     * Set HasBackwardContinuation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasBackwardContinuation
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setHasBackwardContinuation($hasBackwardContinuation = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasBackwardContinuation) && !is_bool($hasBackwardContinuation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasBackwardContinuation, true), gettype($hasBackwardContinuation)), __LINE__);
        }
        if (is_null($hasBackwardContinuation) || (is_array($hasBackwardContinuation) && empty($hasBackwardContinuation))) {
            unset($this->HasBackwardContinuation);
        } else {
            $this->HasBackwardContinuation = $hasBackwardContinuation;
        }
        return $this;
    }
    /**
     * Get HasTicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasTicketHolder()
    {
        return isset($this->HasTicketHolder) ? $this->HasTicketHolder : null;
    }
    /**
     * Set HasTicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasTicketHolder
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setHasTicketHolder($hasTicketHolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTicketHolder) && !is_bool($hasTicketHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTicketHolder, true), gettype($hasTicketHolder)), __LINE__);
        }
        if (is_null($hasTicketHolder) || (is_array($hasTicketHolder) && empty($hasTicketHolder))) {
            unset($this->HasTicketHolder);
        } else {
            $this->HasTicketHolder = $hasTicketHolder;
        }
        return $this;
    }
    /**
     * Get InitiatedInSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitiatedInSubscriptionInstanceId()
    {
        return isset($this->InitiatedInSubscriptionInstanceId) ? $this->InitiatedInSubscriptionInstanceId : null;
    }
    /**
     * Set InitiatedInSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initiatedInSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setInitiatedInSubscriptionInstanceId($initiatedInSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($initiatedInSubscriptionInstanceId) && !is_string($initiatedInSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initiatedInSubscriptionInstanceId, true), gettype($initiatedInSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($initiatedInSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $initiatedInSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($initiatedInSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($initiatedInSubscriptionInstanceId) || (is_array($initiatedInSubscriptionInstanceId) && empty($initiatedInSubscriptionInstanceId))) {
            unset($this->InitiatedInSubscriptionInstanceId);
        } else {
            $this->InitiatedInSubscriptionInstanceId = $initiatedInSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get IsAutoCatchInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoCatchInSubscription()
    {
        return isset($this->IsAutoCatchInSubscription) ? $this->IsAutoCatchInSubscription : null;
    }
    /**
     * Set IsAutoCatchInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoCatchInSubscription
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsAutoCatchInSubscription($isAutoCatchInSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoCatchInSubscription) && !is_bool($isAutoCatchInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoCatchInSubscription, true), gettype($isAutoCatchInSubscription)), __LINE__);
        }
        if (is_null($isAutoCatchInSubscription) || (is_array($isAutoCatchInSubscription) && empty($isAutoCatchInSubscription))) {
            unset($this->IsAutoCatchInSubscription);
        } else {
            $this->IsAutoCatchInSubscription = $isAutoCatchInSubscription;
        }
        return $this;
    }
    /**
     * Get IsAvailableForChangeOfOwnership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForChangeOfOwnership()
    {
        return isset($this->IsAvailableForChangeOfOwnership) ? $this->IsAvailableForChangeOfOwnership : null;
    }
    /**
     * Set IsAvailableForChangeOfOwnership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForChangeOfOwnership
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsAvailableForChangeOfOwnership($isAvailableForChangeOfOwnership = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForChangeOfOwnership) && !is_bool($isAvailableForChangeOfOwnership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForChangeOfOwnership, true), gettype($isAvailableForChangeOfOwnership)), __LINE__);
        }
        if (is_null($isAvailableForChangeOfOwnership) || (is_array($isAvailableForChangeOfOwnership) && empty($isAvailableForChangeOfOwnership))) {
            unset($this->IsAvailableForChangeOfOwnership);
        } else {
            $this->IsAvailableForChangeOfOwnership = $isAvailableForChangeOfOwnership;
        }
        return $this;
    }
    /**
     * Get IsAvailableForResaleRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForResaleRequest()
    {
        return isset($this->IsAvailableForResaleRequest) ? $this->IsAvailableForResaleRequest : null;
    }
    /**
     * Set IsAvailableForResaleRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForResaleRequest
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsAvailableForResaleRequest($isAvailableForResaleRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForResaleRequest) && !is_bool($isAvailableForResaleRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForResaleRequest, true), gettype($isAvailableForResaleRequest)), __LINE__);
        }
        if (is_null($isAvailableForResaleRequest) || (is_array($isAvailableForResaleRequest) && empty($isAvailableForResaleRequest))) {
            unset($this->IsAvailableForResaleRequest);
        } else {
            $this->IsAvailableForResaleRequest = $isAvailableForResaleRequest;
        }
        return $this;
    }
    /**
     * Get IsAvailableForTicketDistribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForTicketDistribution()
    {
        return isset($this->IsAvailableForTicketDistribution) ? $this->IsAvailableForTicketDistribution : null;
    }
    /**
     * Set IsAvailableForTicketDistribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForTicketDistribution
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsAvailableForTicketDistribution($isAvailableForTicketDistribution = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForTicketDistribution) && !is_bool($isAvailableForTicketDistribution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForTicketDistribution, true), gettype($isAvailableForTicketDistribution)), __LINE__);
        }
        if (is_null($isAvailableForTicketDistribution) || (is_array($isAvailableForTicketDistribution) && empty($isAvailableForTicketDistribution))) {
            unset($this->IsAvailableForTicketDistribution);
        } else {
            $this->IsAvailableForTicketDistribution = $isAvailableForTicketDistribution;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsEffectiveInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEffectiveInSubscription()
    {
        return isset($this->IsEffectiveInSubscription) ? $this->IsEffectiveInSubscription : null;
    }
    /**
     * Set IsEffectiveInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEffectiveInSubscription
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsEffectiveInSubscription($isEffectiveInSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEffectiveInSubscription) && !is_bool($isEffectiveInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEffectiveInSubscription, true), gettype($isEffectiveInSubscription)), __LINE__);
        }
        if (is_null($isEffectiveInSubscription) || (is_array($isEffectiveInSubscription) && empty($isEffectiveInSubscription))) {
            unset($this->IsEffectiveInSubscription);
        } else {
            $this->IsEffectiveInSubscription = $isEffectiveInSubscription;
        }
        return $this;
    }
    /**
     * Get IsForResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForResale()
    {
        return isset($this->IsForResale) ? $this->IsForResale : null;
    }
    /**
     * Set IsForResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForResale
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsForResale($isForResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForResale) && !is_bool($isForResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForResale, true), gettype($isForResale)), __LINE__);
        }
        if (is_null($isForResale) || (is_array($isForResale) && empty($isForResale))) {
            unset($this->IsForResale);
        } else {
            $this->IsForResale = $isForResale;
        }
        return $this;
    }
    /**
     * Get IsHospitality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitality()
    {
        return isset($this->IsHospitality) ? $this->IsHospitality : null;
    }
    /**
     * Set IsHospitality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitality
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsHospitality($isHospitality = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitality) && !is_bool($isHospitality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitality, true), gettype($isHospitality)), __LINE__);
        }
        if (is_null($isHospitality) || (is_array($isHospitality) && empty($isHospitality))) {
            unset($this->IsHospitality);
        } else {
            $this->IsHospitality = $isHospitality;
        }
        return $this;
    }
    /**
     * Get IsIrregularInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIrregularInSubscription()
    {
        return isset($this->IsIrregularInSubscription) ? $this->IsIrregularInSubscription : null;
    }
    /**
     * Set IsIrregularInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIrregularInSubscription
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsIrregularInSubscription($isIrregularInSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIrregularInSubscription) && !is_bool($isIrregularInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIrregularInSubscription, true), gettype($isIrregularInSubscription)), __LINE__);
        }
        if (is_null($isIrregularInSubscription) || (is_array($isIrregularInSubscription) && empty($isIrregularInSubscription))) {
            unset($this->IsIrregularInSubscription);
        } else {
            $this->IsIrregularInSubscription = $isIrregularInSubscription;
        }
        return $this;
    }
    /**
     * Get IsMoved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMoved()
    {
        return isset($this->IsMoved) ? $this->IsMoved : null;
    }
    /**
     * Set IsMoved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMoved
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsMoved($isMoved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMoved) && !is_bool($isMoved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMoved, true), gettype($isMoved)), __LINE__);
        }
        if (is_null($isMoved) || (is_array($isMoved) && empty($isMoved))) {
            unset($this->IsMoved);
        } else {
            $this->IsMoved = $isMoved;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get IsOnlineForwarded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnlineForwarded()
    {
        return isset($this->IsOnlineForwarded) ? $this->IsOnlineForwarded : null;
    }
    /**
     * Set IsOnlineForwarded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnlineForwarded
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsOnlineForwarded($isOnlineForwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlineForwarded) && !is_bool($isOnlineForwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlineForwarded, true), gettype($isOnlineForwarded)), __LINE__);
        }
        if (is_null($isOnlineForwarded) || (is_array($isOnlineForwarded) && empty($isOnlineForwarded))) {
            unset($this->IsOnlineForwarded);
        } else {
            $this->IsOnlineForwarded = $isOnlineForwarded;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResale()
    {
        return isset($this->IsResale) ? $this->IsResale : null;
    }
    /**
     * Set IsResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResale
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        if (is_null($isResale) || (is_array($isResale) && empty($isResale))) {
            unset($this->IsResale);
        } else {
            $this->IsResale = $isResale;
        }
        return $this;
    }
    /**
     * Get IsScanned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsScanned()
    {
        return isset($this->IsScanned) ? $this->IsScanned : null;
    }
    /**
     * Set IsScanned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isScanned
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsScanned($isScanned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isScanned) && !is_bool($isScanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isScanned, true), gettype($isScanned)), __LINE__);
        }
        if (is_null($isScanned) || (is_array($isScanned) && empty($isScanned))) {
            unset($this->IsScanned);
        } else {
            $this->IsScanned = $isScanned;
        }
        return $this;
    }
    /**
     * Get IsTurnback value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTurnback()
    {
        return isset($this->IsTurnback) ? $this->IsTurnback : null;
    }
    /**
     * Set IsTurnback value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTurnback
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsTurnback($isTurnback = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTurnback) && !is_bool($isTurnback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTurnback, true), gettype($isTurnback)), __LINE__);
        }
        if (is_null($isTurnback) || (is_array($isTurnback) && empty($isTurnback))) {
            unset($this->IsTurnback);
        } else {
            $this->IsTurnback = $isTurnback;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get ItemAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemAction()
    {
        return isset($this->ItemAction) ? $this->ItemAction : null;
    }
    /**
     * Set ItemAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemAction
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setItemAction($itemAction = null)
    {
        // validation for constraint: int
        if (!is_null($itemAction) && !(is_int($itemAction) || ctype_digit($itemAction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAction, true), gettype($itemAction)), __LINE__);
        }
        if (is_null($itemAction) || (is_array($itemAction) && empty($itemAction))) {
            unset($this->ItemAction);
        } else {
            $this->ItemAction = $itemAction;
        }
        return $this;
    }
    /**
     * Get LastTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTransactionGuid()
    {
        return isset($this->LastTransactionGuid) ? $this->LastTransactionGuid : null;
    }
    /**
     * Set LastTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTransactionGuid
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setLastTransactionGuid($lastTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($lastTransactionGuid) && !is_string($lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTransactionGuid, true), gettype($lastTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastTransactionGuid, true)), __LINE__);
        }
        if (is_null($lastTransactionGuid) || (is_array($lastTransactionGuid) && empty($lastTransactionGuid))) {
            unset($this->LastTransactionGuid);
        } else {
            $this->LastTransactionGuid = $lastTransactionGuid;
        }
        return $this;
    }
    /**
     * Get LastVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastVersionId()
    {
        return isset($this->LastVersionId) ? $this->LastVersionId : null;
    }
    /**
     * Set LastVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastVersionId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setLastVersionId($lastVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($lastVersionId) && !is_string($lastVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastVersionId, true), gettype($lastVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastVersionId, true)), __LINE__);
        }
        if (is_null($lastVersionId) || (is_array($lastVersionId) && empty($lastVersionId))) {
            unset($this->LastVersionId);
        } else {
            $this->LastVersionId = $lastVersionId;
        }
        return $this;
    }
    /**
     * Get NumberOfOwnershipChanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfOwnershipChanges()
    {
        return isset($this->NumberOfOwnershipChanges) ? $this->NumberOfOwnershipChanges : null;
    }
    /**
     * Set NumberOfOwnershipChanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfOwnershipChanges
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setNumberOfOwnershipChanges($numberOfOwnershipChanges = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOwnershipChanges) && !(is_int($numberOfOwnershipChanges) || ctype_digit($numberOfOwnershipChanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOwnershipChanges, true), gettype($numberOfOwnershipChanges)), __LINE__);
        }
        if (is_null($numberOfOwnershipChanges) || (is_array($numberOfOwnershipChanges) && empty($numberOfOwnershipChanges))) {
            unset($this->NumberOfOwnershipChanges);
        } else {
            $this->NumberOfOwnershipChanges = $numberOfOwnershipChanges;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PassbookUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassbookUrl()
    {
        return isset($this->PassbookUrl) ? $this->PassbookUrl : null;
    }
    /**
     * Set PassbookUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passbookUrl
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPassbookUrl($passbookUrl = null)
    {
        // validation for constraint: string
        if (!is_null($passbookUrl) && !is_string($passbookUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passbookUrl, true), gettype($passbookUrl)), __LINE__);
        }
        if (is_null($passbookUrl) || (is_array($passbookUrl) && empty($passbookUrl))) {
            unset($this->PassbookUrl);
        } else {
            $this->PassbookUrl = $passbookUrl;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceLevelName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPriceLevelName(\patest\StructType\GlobalString $priceLevelName = null)
    {
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceTypeChangePolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_TicketPriceTypeChangePolicy|null
     */
    public function getPriceTypeChangePolicy()
    {
        return isset($this->PriceTypeChangePolicy) ? $this->PriceTypeChangePolicy : null;
    }
    /**
     * Set PriceTypeChangePolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPriceTypeChangePolicy(\patest\StructType\Ticketing_TicketPriceTypeChangePolicy $priceTypeChangePolicy = null)
    {
        if (is_null($priceTypeChangePolicy) || (is_array($priceTypeChangePolicy) && empty($priceTypeChangePolicy))) {
            unset($this->PriceTypeChangePolicy);
        } else {
            $this->PriceTypeChangePolicy = $priceTypeChangePolicy;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get PrintedAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedAs()
    {
        return isset($this->PrintedAs) ? $this->PrintedAs : null;
    }
    /**
     * Set PrintedAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedAs
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPrintedAs($printedAs = null)
    {
        // validation for constraint: string
        if (!is_null($printedAs) && !is_string($printedAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedAs, true), gettype($printedAs)), __LINE__);
        }
        if (is_null($printedAs) || (is_array($printedAs) && empty($printedAs))) {
            unset($this->PrintedAs);
        } else {
            $this->PrintedAs = $printedAs;
        }
        return $this;
    }
    /**
     * Get PrintMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethod()
    {
        return isset($this->PrintMethod) ? $this->PrintMethod : null;
    }
    /**
     * Set PrintMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethod
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPrintMethod($printMethod = null)
    {
        // validation for constraint: string
        if (!is_null($printMethod) && !is_string($printMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethod, true), gettype($printMethod)), __LINE__);
        }
        if (is_null($printMethod) || (is_array($printMethod) && empty($printMethod))) {
            unset($this->PrintMethod);
        } else {
            $this->PrintMethod = $printMethod;
        }
        return $this;
    }
    /**
     * Get PrintMethodData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethodData()
    {
        return isset($this->PrintMethodData) ? $this->PrintMethodData : null;
    }
    /**
     * Set PrintMethodData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethodData
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setPrintMethodData($printMethodData = null)
    {
        // validation for constraint: string
        if (!is_null($printMethodData) && !is_string($printMethodData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethodData, true), gettype($printMethodData)), __LINE__);
        }
        if (is_null($printMethodData) || (is_array($printMethodData) && empty($printMethodData))) {
            unset($this->PrintMethodData);
        } else {
            $this->PrintMethodData = $printMethodData;
        }
        return $this;
    }
    /**
     * Get RelatedSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedSubscriptionInstanceId()
    {
        return isset($this->RelatedSubscriptionInstanceId) ? $this->RelatedSubscriptionInstanceId : null;
    }
    /**
     * Set RelatedSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setRelatedSubscriptionInstanceId($relatedSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedSubscriptionInstanceId) && !is_string($relatedSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedSubscriptionInstanceId, true), gettype($relatedSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($relatedSubscriptionInstanceId) || (is_array($relatedSubscriptionInstanceId) && empty($relatedSubscriptionInstanceId))) {
            unset($this->RelatedSubscriptionInstanceId);
        } else {
            $this->RelatedSubscriptionInstanceId = $relatedSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get ResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleMethod()
    {
        return isset($this->ResaleMethod) ? $this->ResaleMethod : null;
    }
    /**
     * Set ResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleMethod
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setResaleMethod($resaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($resaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($resaleMethod) ? implode(', ', $resaleMethod) : var_export($resaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($resaleMethod) || (is_array($resaleMethod) && empty($resaleMethod))) {
            unset($this->ResaleMethod);
        } else {
            $this->ResaleMethod = $resaleMethod;
        }
        return $this;
    }
    /**
     * Get ResaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleStatus()
    {
        return isset($this->ResaleStatus) ? $this->ResaleStatus : null;
    }
    /**
     * Set ResaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResaleStatus::valueIsValid()
     * @uses \patest\EnumType\ResaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleStatus
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setResaleStatus($resaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResaleStatus::valueIsValid($resaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResaleStatus', is_array($resaleStatus) ? implode(', ', $resaleStatus) : var_export($resaleStatus, true), implode(', ', \patest\EnumType\ResaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($resaleStatus) || (is_array($resaleStatus) && empty($resaleStatus))) {
            unset($this->ResaleStatus);
        } else {
            $this->ResaleStatus = $resaleStatus;
        }
        return $this;
    }
    /**
     * Get RestrictionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionGuid()
    {
        return isset($this->RestrictionGuid) ? $this->RestrictionGuid : null;
    }
    /**
     * Set RestrictionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionGuid
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setRestrictionGuid($restrictionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionGuid) && !is_string($restrictionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionGuid, true), gettype($restrictionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionGuid, true)), __LINE__);
        }
        if (is_null($restrictionGuid) || (is_array($restrictionGuid) && empty($restrictionGuid))) {
            unset($this->RestrictionGuid);
        } else {
            $this->RestrictionGuid = $restrictionGuid;
        }
        return $this;
    }
    /**
     * Get RoleInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleInSubscription()
    {
        return isset($this->RoleInSubscription) ? $this->RoleInSubscription : null;
    }
    /**
     * Set RoleInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RoleInSubscription::valueIsValid()
     * @uses \patest\EnumType\RoleInSubscription::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleInSubscription
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setRoleInSubscription($roleInSubscription = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RoleInSubscription::valueIsValid($roleInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RoleInSubscription', is_array($roleInSubscription) ? implode(', ', $roleInSubscription) : var_export($roleInSubscription, true), implode(', ', \patest\EnumType\RoleInSubscription::getValidValues())), __LINE__);
        }
        if (is_null($roleInSubscription) || (is_array($roleInSubscription) && empty($roleInSubscription))) {
            unset($this->RoleInSubscription);
        } else {
            $this->RoleInSubscription = $roleInSubscription;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeatInfo|null
     */
    public function getSeatInfo()
    {
        return isset($this->SeatInfo) ? $this->SeatInfo : null;
    }
    /**
     * Set SeatInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeatInfo $seatInfo
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSeatInfo(\patest\StructType\Ticketing_SeatInfo $seatInfo = null)
    {
        if (is_null($seatInfo) || (is_array($seatInfo) && empty($seatInfo))) {
            unset($this->SeatInfo);
        } else {
            $this->SeatInfo = $seatInfo;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorGlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorGlobalName()
    {
        return isset($this->SectorGlobalName) ? $this->SectorGlobalName : null;
    }
    /**
     * Set SectorGlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSectorGlobalName(\patest\StructType\GlobalString $sectorGlobalName = null)
    {
        if (is_null($sectorGlobalName) || (is_array($sectorGlobalName) && empty($sectorGlobalName))) {
            unset($this->SectorGlobalName);
        } else {
            $this->SectorGlobalName = $sectorGlobalName;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ShowMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowMinutes()
    {
        return isset($this->ShowMinutes) ? $this->ShowMinutes : null;
    }
    /**
     * Set ShowMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showMinutes
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setShowMinutes($showMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($showMinutes) && !(is_int($showMinutes) || ctype_digit($showMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showMinutes, true), gettype($showMinutes)), __LINE__);
        }
        if (is_null($showMinutes) || (is_array($showMinutes) && empty($showMinutes))) {
            unset($this->ShowMinutes);
        } else {
            $this->ShowMinutes = $showMinutes;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $showName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setShowName(\patest\StructType\GlobalString $showName = null)
    {
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get ShowTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTypeId()
    {
        return isset($this->ShowTypeId) ? $this->ShowTypeId : null;
    }
    /**
     * Set ShowTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTypeId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        if (is_null($showTypeId) || (is_array($showTypeId) && empty($showTypeId))) {
            unset($this->ShowTypeId);
        } else {
            $this->ShowTypeId = $showTypeId;
        }
        return $this;
    }
    /**
     * Get SlotIdInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSlotIdInSubscription()
    {
        return isset($this->SlotIdInSubscription) ? $this->SlotIdInSubscription : null;
    }
    /**
     * Set SlotIdInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $slotIdInSubscription
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSlotIdInSubscription($slotIdInSubscription = null)
    {
        // validation for constraint: int
        if (!is_null($slotIdInSubscription) && !(is_int($slotIdInSubscription) || ctype_digit($slotIdInSubscription))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($slotIdInSubscription, true), gettype($slotIdInSubscription)), __LINE__);
        }
        if (is_null($slotIdInSubscription) || (is_array($slotIdInSubscription) && empty($slotIdInSubscription))) {
            unset($this->SlotIdInSubscription);
        } else {
            $this->SlotIdInSubscription = $slotIdInSubscription;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $standName
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setStandName(\patest\StructType\GlobalString $standName = null)
    {
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get SubscriberTicketIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketIcon()
    {
        return isset($this->SubscriberTicketIcon) ? $this->SubscriberTicketIcon : null;
    }
    /**
     * Set SubscriberTicketIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberTicketIcon
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSubscriberTicketIcon($subscriberTicketIcon = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberTicketIcon) && !is_string($subscriberTicketIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberTicketIcon, true), gettype($subscriberTicketIcon)), __LINE__);
        }
        if (is_null($subscriberTicketIcon) || (is_array($subscriberTicketIcon) && empty($subscriberTicketIcon))) {
            unset($this->SubscriberTicketIcon);
        } else {
            $this->SubscriberTicketIcon = $subscriberTicketIcon;
        }
        return $this;
    }
    /**
     * Get SubscriberTicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketType()
    {
        return isset($this->SubscriberTicketType) ? $this->SubscriberTicketType : null;
    }
    /**
     * Set SubscriberTicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketType::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberTicketType
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSubscriberTicketType($subscriberTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketType::valueIsValid($subscriberTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketType', is_array($subscriberTicketType) ? implode(', ', $subscriberTicketType) : var_export($subscriberTicketType, true), implode(', ', \patest\EnumType\SubscriberTicketType::getValidValues())), __LINE__);
        }
        if (is_null($subscriberTicketType) || (is_array($subscriberTicketType) && empty($subscriberTicketType))) {
            unset($this->SubscriberTicketType);
        } else {
            $this->SubscriberTicketType = $subscriberTicketType;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get SubsidyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSubsidyAmount()
    {
        return isset($this->SubsidyAmount) ? $this->SubsidyAmount : null;
    }
    /**
     * Set SubsidyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $subsidyAmount
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setSubsidyAmount(\patest\StructType\Money $subsidyAmount = null)
    {
        if (is_null($subsidyAmount) || (is_array($subsidyAmount) && empty($subsidyAmount))) {
            unset($this->SubsidyAmount);
        } else {
            $this->SubsidyAmount = $subsidyAmount;
        }
        return $this;
    }
    /**
     * Get TicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_TicketDistributionJournal|null
     */
    public function getTicketHolder()
    {
        return isset($this->TicketHolder) ? $this->TicketHolder : null;
    }
    /**
     * Set TicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setTicketHolder(\patest\StructType\Ticketing_TicketDistributionJournal $ticketHolder = null)
    {
        if (is_null($ticketHolder) || (is_array($ticketHolder) && empty($ticketHolder))) {
            unset($this->TicketHolder);
        } else {
            $this->TicketHolder = $ticketHolder;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TicketPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTicketPrice()
    {
        return isset($this->TicketPrice) ? $this->TicketPrice : null;
    }
    /**
     * Set TicketPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $ticketPrice
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setTicketPrice(\patest\StructType\Money $ticketPrice = null)
    {
        if (is_null($ticketPrice) || (is_array($ticketPrice) && empty($ticketPrice))) {
            unset($this->TicketPrice);
        } else {
            $this->TicketPrice = $ticketPrice;
        }
        return $this;
    }
    /**
     * Get TicketTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_TicketTransaction|null
     */
    public function getTicketTransactions()
    {
        return isset($this->TicketTransactions) ? $this->TicketTransactions : null;
    }
    /**
     * Set TicketTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_TicketTransaction $ticketTransactions
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setTicketTransactions(\patest\StructType\RecordSetOfTicketing_TicketTransaction $ticketTransactions = null)
    {
        if (is_null($ticketTransactions) || (is_array($ticketTransactions) && empty($ticketTransactions))) {
            unset($this->TicketTransactions);
        } else {
            $this->TicketTransactions = $ticketTransactions;
        }
        return $this;
    }
    /**
     * Get TurnstileIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstileIds()
    {
        return isset($this->TurnstileIds) ? $this->TurnstileIds : null;
    }
    /**
     * Set TurnstileIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstileIds
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setTurnstileIds($turnstileIds = null)
    {
        // validation for constraint: string
        if (!is_null($turnstileIds) && !is_string($turnstileIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstileIds, true), gettype($turnstileIds)), __LINE__);
        }
        if (is_null($turnstileIds) || (is_array($turnstileIds) && empty($turnstileIds))) {
            unset($this->TurnstileIds);
        } else {
            $this->TurnstileIds = $turnstileIds;
        }
        return $this;
    }
    /**
     * Get WorthInSubscriptionBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWorthInSubscriptionBalance()
    {
        return isset($this->WorthInSubscriptionBalance) ? $this->WorthInSubscriptionBalance : null;
    }
    /**
     * Set WorthInSubscriptionBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $worthInSubscriptionBalance
     * @return \patest\StructType\Ticketing_TicketBase
     */
    public function setWorthInSubscriptionBalance($worthInSubscriptionBalance = null)
    {
        // validation for constraint: float
        if (!is_null($worthInSubscriptionBalance) && !(is_float($worthInSubscriptionBalance) || is_numeric($worthInSubscriptionBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($worthInSubscriptionBalance, true), gettype($worthInSubscriptionBalance)), __LINE__);
        }
        if (is_null($worthInSubscriptionBalance) || (is_array($worthInSubscriptionBalance) && empty($worthInSubscriptionBalance))) {
            unset($this->WorthInSubscriptionBalance);
        } else {
            $this->WorthInSubscriptionBalance = $worthInSubscriptionBalance;
        }
        return $this;
    }
}
