<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionInstanceExtended StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.SubscriptionInstanceExtended
 * @subpackage Structs
 */
class Ticketing_SubscriptionInstanceExtended extends Ticketing_SubscriptionInstance
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The AccessControlProviderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlProviderId;
    /**
     * The ActiveOrReserved
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ActiveOrReserved;
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgencyName;
    /**
     * The BackwardTransaction
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransaction;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CanAutoRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAutoRenew;
    /**
     * The CanRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanRenew;
    /**
     * The EffectiveEndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveEndDate;
    /**
     * The EffectiveStartDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveStartDate;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraInfo;
    /**
     * The HasPreservedSeats
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasPreservedSeats;
    /**
     * The HoldSeatsForRenewStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HoldSeatsForRenewStatus;
    /**
     * The IsAutoRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenew;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The IsOnlineMoveAllowed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnlineMoveAllowed;
    /**
     * The IsRelatedclient
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRelatedclient;
    /**
     * The OnlineMoveAllowedUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineMoveAllowedUntil;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PreservedSeatsStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreservedSeatsStatus;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SGOrderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SGOrderId;
    /**
     * The SubscriberSince
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberSince;
    /**
     * The SubscriptionDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionDescription;
    /**
     * The TicketSchemeIdsAvailableForEnrollment
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketSchemeIdsAvailableForEnrollment;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The UnpaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidAmount;
    /**
     * The UnpaidInstallmentsAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnpaidInstallmentsAmount;
    /**
     * Constructor method for Ticketing.SubscriptionInstanceExtended
     * @uses Ticketing_SubscriptionInstanceExtended::setAccessCardId()
     * @uses Ticketing_SubscriptionInstanceExtended::setAccessControlProviderId()
     * @uses Ticketing_SubscriptionInstanceExtended::setActiveOrReserved()
     * @uses Ticketing_SubscriptionInstanceExtended::setAgencyAccountId()
     * @uses Ticketing_SubscriptionInstanceExtended::setAgencyName()
     * @uses Ticketing_SubscriptionInstanceExtended::setBackwardTransaction()
     * @uses Ticketing_SubscriptionInstanceExtended::setBarcode()
     * @uses Ticketing_SubscriptionInstanceExtended::setCanAutoRenew()
     * @uses Ticketing_SubscriptionInstanceExtended::setCanRenew()
     * @uses Ticketing_SubscriptionInstanceExtended::setEffectiveEndDate()
     * @uses Ticketing_SubscriptionInstanceExtended::setEffectiveStartDate()
     * @uses Ticketing_SubscriptionInstanceExtended::setExtraInfo()
     * @uses Ticketing_SubscriptionInstanceExtended::setHasPreservedSeats()
     * @uses Ticketing_SubscriptionInstanceExtended::setHoldSeatsForRenewStatus()
     * @uses Ticketing_SubscriptionInstanceExtended::setIsAutoRenew()
     * @uses Ticketing_SubscriptionInstanceExtended::setIsObsolete()
     * @uses Ticketing_SubscriptionInstanceExtended::setIsOnlineMoveAllowed()
     * @uses Ticketing_SubscriptionInstanceExtended::setIsRelatedclient()
     * @uses Ticketing_SubscriptionInstanceExtended::setOnlineMoveAllowedUntil()
     * @uses Ticketing_SubscriptionInstanceExtended::setPaidAmount()
     * @uses Ticketing_SubscriptionInstanceExtended::setPaymentStatus()
     * @uses Ticketing_SubscriptionInstanceExtended::setPreservedSeatsStatus()
     * @uses Ticketing_SubscriptionInstanceExtended::setSalesRepId()
     * @uses Ticketing_SubscriptionInstanceExtended::setSectorId()
     * @uses Ticketing_SubscriptionInstanceExtended::setSGOrderId()
     * @uses Ticketing_SubscriptionInstanceExtended::setSubscriberSince()
     * @uses Ticketing_SubscriptionInstanceExtended::setSubscriptionDescription()
     * @uses Ticketing_SubscriptionInstanceExtended::setTicketSchemeIdsAvailableForEnrollment()
     * @uses Ticketing_SubscriptionInstanceExtended::setTotalPrice()
     * @uses Ticketing_SubscriptionInstanceExtended::setTransactionDate()
     * @uses Ticketing_SubscriptionInstanceExtended::setTransactionNotes()
     * @uses Ticketing_SubscriptionInstanceExtended::setTransactionNumber()
     * @uses Ticketing_SubscriptionInstanceExtended::setTransactionReferenceNumber()
     * @uses Ticketing_SubscriptionInstanceExtended::setUnpaidAmount()
     * @uses Ticketing_SubscriptionInstanceExtended::setUnpaidInstallmentsAmount()
     * @param string $accessCardId
     * @param string $accessControlProviderId
     * @param bool $activeOrReserved
     * @param string $agencyAccountId
     * @param string $agencyName
     * @param string $backwardTransaction
     * @param string $barcode
     * @param bool $canAutoRenew
     * @param bool $canRenew
     * @param string $effectiveEndDate
     * @param string $effectiveStartDate
     * @param string $extraInfo
     * @param bool $hasPreservedSeats
     * @param string $holdSeatsForRenewStatus
     * @param bool $isAutoRenew
     * @param bool $isObsolete
     * @param bool $isOnlineMoveAllowed
     * @param bool $isRelatedclient
     * @param string $onlineMoveAllowedUntil
     * @param \patest\StructType\Money $paidAmount
     * @param string $paymentStatus
     * @param string $preservedSeatsStatus
     * @param string $salesRepId
     * @param string $sectorId
     * @param string $sGOrderId
     * @param string $subscriberSince
     * @param string $subscriptionDescription
     * @param string $ticketSchemeIdsAvailableForEnrollment
     * @param \patest\StructType\Money $totalPrice
     * @param string $transactionDate
     * @param string $transactionNotes
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     * @param \patest\StructType\Money $unpaidAmount
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     */
    public function __construct($accessCardId = null, $accessControlProviderId = null, $activeOrReserved = null, $agencyAccountId = null, $agencyName = null, $backwardTransaction = null, $barcode = null, $canAutoRenew = null, $canRenew = null, $effectiveEndDate = null, $effectiveStartDate = null, $extraInfo = null, $hasPreservedSeats = null, $holdSeatsForRenewStatus = null, $isAutoRenew = null, $isObsolete = null, $isOnlineMoveAllowed = null, $isRelatedclient = null, $onlineMoveAllowedUntil = null, \patest\StructType\Money $paidAmount = null, $paymentStatus = null, $preservedSeatsStatus = null, $salesRepId = null, $sectorId = null, $sGOrderId = null, $subscriberSince = null, $subscriptionDescription = null, $ticketSchemeIdsAvailableForEnrollment = null, \patest\StructType\Money $totalPrice = null, $transactionDate = null, $transactionNotes = null, $transactionNumber = null, $transactionReferenceNumber = null, \patest\StructType\Money $unpaidAmount = null, \patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setAccessControlProviderId($accessControlProviderId)
            ->setActiveOrReserved($activeOrReserved)
            ->setAgencyAccountId($agencyAccountId)
            ->setAgencyName($agencyName)
            ->setBackwardTransaction($backwardTransaction)
            ->setBarcode($barcode)
            ->setCanAutoRenew($canAutoRenew)
            ->setCanRenew($canRenew)
            ->setEffectiveEndDate($effectiveEndDate)
            ->setEffectiveStartDate($effectiveStartDate)
            ->setExtraInfo($extraInfo)
            ->setHasPreservedSeats($hasPreservedSeats)
            ->setHoldSeatsForRenewStatus($holdSeatsForRenewStatus)
            ->setIsAutoRenew($isAutoRenew)
            ->setIsObsolete($isObsolete)
            ->setIsOnlineMoveAllowed($isOnlineMoveAllowed)
            ->setIsRelatedclient($isRelatedclient)
            ->setOnlineMoveAllowedUntil($onlineMoveAllowedUntil)
            ->setPaidAmount($paidAmount)
            ->setPaymentStatus($paymentStatus)
            ->setPreservedSeatsStatus($preservedSeatsStatus)
            ->setSalesRepId($salesRepId)
            ->setSectorId($sectorId)
            ->setSGOrderId($sGOrderId)
            ->setSubscriberSince($subscriberSince)
            ->setSubscriptionDescription($subscriptionDescription)
            ->setTicketSchemeIdsAvailableForEnrollment($ticketSchemeIdsAvailableForEnrollment)
            ->setTotalPrice($totalPrice)
            ->setTransactionDate($transactionDate)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setUnpaidAmount($unpaidAmount)
            ->setUnpaidInstallmentsAmount($unpaidInstallmentsAmount);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get AccessControlProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProviderId()
    {
        return isset($this->AccessControlProviderId) ? $this->AccessControlProviderId : null;
    }
    /**
     * Set AccessControlProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProviderId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setAccessControlProviderId($accessControlProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProviderId) && !is_string($accessControlProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProviderId, true), gettype($accessControlProviderId)), __LINE__);
        }
        if (is_null($accessControlProviderId) || (is_array($accessControlProviderId) && empty($accessControlProviderId))) {
            unset($this->AccessControlProviderId);
        } else {
            $this->AccessControlProviderId = $accessControlProviderId;
        }
        return $this;
    }
    /**
     * Get ActiveOrReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActiveOrReserved()
    {
        return isset($this->ActiveOrReserved) ? $this->ActiveOrReserved : null;
    }
    /**
     * Set ActiveOrReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $activeOrReserved
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setActiveOrReserved($activeOrReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeOrReserved) && !is_bool($activeOrReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeOrReserved, true), gettype($activeOrReserved)), __LINE__);
        }
        if (is_null($activeOrReserved) || (is_array($activeOrReserved) && empty($activeOrReserved))) {
            unset($this->ActiveOrReserved);
        } else {
            $this->ActiveOrReserved = $activeOrReserved;
        }
        return $this;
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get AgencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyName()
    {
        return isset($this->AgencyName) ? $this->AgencyName : null;
    }
    /**
     * Set AgencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyName
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        if (is_null($agencyName) || (is_array($agencyName) && empty($agencyName))) {
            unset($this->AgencyName);
        } else {
            $this->AgencyName = $agencyName;
        }
        return $this;
    }
    /**
     * Get BackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransaction()
    {
        return isset($this->BackwardTransaction) ? $this->BackwardTransaction : null;
    }
    /**
     * Set BackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransaction
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setBackwardTransaction($backwardTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransaction) && !is_string($backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransaction, true), gettype($backwardTransaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransaction, true)), __LINE__);
        }
        if (is_null($backwardTransaction) || (is_array($backwardTransaction) && empty($backwardTransaction))) {
            unset($this->BackwardTransaction);
        } else {
            $this->BackwardTransaction = $backwardTransaction;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CanAutoRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAutoRenew()
    {
        return isset($this->CanAutoRenew) ? $this->CanAutoRenew : null;
    }
    /**
     * Set CanAutoRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAutoRenew
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setCanAutoRenew($canAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAutoRenew) && !is_bool($canAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAutoRenew, true), gettype($canAutoRenew)), __LINE__);
        }
        if (is_null($canAutoRenew) || (is_array($canAutoRenew) && empty($canAutoRenew))) {
            unset($this->CanAutoRenew);
        } else {
            $this->CanAutoRenew = $canAutoRenew;
        }
        return $this;
    }
    /**
     * Get CanRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanRenew()
    {
        return isset($this->CanRenew) ? $this->CanRenew : null;
    }
    /**
     * Set CanRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canRenew
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setCanRenew($canRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canRenew) && !is_bool($canRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canRenew, true), gettype($canRenew)), __LINE__);
        }
        if (is_null($canRenew) || (is_array($canRenew) && empty($canRenew))) {
            unset($this->CanRenew);
        } else {
            $this->CanRenew = $canRenew;
        }
        return $this;
    }
    /**
     * Get EffectiveEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveEndDate()
    {
        return isset($this->EffectiveEndDate) ? $this->EffectiveEndDate : null;
    }
    /**
     * Set EffectiveEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveEndDate
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setEffectiveEndDate($effectiveEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEndDate) && !is_string($effectiveEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEndDate, true), gettype($effectiveEndDate)), __LINE__);
        }
        if (is_null($effectiveEndDate) || (is_array($effectiveEndDate) && empty($effectiveEndDate))) {
            unset($this->EffectiveEndDate);
        } else {
            $this->EffectiveEndDate = $effectiveEndDate;
        }
        return $this;
    }
    /**
     * Get EffectiveStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveStartDate()
    {
        return isset($this->EffectiveStartDate) ? $this->EffectiveStartDate : null;
    }
    /**
     * Set EffectiveStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveStartDate
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setEffectiveStartDate($effectiveStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStartDate) && !is_string($effectiveStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStartDate, true), gettype($effectiveStartDate)), __LINE__);
        }
        if (is_null($effectiveStartDate) || (is_array($effectiveStartDate) && empty($effectiveStartDate))) {
            unset($this->EffectiveStartDate);
        } else {
            $this->EffectiveStartDate = $effectiveStartDate;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraInfo
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get HasPreservedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasPreservedSeats()
    {
        return isset($this->HasPreservedSeats) ? $this->HasPreservedSeats : null;
    }
    /**
     * Set HasPreservedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasPreservedSeats
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setHasPreservedSeats($hasPreservedSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPreservedSeats) && !is_bool($hasPreservedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPreservedSeats, true), gettype($hasPreservedSeats)), __LINE__);
        }
        if (is_null($hasPreservedSeats) || (is_array($hasPreservedSeats) && empty($hasPreservedSeats))) {
            unset($this->HasPreservedSeats);
        } else {
            $this->HasPreservedSeats = $hasPreservedSeats;
        }
        return $this;
    }
    /**
     * Get HoldSeatsForRenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldSeatsForRenewStatus()
    {
        return isset($this->HoldSeatsForRenewStatus) ? $this->HoldSeatsForRenewStatus : null;
    }
    /**
     * Set HoldSeatsForRenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::valueIsValid()
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdSeatsForRenewStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setHoldSeatsForRenewStatus($holdSeatsForRenewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HoldSeatsForRenewStatus::valueIsValid($holdSeatsForRenewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HoldSeatsForRenewStatus', is_array($holdSeatsForRenewStatus) ? implode(', ', $holdSeatsForRenewStatus) : var_export($holdSeatsForRenewStatus, true), implode(', ', \patest\EnumType\HoldSeatsForRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($holdSeatsForRenewStatus) || (is_array($holdSeatsForRenewStatus) && empty($holdSeatsForRenewStatus))) {
            unset($this->HoldSeatsForRenewStatus);
        } else {
            $this->HoldSeatsForRenewStatus = $holdSeatsForRenewStatus;
        }
        return $this;
    }
    /**
     * Get IsAutoRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenew()
    {
        return isset($this->IsAutoRenew) ? $this->IsAutoRenew : null;
    }
    /**
     * Set IsAutoRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenew
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setIsAutoRenew($isAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenew) && !is_bool($isAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenew, true), gettype($isAutoRenew)), __LINE__);
        }
        if (is_null($isAutoRenew) || (is_array($isAutoRenew) && empty($isAutoRenew))) {
            unset($this->IsAutoRenew);
        } else {
            $this->IsAutoRenew = $isAutoRenew;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get IsOnlineMoveAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnlineMoveAllowed()
    {
        return isset($this->IsOnlineMoveAllowed) ? $this->IsOnlineMoveAllowed : null;
    }
    /**
     * Set IsOnlineMoveAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnlineMoveAllowed
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setIsOnlineMoveAllowed($isOnlineMoveAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlineMoveAllowed) && !is_bool($isOnlineMoveAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlineMoveAllowed, true), gettype($isOnlineMoveAllowed)), __LINE__);
        }
        if (is_null($isOnlineMoveAllowed) || (is_array($isOnlineMoveAllowed) && empty($isOnlineMoveAllowed))) {
            unset($this->IsOnlineMoveAllowed);
        } else {
            $this->IsOnlineMoveAllowed = $isOnlineMoveAllowed;
        }
        return $this;
    }
    /**
     * Get IsRelatedclient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRelatedclient()
    {
        return isset($this->IsRelatedclient) ? $this->IsRelatedclient : null;
    }
    /**
     * Set IsRelatedclient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRelatedclient
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setIsRelatedclient($isRelatedclient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelatedclient) && !is_bool($isRelatedclient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelatedclient, true), gettype($isRelatedclient)), __LINE__);
        }
        if (is_null($isRelatedclient) || (is_array($isRelatedclient) && empty($isRelatedclient))) {
            unset($this->IsRelatedclient);
        } else {
            $this->IsRelatedclient = $isRelatedclient;
        }
        return $this;
    }
    /**
     * Get OnlineMoveAllowedUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineMoveAllowedUntil()
    {
        return isset($this->OnlineMoveAllowedUntil) ? $this->OnlineMoveAllowedUntil : null;
    }
    /**
     * Set OnlineMoveAllowedUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineMoveAllowedUntil
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setOnlineMoveAllowedUntil($onlineMoveAllowedUntil = null)
    {
        // validation for constraint: string
        if (!is_null($onlineMoveAllowedUntil) && !is_string($onlineMoveAllowedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineMoveAllowedUntil, true), gettype($onlineMoveAllowedUntil)), __LINE__);
        }
        if (is_null($onlineMoveAllowedUntil) || (is_array($onlineMoveAllowedUntil) && empty($onlineMoveAllowedUntil))) {
            unset($this->OnlineMoveAllowedUntil);
        } else {
            $this->OnlineMoveAllowedUntil = $onlineMoveAllowedUntil;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentPaidStatusType::valueIsValid()
     * @uses \patest\EnumType\PaymentPaidStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentPaidStatusType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPaidStatusType', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentPaidStatusType::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PreservedSeatsStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreservedSeatsStatus()
    {
        return isset($this->PreservedSeatsStatus) ? $this->PreservedSeatsStatus : null;
    }
    /**
     * Set PreservedSeatsStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberPreservedSeatStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriberPreservedSeatStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preservedSeatsStatus
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setPreservedSeatsStatus($preservedSeatsStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberPreservedSeatStatus::valueIsValid($preservedSeatsStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberPreservedSeatStatus', is_array($preservedSeatsStatus) ? implode(', ', $preservedSeatsStatus) : var_export($preservedSeatsStatus, true), implode(', ', \patest\EnumType\SubscriberPreservedSeatStatus::getValidValues())), __LINE__);
        }
        if (is_null($preservedSeatsStatus) || (is_array($preservedSeatsStatus) && empty($preservedSeatsStatus))) {
            unset($this->PreservedSeatsStatus);
        } else {
            $this->PreservedSeatsStatus = $preservedSeatsStatus;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SGOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSGOrderId()
    {
        return isset($this->SGOrderId) ? $this->SGOrderId : null;
    }
    /**
     * Set SGOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sGOrderId
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setSGOrderId($sGOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($sGOrderId) && !is_string($sGOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sGOrderId, true), gettype($sGOrderId)), __LINE__);
        }
        if (is_null($sGOrderId) || (is_array($sGOrderId) && empty($sGOrderId))) {
            unset($this->SGOrderId);
        } else {
            $this->SGOrderId = $sGOrderId;
        }
        return $this;
    }
    /**
     * Get SubscriberSince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberSince()
    {
        return isset($this->SubscriberSince) ? $this->SubscriberSince : null;
    }
    /**
     * Set SubscriberSince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberSince
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setSubscriberSince($subscriberSince = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberSince) && !is_string($subscriberSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberSince, true), gettype($subscriberSince)), __LINE__);
        }
        if (is_null($subscriberSince) || (is_array($subscriberSince) && empty($subscriberSince))) {
            unset($this->SubscriberSince);
        } else {
            $this->SubscriberSince = $subscriberSince;
        }
        return $this;
    }
    /**
     * Get SubscriptionDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionDescription()
    {
        return isset($this->SubscriptionDescription) ? $this->SubscriptionDescription : null;
    }
    /**
     * Set SubscriptionDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionDescription
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setSubscriptionDescription($subscriptionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionDescription) && !is_string($subscriptionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionDescription, true), gettype($subscriptionDescription)), __LINE__);
        }
        if (is_null($subscriptionDescription) || (is_array($subscriptionDescription) && empty($subscriptionDescription))) {
            unset($this->SubscriptionDescription);
        } else {
            $this->SubscriptionDescription = $subscriptionDescription;
        }
        return $this;
    }
    /**
     * Get TicketSchemeIdsAvailableForEnrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeIdsAvailableForEnrollment()
    {
        return isset($this->TicketSchemeIdsAvailableForEnrollment) ? $this->TicketSchemeIdsAvailableForEnrollment : null;
    }
    /**
     * Set TicketSchemeIdsAvailableForEnrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeIdsAvailableForEnrollment
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setTicketSchemeIdsAvailableForEnrollment($ticketSchemeIdsAvailableForEnrollment = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeIdsAvailableForEnrollment) && !is_string($ticketSchemeIdsAvailableForEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeIdsAvailableForEnrollment, true), gettype($ticketSchemeIdsAvailableForEnrollment)), __LINE__);
        }
        if (is_null($ticketSchemeIdsAvailableForEnrollment) || (is_array($ticketSchemeIdsAvailableForEnrollment) && empty($ticketSchemeIdsAvailableForEnrollment))) {
            unset($this->TicketSchemeIdsAvailableForEnrollment);
        } else {
            $this->TicketSchemeIdsAvailableForEnrollment = $ticketSchemeIdsAvailableForEnrollment;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return isset($this->TransactionNotes) ? $this->TransactionNotes : null;
    }
    /**
     * Set TransactionNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNotes
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        if (is_null($transactionNotes) || (is_array($transactionNotes) && empty($transactionNotes))) {
            unset($this->TransactionNotes);
        } else {
            $this->TransactionNotes = $transactionNotes;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get UnpaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidAmount()
    {
        return isset($this->UnpaidAmount) ? $this->UnpaidAmount : null;
    }
    /**
     * Set UnpaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidAmount
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setUnpaidAmount(\patest\StructType\Money $unpaidAmount = null)
    {
        if (is_null($unpaidAmount) || (is_array($unpaidAmount) && empty($unpaidAmount))) {
            unset($this->UnpaidAmount);
        } else {
            $this->UnpaidAmount = $unpaidAmount;
        }
        return $this;
    }
    /**
     * Get UnpaidInstallmentsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidInstallmentsAmount()
    {
        return isset($this->UnpaidInstallmentsAmount) ? $this->UnpaidInstallmentsAmount : null;
    }
    /**
     * Set UnpaidInstallmentsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     * @return \patest\StructType\Ticketing_SubscriptionInstanceExtended
     */
    public function setUnpaidInstallmentsAmount(\patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        if (is_null($unpaidInstallmentsAmount) || (is_array($unpaidInstallmentsAmount) && empty($unpaidInstallmentsAmount))) {
            unset($this->UnpaidInstallmentsAmount);
        } else {
            $this->UnpaidInstallmentsAmount = $unpaidInstallmentsAmount;
        }
        return $this;
    }
}
