<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ShowFilter StructType
 * @subpackage Structs
 */
class Ticketing_ShowFilter extends FilterEntity
{
    /**
     * The ActiveFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveFrom;
    /**
     * The ActiveTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveTo;
    /**
     * The BriefText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BriefText;
    /**
     * The DefaultHallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultHallId;
    /**
     * The DefaultHallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultHallVersionId;
    /**
     * The Genres
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Genres;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The ShowAlsoSubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowAlsoSubordinates;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * Constructor method for Ticketing.ShowFilter
     * @uses Ticketing_ShowFilter::setActiveFrom()
     * @uses Ticketing_ShowFilter::setActiveTo()
     * @uses Ticketing_ShowFilter::setBriefText()
     * @uses Ticketing_ShowFilter::setDefaultHallId()
     * @uses Ticketing_ShowFilter::setDefaultHallVersionId()
     * @uses Ticketing_ShowFilter::setGenres()
     * @uses Ticketing_ShowFilter::setName()
     * @uses Ticketing_ShowFilter::setOwnerId()
     * @uses Ticketing_ShowFilter::setShowAlsoSubordinates()
     * @uses Ticketing_ShowFilter::setShowTypeId()
     * @param string $activeFrom
     * @param string $activeTo
     * @param string $briefText
     * @param string $defaultHallId
     * @param string $defaultHallVersionId
     * @param string $genres
     * @param string $name
     * @param string $ownerId
     * @param bool $showAlsoSubordinates
     * @param string $showTypeId
     */
    public function __construct($activeFrom = null, $activeTo = null, $briefText = null, $defaultHallId = null, $defaultHallVersionId = null, $genres = null, $name = null, $ownerId = null, $showAlsoSubordinates = null, $showTypeId = null)
    {
        $this
            ->setActiveFrom($activeFrom)
            ->setActiveTo($activeTo)
            ->setBriefText($briefText)
            ->setDefaultHallId($defaultHallId)
            ->setDefaultHallVersionId($defaultHallVersionId)
            ->setGenres($genres)
            ->setName($name)
            ->setOwnerId($ownerId)
            ->setShowAlsoSubordinates($showAlsoSubordinates)
            ->setShowTypeId($showTypeId);
    }
    /**
     * Get ActiveFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveFrom()
    {
        return isset($this->ActiveFrom) ? $this->ActiveFrom : null;
    }
    /**
     * Set ActiveFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeFrom
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setActiveFrom($activeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($activeFrom) && !is_string($activeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeFrom, true), gettype($activeFrom)), __LINE__);
        }
        if (is_null($activeFrom) || (is_array($activeFrom) && empty($activeFrom))) {
            unset($this->ActiveFrom);
        } else {
            $this->ActiveFrom = $activeFrom;
        }
        return $this;
    }
    /**
     * Get ActiveTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveTo()
    {
        return isset($this->ActiveTo) ? $this->ActiveTo : null;
    }
    /**
     * Set ActiveTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeTo
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setActiveTo($activeTo = null)
    {
        // validation for constraint: string
        if (!is_null($activeTo) && !is_string($activeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeTo, true), gettype($activeTo)), __LINE__);
        }
        if (is_null($activeTo) || (is_array($activeTo) && empty($activeTo))) {
            unset($this->ActiveTo);
        } else {
            $this->ActiveTo = $activeTo;
        }
        return $this;
    }
    /**
     * Get BriefText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBriefText()
    {
        return isset($this->BriefText) ? $this->BriefText : null;
    }
    /**
     * Set BriefText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $briefText
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setBriefText($briefText = null)
    {
        // validation for constraint: string
        if (!is_null($briefText) && !is_string($briefText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($briefText, true), gettype($briefText)), __LINE__);
        }
        if (is_null($briefText) || (is_array($briefText) && empty($briefText))) {
            unset($this->BriefText);
        } else {
            $this->BriefText = $briefText;
        }
        return $this;
    }
    /**
     * Get DefaultHallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultHallId()
    {
        return isset($this->DefaultHallId) ? $this->DefaultHallId : null;
    }
    /**
     * Set DefaultHallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultHallId
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setDefaultHallId($defaultHallId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultHallId) && !is_string($defaultHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultHallId, true), gettype($defaultHallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultHallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultHallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultHallId, true)), __LINE__);
        }
        if (is_null($defaultHallId) || (is_array($defaultHallId) && empty($defaultHallId))) {
            unset($this->DefaultHallId);
        } else {
            $this->DefaultHallId = $defaultHallId;
        }
        return $this;
    }
    /**
     * Get DefaultHallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultHallVersionId()
    {
        return isset($this->DefaultHallVersionId) ? $this->DefaultHallVersionId : null;
    }
    /**
     * Set DefaultHallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultHallVersionId
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setDefaultHallVersionId($defaultHallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultHallVersionId) && !is_string($defaultHallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultHallVersionId, true), gettype($defaultHallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultHallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultHallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultHallVersionId, true)), __LINE__);
        }
        if (is_null($defaultHallVersionId) || (is_array($defaultHallVersionId) && empty($defaultHallVersionId))) {
            unset($this->DefaultHallVersionId);
        } else {
            $this->DefaultHallVersionId = $defaultHallVersionId;
        }
        return $this;
    }
    /**
     * Get Genres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenres()
    {
        return isset($this->Genres) ? $this->Genres : null;
    }
    /**
     * Set Genres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $genres
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setGenres($genres = null)
    {
        // validation for constraint: string
        if (!is_null($genres) && !is_string($genres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genres, true), gettype($genres)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($genres) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $genres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($genres, true)), __LINE__);
        }
        if (is_null($genres) || (is_array($genres) && empty($genres))) {
            unset($this->Genres);
        } else {
            $this->Genres = $genres;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get ShowAlsoSubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowAlsoSubordinates()
    {
        return isset($this->ShowAlsoSubordinates) ? $this->ShowAlsoSubordinates : null;
    }
    /**
     * Set ShowAlsoSubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showAlsoSubordinates
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setShowAlsoSubordinates($showAlsoSubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAlsoSubordinates) && !is_bool($showAlsoSubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAlsoSubordinates, true), gettype($showAlsoSubordinates)), __LINE__);
        }
        if (is_null($showAlsoSubordinates) || (is_array($showAlsoSubordinates) && empty($showAlsoSubordinates))) {
            unset($this->ShowAlsoSubordinates);
        } else {
            $this->ShowAlsoSubordinates = $showAlsoSubordinates;
        }
        return $this;
    }
    /**
     * Get ShowTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTypeId()
    {
        return isset($this->ShowTypeId) ? $this->ShowTypeId : null;
    }
    /**
     * Set ShowTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTypeId
     * @return \patest\StructType\Ticketing_ShowFilter
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        if (is_null($showTypeId) || (is_array($showTypeId) && empty($showTypeId))) {
            unset($this->ShowTypeId);
        } else {
            $this->ShowTypeId = $showTypeId;
        }
        return $this;
    }
}
