<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ShowFaceValuePriceList StructType
 * @subpackage Structs
 */
class Ticketing_ShowFaceValuePriceList extends DistributableEntity
{
    /**
     * The DaysOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaysOfWeek;
    /**
     * The EventTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventTypeIds
     */
    public $EventTypeIds;
    /**
     * The FaceValuePriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FaceValuePriceListId;
    /**
     * The FromEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromEventDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ToEventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToEventDate;
    /**
     * Constructor method for Ticketing.ShowFaceValuePriceList
     * @uses Ticketing_ShowFaceValuePriceList::setDaysOfWeek()
     * @uses Ticketing_ShowFaceValuePriceList::setEventTypeIds()
     * @uses Ticketing_ShowFaceValuePriceList::setFaceValuePriceListId()
     * @uses Ticketing_ShowFaceValuePriceList::setFromEventDate()
     * @uses Ticketing_ShowFaceValuePriceList::setName()
     * @uses Ticketing_ShowFaceValuePriceList::setPriority()
     * @uses Ticketing_ShowFaceValuePriceList::setShowId()
     * @uses Ticketing_ShowFaceValuePriceList::setToEventDate()
     * @param string $daysOfWeek
     * @param \patest\StructType\EventTypeIds $eventTypeIds
     * @param string $faceValuePriceListId
     * @param string $fromEventDate
     * @param \patest\StructType\GlobalString $name
     * @param int $priority
     * @param string $showId
     * @param string $toEventDate
     */
    public function __construct($daysOfWeek = null, \patest\StructType\EventTypeIds $eventTypeIds = null, $faceValuePriceListId = null, $fromEventDate = null, \patest\StructType\GlobalString $name = null, $priority = null, $showId = null, $toEventDate = null)
    {
        $this
            ->setDaysOfWeek($daysOfWeek)
            ->setEventTypeIds($eventTypeIds)
            ->setFaceValuePriceListId($faceValuePriceListId)
            ->setFromEventDate($fromEventDate)
            ->setName($name)
            ->setPriority($priority)
            ->setShowId($showId)
            ->setToEventDate($toEventDate);
    }
    /**
     * Get DaysOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaysOfWeek()
    {
        return isset($this->DaysOfWeek) ? $this->DaysOfWeek : null;
    }
    /**
     * Set DaysOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daysOfWeek
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setDaysOfWeek($daysOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($daysOfWeek) && !is_string($daysOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daysOfWeek, true), gettype($daysOfWeek)), __LINE__);
        }
        if (is_null($daysOfWeek) || (is_array($daysOfWeek) && empty($daysOfWeek))) {
            unset($this->DaysOfWeek);
        } else {
            $this->DaysOfWeek = $daysOfWeek;
        }
        return $this;
    }
    /**
     * Get EventTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventTypeIds|null
     */
    public function getEventTypeIds()
    {
        return isset($this->EventTypeIds) ? $this->EventTypeIds : null;
    }
    /**
     * Set EventTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventTypeIds $eventTypeIds
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setEventTypeIds(\patest\StructType\EventTypeIds $eventTypeIds = null)
    {
        if (is_null($eventTypeIds) || (is_array($eventTypeIds) && empty($eventTypeIds))) {
            unset($this->EventTypeIds);
        } else {
            $this->EventTypeIds = $eventTypeIds;
        }
        return $this;
    }
    /**
     * Get FaceValuePriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaceValuePriceListId()
    {
        return isset($this->FaceValuePriceListId) ? $this->FaceValuePriceListId : null;
    }
    /**
     * Set FaceValuePriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faceValuePriceListId
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setFaceValuePriceListId($faceValuePriceListId = null)
    {
        // validation for constraint: string
        if (!is_null($faceValuePriceListId) && !is_string($faceValuePriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faceValuePriceListId, true), gettype($faceValuePriceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($faceValuePriceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $faceValuePriceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($faceValuePriceListId, true)), __LINE__);
        }
        if (is_null($faceValuePriceListId) || (is_array($faceValuePriceListId) && empty($faceValuePriceListId))) {
            unset($this->FaceValuePriceListId);
        } else {
            $this->FaceValuePriceListId = $faceValuePriceListId;
        }
        return $this;
    }
    /**
     * Get FromEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromEventDate()
    {
        return isset($this->FromEventDate) ? $this->FromEventDate : null;
    }
    /**
     * Set FromEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromEventDate
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setFromEventDate($fromEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromEventDate) && !is_string($fromEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEventDate, true), gettype($fromEventDate)), __LINE__);
        }
        if (is_null($fromEventDate) || (is_array($fromEventDate) && empty($fromEventDate))) {
            unset($this->FromEventDate);
        } else {
            $this->FromEventDate = $fromEventDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ToEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToEventDate()
    {
        return isset($this->ToEventDate) ? $this->ToEventDate : null;
    }
    /**
     * Set ToEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toEventDate
     * @return \patest\StructType\Ticketing_ShowFaceValuePriceList
     */
    public function setToEventDate($toEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($toEventDate) && !is_string($toEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEventDate, true), gettype($toEventDate)), __LINE__);
        }
        if (is_null($toEventDate) || (is_array($toEventDate) && empty($toEventDate))) {
            unset($this->ToEventDate);
        } else {
            $this->ToEventDate = $toEventDate;
        }
        return $this;
    }
}
