<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SetEventPromoterPriceLists StructType
 * @subpackage Structs
 */
class Ticketing_SetEventPromoterPriceLists extends DistributableEntity
{
    /**
     * The PromoterPriceListIdForRegularTickets
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterPriceListIdForRegularTickets;
    /**
     * The PromoterPriceListIdForSubsTickets
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterPriceListIdForSubsTickets;
    /**
     * Constructor method for Ticketing.SetEventPromoterPriceLists
     * @uses Ticketing_SetEventPromoterPriceLists::setPromoterPriceListIdForRegularTickets()
     * @uses Ticketing_SetEventPromoterPriceLists::setPromoterPriceListIdForSubsTickets()
     * @param string $promoterPriceListIdForRegularTickets
     * @param string $promoterPriceListIdForSubsTickets
     */
    public function __construct($promoterPriceListIdForRegularTickets = null, $promoterPriceListIdForSubsTickets = null)
    {
        $this
            ->setPromoterPriceListIdForRegularTickets($promoterPriceListIdForRegularTickets)
            ->setPromoterPriceListIdForSubsTickets($promoterPriceListIdForSubsTickets);
    }
    /**
     * Get PromoterPriceListIdForRegularTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterPriceListIdForRegularTickets()
    {
        return isset($this->PromoterPriceListIdForRegularTickets) ? $this->PromoterPriceListIdForRegularTickets : null;
    }
    /**
     * Set PromoterPriceListIdForRegularTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterPriceListIdForRegularTickets
     * @return \patest\StructType\Ticketing_SetEventPromoterPriceLists
     */
    public function setPromoterPriceListIdForRegularTickets($promoterPriceListIdForRegularTickets = null)
    {
        // validation for constraint: string
        if (!is_null($promoterPriceListIdForRegularTickets) && !is_string($promoterPriceListIdForRegularTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterPriceListIdForRegularTickets, true), gettype($promoterPriceListIdForRegularTickets)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterPriceListIdForRegularTickets) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterPriceListIdForRegularTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterPriceListIdForRegularTickets, true)), __LINE__);
        }
        if (is_null($promoterPriceListIdForRegularTickets) || (is_array($promoterPriceListIdForRegularTickets) && empty($promoterPriceListIdForRegularTickets))) {
            unset($this->PromoterPriceListIdForRegularTickets);
        } else {
            $this->PromoterPriceListIdForRegularTickets = $promoterPriceListIdForRegularTickets;
        }
        return $this;
    }
    /**
     * Get PromoterPriceListIdForSubsTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterPriceListIdForSubsTickets()
    {
        return isset($this->PromoterPriceListIdForSubsTickets) ? $this->PromoterPriceListIdForSubsTickets : null;
    }
    /**
     * Set PromoterPriceListIdForSubsTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterPriceListIdForSubsTickets
     * @return \patest\StructType\Ticketing_SetEventPromoterPriceLists
     */
    public function setPromoterPriceListIdForSubsTickets($promoterPriceListIdForSubsTickets = null)
    {
        // validation for constraint: string
        if (!is_null($promoterPriceListIdForSubsTickets) && !is_string($promoterPriceListIdForSubsTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterPriceListIdForSubsTickets, true), gettype($promoterPriceListIdForSubsTickets)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterPriceListIdForSubsTickets) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterPriceListIdForSubsTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterPriceListIdForSubsTickets, true)), __LINE__);
        }
        if (is_null($promoterPriceListIdForSubsTickets) || (is_array($promoterPriceListIdForSubsTickets) && empty($promoterPriceListIdForSubsTickets))) {
            unset($this->PromoterPriceListIdForSubsTickets);
        } else {
            $this->PromoterPriceListIdForSubsTickets = $promoterPriceListIdForSubsTickets;
        }
        return $this;
    }
}
