<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeriesEventRelation StructType
 * @subpackage Structs
 */
class Ticketing_SeriesEventRelation extends PersistableEntity
{
    /**
     * The BucketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BucketId;
    /**
     * The CanAutoAllocateTickets
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAutoAllocateTickets;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IsAutomaticallyAllocated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutomaticallyAllocated;
    /**
     * The IsAutomaticallyChosen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutomaticallyChosen;
    /**
     * The IsAutomaticallyReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutomaticallyReserved;
    /**
     * The IsAvailableForFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForFullStackExchanges;
    /**
     * The IsRecommended
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRecommended;
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRequired;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesMasterSeriesId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesMasterSeriesId;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeriesName;
    /**
     * The TicketsAllocationErrorCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsAllocationErrorCount;
    /**
     * The TicketsAllocationStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketsAllocationStatus;
    /**
     * Constructor method for Ticketing.SeriesEventRelation
     * @uses Ticketing_SeriesEventRelation::setBucketId()
     * @uses Ticketing_SeriesEventRelation::setCanAutoAllocateTickets()
     * @uses Ticketing_SeriesEventRelation::setEventId()
     * @uses Ticketing_SeriesEventRelation::setIsAutomaticallyAllocated()
     * @uses Ticketing_SeriesEventRelation::setIsAutomaticallyChosen()
     * @uses Ticketing_SeriesEventRelation::setIsAutomaticallyReserved()
     * @uses Ticketing_SeriesEventRelation::setIsAvailableForFullStackExchanges()
     * @uses Ticketing_SeriesEventRelation::setIsRecommended()
     * @uses Ticketing_SeriesEventRelation::setIsRequired()
     * @uses Ticketing_SeriesEventRelation::setSeriesId()
     * @uses Ticketing_SeriesEventRelation::setSeriesMasterSeriesId()
     * @uses Ticketing_SeriesEventRelation::setSeriesName()
     * @uses Ticketing_SeriesEventRelation::setTicketsAllocationErrorCount()
     * @uses Ticketing_SeriesEventRelation::setTicketsAllocationStatus()
     * @param string $bucketId
     * @param bool $canAutoAllocateTickets
     * @param string $eventId
     * @param bool $isAutomaticallyAllocated
     * @param bool $isAutomaticallyChosen
     * @param bool $isAutomaticallyReserved
     * @param bool $isAvailableForFullStackExchanges
     * @param bool $isRecommended
     * @param bool $isRequired
     * @param string $seriesId
     * @param string $seriesMasterSeriesId
     * @param \patest\StructType\GlobalString $seriesName
     * @param int $ticketsAllocationErrorCount
     * @param string $ticketsAllocationStatus
     */
    public function __construct($bucketId = null, $canAutoAllocateTickets = null, $eventId = null, $isAutomaticallyAllocated = null, $isAutomaticallyChosen = null, $isAutomaticallyReserved = null, $isAvailableForFullStackExchanges = null, $isRecommended = null, $isRequired = null, $seriesId = null, $seriesMasterSeriesId = null, \patest\StructType\GlobalString $seriesName = null, $ticketsAllocationErrorCount = null, $ticketsAllocationStatus = null)
    {
        $this
            ->setBucketId($bucketId)
            ->setCanAutoAllocateTickets($canAutoAllocateTickets)
            ->setEventId($eventId)
            ->setIsAutomaticallyAllocated($isAutomaticallyAllocated)
            ->setIsAutomaticallyChosen($isAutomaticallyChosen)
            ->setIsAutomaticallyReserved($isAutomaticallyReserved)
            ->setIsAvailableForFullStackExchanges($isAvailableForFullStackExchanges)
            ->setIsRecommended($isRecommended)
            ->setIsRequired($isRequired)
            ->setSeriesId($seriesId)
            ->setSeriesMasterSeriesId($seriesMasterSeriesId)
            ->setSeriesName($seriesName)
            ->setTicketsAllocationErrorCount($ticketsAllocationErrorCount)
            ->setTicketsAllocationStatus($ticketsAllocationStatus);
    }
    /**
     * Get BucketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBucketId()
    {
        return isset($this->BucketId) ? $this->BucketId : null;
    }
    /**
     * Set BucketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bucketId
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setBucketId($bucketId = null)
    {
        // validation for constraint: string
        if (!is_null($bucketId) && !is_string($bucketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bucketId, true), gettype($bucketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bucketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bucketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bucketId, true)), __LINE__);
        }
        if (is_null($bucketId) || (is_array($bucketId) && empty($bucketId))) {
            unset($this->BucketId);
        } else {
            $this->BucketId = $bucketId;
        }
        return $this;
    }
    /**
     * Get CanAutoAllocateTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAutoAllocateTickets()
    {
        return isset($this->CanAutoAllocateTickets) ? $this->CanAutoAllocateTickets : null;
    }
    /**
     * Set CanAutoAllocateTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAutoAllocateTickets
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setCanAutoAllocateTickets($canAutoAllocateTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAutoAllocateTickets) && !is_bool($canAutoAllocateTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAutoAllocateTickets, true), gettype($canAutoAllocateTickets)), __LINE__);
        }
        if (is_null($canAutoAllocateTickets) || (is_array($canAutoAllocateTickets) && empty($canAutoAllocateTickets))) {
            unset($this->CanAutoAllocateTickets);
        } else {
            $this->CanAutoAllocateTickets = $canAutoAllocateTickets;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IsAutomaticallyAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutomaticallyAllocated()
    {
        return isset($this->IsAutomaticallyAllocated) ? $this->IsAutomaticallyAllocated : null;
    }
    /**
     * Set IsAutomaticallyAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutomaticallyAllocated
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setIsAutomaticallyAllocated($isAutomaticallyAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutomaticallyAllocated) && !is_bool($isAutomaticallyAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutomaticallyAllocated, true), gettype($isAutomaticallyAllocated)), __LINE__);
        }
        if (is_null($isAutomaticallyAllocated) || (is_array($isAutomaticallyAllocated) && empty($isAutomaticallyAllocated))) {
            unset($this->IsAutomaticallyAllocated);
        } else {
            $this->IsAutomaticallyAllocated = $isAutomaticallyAllocated;
        }
        return $this;
    }
    /**
     * Get IsAutomaticallyChosen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutomaticallyChosen()
    {
        return isset($this->IsAutomaticallyChosen) ? $this->IsAutomaticallyChosen : null;
    }
    /**
     * Set IsAutomaticallyChosen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutomaticallyChosen
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setIsAutomaticallyChosen($isAutomaticallyChosen = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutomaticallyChosen) && !is_bool($isAutomaticallyChosen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutomaticallyChosen, true), gettype($isAutomaticallyChosen)), __LINE__);
        }
        if (is_null($isAutomaticallyChosen) || (is_array($isAutomaticallyChosen) && empty($isAutomaticallyChosen))) {
            unset($this->IsAutomaticallyChosen);
        } else {
            $this->IsAutomaticallyChosen = $isAutomaticallyChosen;
        }
        return $this;
    }
    /**
     * Get IsAutomaticallyReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutomaticallyReserved()
    {
        return isset($this->IsAutomaticallyReserved) ? $this->IsAutomaticallyReserved : null;
    }
    /**
     * Set IsAutomaticallyReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutomaticallyReserved
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setIsAutomaticallyReserved($isAutomaticallyReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutomaticallyReserved) && !is_bool($isAutomaticallyReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutomaticallyReserved, true), gettype($isAutomaticallyReserved)), __LINE__);
        }
        if (is_null($isAutomaticallyReserved) || (is_array($isAutomaticallyReserved) && empty($isAutomaticallyReserved))) {
            unset($this->IsAutomaticallyReserved);
        } else {
            $this->IsAutomaticallyReserved = $isAutomaticallyReserved;
        }
        return $this;
    }
    /**
     * Get IsAvailableForFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForFullStackExchanges()
    {
        return isset($this->IsAvailableForFullStackExchanges) ? $this->IsAvailableForFullStackExchanges : null;
    }
    /**
     * Set IsAvailableForFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForFullStackExchanges
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setIsAvailableForFullStackExchanges($isAvailableForFullStackExchanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForFullStackExchanges) && !is_bool($isAvailableForFullStackExchanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForFullStackExchanges, true), gettype($isAvailableForFullStackExchanges)), __LINE__);
        }
        if (is_null($isAvailableForFullStackExchanges) || (is_array($isAvailableForFullStackExchanges) && empty($isAvailableForFullStackExchanges))) {
            unset($this->IsAvailableForFullStackExchanges);
        } else {
            $this->IsAvailableForFullStackExchanges = $isAvailableForFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get IsRecommended value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRecommended()
    {
        return isset($this->IsRecommended) ? $this->IsRecommended : null;
    }
    /**
     * Set IsRecommended value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRecommended
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setIsRecommended($isRecommended = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecommended) && !is_bool($isRecommended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRecommended, true), gettype($isRecommended)), __LINE__);
        }
        if (is_null($isRecommended) || (is_array($isRecommended) && empty($isRecommended))) {
            unset($this->IsRecommended);
        } else {
            $this->IsRecommended = $isRecommended;
        }
        return $this;
    }
    /**
     * Get IsRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRequired()
    {
        return isset($this->IsRequired) ? $this->IsRequired : null;
    }
    /**
     * Set IsRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRequired
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        if (is_null($isRequired) || (is_array($isRequired) && empty($isRequired))) {
            unset($this->IsRequired);
        } else {
            $this->IsRequired = $isRequired;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesMasterSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesMasterSeriesId()
    {
        return isset($this->SeriesMasterSeriesId) ? $this->SeriesMasterSeriesId : null;
    }
    /**
     * Set SeriesMasterSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesMasterSeriesId
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setSeriesMasterSeriesId($seriesMasterSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesMasterSeriesId) && !is_string($seriesMasterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesMasterSeriesId, true), gettype($seriesMasterSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesMasterSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesMasterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesMasterSeriesId, true)), __LINE__);
        }
        if (is_null($seriesMasterSeriesId) || (is_array($seriesMasterSeriesId) && empty($seriesMasterSeriesId))) {
            unset($this->SeriesMasterSeriesId);
        } else {
            $this->SeriesMasterSeriesId = $seriesMasterSeriesId;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seriesName
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setSeriesName(\patest\StructType\GlobalString $seriesName = null)
    {
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get TicketsAllocationErrorCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsAllocationErrorCount()
    {
        return isset($this->TicketsAllocationErrorCount) ? $this->TicketsAllocationErrorCount : null;
    }
    /**
     * Set TicketsAllocationErrorCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsAllocationErrorCount
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setTicketsAllocationErrorCount($ticketsAllocationErrorCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsAllocationErrorCount) && !(is_int($ticketsAllocationErrorCount) || ctype_digit($ticketsAllocationErrorCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsAllocationErrorCount, true), gettype($ticketsAllocationErrorCount)), __LINE__);
        }
        if (is_null($ticketsAllocationErrorCount) || (is_array($ticketsAllocationErrorCount) && empty($ticketsAllocationErrorCount))) {
            unset($this->TicketsAllocationErrorCount);
        } else {
            $this->TicketsAllocationErrorCount = $ticketsAllocationErrorCount;
        }
        return $this;
    }
    /**
     * Get TicketsAllocationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketsAllocationStatus()
    {
        return isset($this->TicketsAllocationStatus) ? $this->TicketsAllocationStatus : null;
    }
    /**
     * Set TicketsAllocationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketsAllocationStatus::valueIsValid()
     * @uses \patest\EnumType\TicketsAllocationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketsAllocationStatus
     * @return \patest\StructType\Ticketing_SeriesEventRelation
     */
    public function setTicketsAllocationStatus($ticketsAllocationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketsAllocationStatus::valueIsValid($ticketsAllocationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketsAllocationStatus', is_array($ticketsAllocationStatus) ? implode(', ', $ticketsAllocationStatus) : var_export($ticketsAllocationStatus, true), implode(', ', \patest\EnumType\TicketsAllocationStatus::getValidValues())), __LINE__);
        }
        if (is_null($ticketsAllocationStatus) || (is_array($ticketsAllocationStatus) && empty($ticketsAllocationStatus))) {
            unset($this->TicketsAllocationStatus);
        } else {
            $this->TicketsAllocationStatus = $ticketsAllocationStatus;
        }
        return $this;
    }
}
