<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Media StructType
 * @subpackage Structs
 */
class Ticketing_Media extends PersistableEntity
{
    /**
     * The BriefOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BriefOverview;
    /**
     * The DetailOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DetailOverview;
    /**
     * The EffectiveLargeImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveLargeImageUrl;
    /**
     * The EffectiveMediumImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveMediumImageUrl;
    /**
     * The EffectiveOnlineHeroImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveOnlineHeroImageUrl;
    /**
     * The EffectiveOnlineThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveOnlineThumbnailImageUrl;
    /**
     * The EffectivePassbookImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectivePassbookImageUrl;
    /**
     * The EffectiveSmallImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveSmallImageUrl;
    /**
     * The EffectiveSocialNetworkImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveSocialNetworkImageUrl;
    /**
     * The EffectiveThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveThumbnailImageUrl;
    /**
     * The ImageMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_ImageMedia
     */
    public $ImageMedia;
    /**
     * The Incentive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Incentive;
    /**
     * The LargeImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LargeImageId;
    /**
     * The MediumImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MediumImageId;
    /**
     * The OnlineHeroImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OnlineHeroImageId;
    /**
     * The OnlineThumbnailImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OnlineThumbnailImageId;
    /**
     * The PassbookDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PassbookDescription;
    /**
     * The PassbookImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PassbookImageId;
    /**
     * The ReviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ReviewUrl;
    /**
     * The SmallImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SmallImageId;
    /**
     * The SocialNetworkImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SocialNetworkImageId;
    /**
     * The ThumbnailImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ThumbnailImageId;
    /**
     * The TrailerUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TrailerUrl;
    /**
     * Constructor method for Ticketing.Media
     * @uses Ticketing_Media::setBriefOverview()
     * @uses Ticketing_Media::setDetailOverview()
     * @uses Ticketing_Media::setEffectiveLargeImageUrl()
     * @uses Ticketing_Media::setEffectiveMediumImageUrl()
     * @uses Ticketing_Media::setEffectiveOnlineHeroImageUrl()
     * @uses Ticketing_Media::setEffectiveOnlineThumbnailImageUrl()
     * @uses Ticketing_Media::setEffectivePassbookImageUrl()
     * @uses Ticketing_Media::setEffectiveSmallImageUrl()
     * @uses Ticketing_Media::setEffectiveSocialNetworkImageUrl()
     * @uses Ticketing_Media::setEffectiveThumbnailImageUrl()
     * @uses Ticketing_Media::setImageMedia()
     * @uses Ticketing_Media::setIncentive()
     * @uses Ticketing_Media::setLargeImageId()
     * @uses Ticketing_Media::setMediumImageId()
     * @uses Ticketing_Media::setOnlineHeroImageId()
     * @uses Ticketing_Media::setOnlineThumbnailImageId()
     * @uses Ticketing_Media::setPassbookDescription()
     * @uses Ticketing_Media::setPassbookImageId()
     * @uses Ticketing_Media::setReviewUrl()
     * @uses Ticketing_Media::setSmallImageId()
     * @uses Ticketing_Media::setSocialNetworkImageId()
     * @uses Ticketing_Media::setThumbnailImageId()
     * @uses Ticketing_Media::setTrailerUrl()
     * @param \patest\StructType\GlobalString $briefOverview
     * @param \patest\StructType\GlobalString $detailOverview
     * @param string $effectiveLargeImageUrl
     * @param string $effectiveMediumImageUrl
     * @param string $effectiveOnlineHeroImageUrl
     * @param string $effectiveOnlineThumbnailImageUrl
     * @param string $effectivePassbookImageUrl
     * @param string $effectiveSmallImageUrl
     * @param string $effectiveSocialNetworkImageUrl
     * @param string $effectiveThumbnailImageUrl
     * @param \patest\StructType\RecordSetOfTicketing_ImageMedia $imageMedia
     * @param \patest\StructType\GlobalString $incentive
     * @param int $largeImageId
     * @param int $mediumImageId
     * @param int $onlineHeroImageId
     * @param int $onlineThumbnailImageId
     * @param \patest\StructType\GlobalString $passbookDescription
     * @param int $passbookImageId
     * @param \patest\StructType\GlobalString $reviewUrl
     * @param int $smallImageId
     * @param int $socialNetworkImageId
     * @param int $thumbnailImageId
     * @param \patest\StructType\GlobalString $trailerUrl
     */
    public function __construct(\patest\StructType\GlobalString $briefOverview = null, \patest\StructType\GlobalString $detailOverview = null, $effectiveLargeImageUrl = null, $effectiveMediumImageUrl = null, $effectiveOnlineHeroImageUrl = null, $effectiveOnlineThumbnailImageUrl = null, $effectivePassbookImageUrl = null, $effectiveSmallImageUrl = null, $effectiveSocialNetworkImageUrl = null, $effectiveThumbnailImageUrl = null, \patest\StructType\RecordSetOfTicketing_ImageMedia $imageMedia = null, \patest\StructType\GlobalString $incentive = null, $largeImageId = null, $mediumImageId = null, $onlineHeroImageId = null, $onlineThumbnailImageId = null, \patest\StructType\GlobalString $passbookDescription = null, $passbookImageId = null, \patest\StructType\GlobalString $reviewUrl = null, $smallImageId = null, $socialNetworkImageId = null, $thumbnailImageId = null, \patest\StructType\GlobalString $trailerUrl = null)
    {
        $this
            ->setBriefOverview($briefOverview)
            ->setDetailOverview($detailOverview)
            ->setEffectiveLargeImageUrl($effectiveLargeImageUrl)
            ->setEffectiveMediumImageUrl($effectiveMediumImageUrl)
            ->setEffectiveOnlineHeroImageUrl($effectiveOnlineHeroImageUrl)
            ->setEffectiveOnlineThumbnailImageUrl($effectiveOnlineThumbnailImageUrl)
            ->setEffectivePassbookImageUrl($effectivePassbookImageUrl)
            ->setEffectiveSmallImageUrl($effectiveSmallImageUrl)
            ->setEffectiveSocialNetworkImageUrl($effectiveSocialNetworkImageUrl)
            ->setEffectiveThumbnailImageUrl($effectiveThumbnailImageUrl)
            ->setImageMedia($imageMedia)
            ->setIncentive($incentive)
            ->setLargeImageId($largeImageId)
            ->setMediumImageId($mediumImageId)
            ->setOnlineHeroImageId($onlineHeroImageId)
            ->setOnlineThumbnailImageId($onlineThumbnailImageId)
            ->setPassbookDescription($passbookDescription)
            ->setPassbookImageId($passbookImageId)
            ->setReviewUrl($reviewUrl)
            ->setSmallImageId($smallImageId)
            ->setSocialNetworkImageId($socialNetworkImageId)
            ->setThumbnailImageId($thumbnailImageId)
            ->setTrailerUrl($trailerUrl);
    }
    /**
     * Get BriefOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBriefOverview()
    {
        return isset($this->BriefOverview) ? $this->BriefOverview : null;
    }
    /**
     * Set BriefOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $briefOverview
     * @return \patest\StructType\Ticketing_Media
     */
    public function setBriefOverview(\patest\StructType\GlobalString $briefOverview = null)
    {
        if (is_null($briefOverview) || (is_array($briefOverview) && empty($briefOverview))) {
            unset($this->BriefOverview);
        } else {
            $this->BriefOverview = $briefOverview;
        }
        return $this;
    }
    /**
     * Get DetailOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDetailOverview()
    {
        return isset($this->DetailOverview) ? $this->DetailOverview : null;
    }
    /**
     * Set DetailOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $detailOverview
     * @return \patest\StructType\Ticketing_Media
     */
    public function setDetailOverview(\patest\StructType\GlobalString $detailOverview = null)
    {
        if (is_null($detailOverview) || (is_array($detailOverview) && empty($detailOverview))) {
            unset($this->DetailOverview);
        } else {
            $this->DetailOverview = $detailOverview;
        }
        return $this;
    }
    /**
     * Get EffectiveLargeImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveLargeImageUrl()
    {
        return isset($this->EffectiveLargeImageUrl) ? $this->EffectiveLargeImageUrl : null;
    }
    /**
     * Set EffectiveLargeImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveLargeImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectiveLargeImageUrl($effectiveLargeImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveLargeImageUrl) && !is_string($effectiveLargeImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveLargeImageUrl, true), gettype($effectiveLargeImageUrl)), __LINE__);
        }
        if (is_null($effectiveLargeImageUrl) || (is_array($effectiveLargeImageUrl) && empty($effectiveLargeImageUrl))) {
            unset($this->EffectiveLargeImageUrl);
        } else {
            $this->EffectiveLargeImageUrl = $effectiveLargeImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveMediumImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveMediumImageUrl()
    {
        return isset($this->EffectiveMediumImageUrl) ? $this->EffectiveMediumImageUrl : null;
    }
    /**
     * Set EffectiveMediumImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveMediumImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectiveMediumImageUrl($effectiveMediumImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveMediumImageUrl) && !is_string($effectiveMediumImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveMediumImageUrl, true), gettype($effectiveMediumImageUrl)), __LINE__);
        }
        if (is_null($effectiveMediumImageUrl) || (is_array($effectiveMediumImageUrl) && empty($effectiveMediumImageUrl))) {
            unset($this->EffectiveMediumImageUrl);
        } else {
            $this->EffectiveMediumImageUrl = $effectiveMediumImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveOnlineHeroImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveOnlineHeroImageUrl()
    {
        return isset($this->EffectiveOnlineHeroImageUrl) ? $this->EffectiveOnlineHeroImageUrl : null;
    }
    /**
     * Set EffectiveOnlineHeroImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveOnlineHeroImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectiveOnlineHeroImageUrl($effectiveOnlineHeroImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveOnlineHeroImageUrl) && !is_string($effectiveOnlineHeroImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveOnlineHeroImageUrl, true), gettype($effectiveOnlineHeroImageUrl)), __LINE__);
        }
        if (is_null($effectiveOnlineHeroImageUrl) || (is_array($effectiveOnlineHeroImageUrl) && empty($effectiveOnlineHeroImageUrl))) {
            unset($this->EffectiveOnlineHeroImageUrl);
        } else {
            $this->EffectiveOnlineHeroImageUrl = $effectiveOnlineHeroImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveOnlineThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveOnlineThumbnailImageUrl()
    {
        return isset($this->EffectiveOnlineThumbnailImageUrl) ? $this->EffectiveOnlineThumbnailImageUrl : null;
    }
    /**
     * Set EffectiveOnlineThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveOnlineThumbnailImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectiveOnlineThumbnailImageUrl($effectiveOnlineThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveOnlineThumbnailImageUrl) && !is_string($effectiveOnlineThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveOnlineThumbnailImageUrl, true), gettype($effectiveOnlineThumbnailImageUrl)), __LINE__);
        }
        if (is_null($effectiveOnlineThumbnailImageUrl) || (is_array($effectiveOnlineThumbnailImageUrl) && empty($effectiveOnlineThumbnailImageUrl))) {
            unset($this->EffectiveOnlineThumbnailImageUrl);
        } else {
            $this->EffectiveOnlineThumbnailImageUrl = $effectiveOnlineThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectivePassbookImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectivePassbookImageUrl()
    {
        return isset($this->EffectivePassbookImageUrl) ? $this->EffectivePassbookImageUrl : null;
    }
    /**
     * Set EffectivePassbookImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectivePassbookImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectivePassbookImageUrl($effectivePassbookImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectivePassbookImageUrl) && !is_string($effectivePassbookImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectivePassbookImageUrl, true), gettype($effectivePassbookImageUrl)), __LINE__);
        }
        if (is_null($effectivePassbookImageUrl) || (is_array($effectivePassbookImageUrl) && empty($effectivePassbookImageUrl))) {
            unset($this->EffectivePassbookImageUrl);
        } else {
            $this->EffectivePassbookImageUrl = $effectivePassbookImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveSmallImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveSmallImageUrl()
    {
        return isset($this->EffectiveSmallImageUrl) ? $this->EffectiveSmallImageUrl : null;
    }
    /**
     * Set EffectiveSmallImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveSmallImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectiveSmallImageUrl($effectiveSmallImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveSmallImageUrl) && !is_string($effectiveSmallImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveSmallImageUrl, true), gettype($effectiveSmallImageUrl)), __LINE__);
        }
        if (is_null($effectiveSmallImageUrl) || (is_array($effectiveSmallImageUrl) && empty($effectiveSmallImageUrl))) {
            unset($this->EffectiveSmallImageUrl);
        } else {
            $this->EffectiveSmallImageUrl = $effectiveSmallImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveSocialNetworkImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveSocialNetworkImageUrl()
    {
        return isset($this->EffectiveSocialNetworkImageUrl) ? $this->EffectiveSocialNetworkImageUrl : null;
    }
    /**
     * Set EffectiveSocialNetworkImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveSocialNetworkImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectiveSocialNetworkImageUrl($effectiveSocialNetworkImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveSocialNetworkImageUrl) && !is_string($effectiveSocialNetworkImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveSocialNetworkImageUrl, true), gettype($effectiveSocialNetworkImageUrl)), __LINE__);
        }
        if (is_null($effectiveSocialNetworkImageUrl) || (is_array($effectiveSocialNetworkImageUrl) && empty($effectiveSocialNetworkImageUrl))) {
            unset($this->EffectiveSocialNetworkImageUrl);
        } else {
            $this->EffectiveSocialNetworkImageUrl = $effectiveSocialNetworkImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveThumbnailImageUrl()
    {
        return isset($this->EffectiveThumbnailImageUrl) ? $this->EffectiveThumbnailImageUrl : null;
    }
    /**
     * Set EffectiveThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveThumbnailImageUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setEffectiveThumbnailImageUrl($effectiveThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveThumbnailImageUrl) && !is_string($effectiveThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveThumbnailImageUrl, true), gettype($effectiveThumbnailImageUrl)), __LINE__);
        }
        if (is_null($effectiveThumbnailImageUrl) || (is_array($effectiveThumbnailImageUrl) && empty($effectiveThumbnailImageUrl))) {
            unset($this->EffectiveThumbnailImageUrl);
        } else {
            $this->EffectiveThumbnailImageUrl = $effectiveThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get ImageMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_ImageMedia|null
     */
    public function getImageMedia()
    {
        return isset($this->ImageMedia) ? $this->ImageMedia : null;
    }
    /**
     * Set ImageMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_ImageMedia $imageMedia
     * @return \patest\StructType\Ticketing_Media
     */
    public function setImageMedia(\patest\StructType\RecordSetOfTicketing_ImageMedia $imageMedia = null)
    {
        if (is_null($imageMedia) || (is_array($imageMedia) && empty($imageMedia))) {
            unset($this->ImageMedia);
        } else {
            $this->ImageMedia = $imageMedia;
        }
        return $this;
    }
    /**
     * Get Incentive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getIncentive()
    {
        return isset($this->Incentive) ? $this->Incentive : null;
    }
    /**
     * Set Incentive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $incentive
     * @return \patest\StructType\Ticketing_Media
     */
    public function setIncentive(\patest\StructType\GlobalString $incentive = null)
    {
        if (is_null($incentive) || (is_array($incentive) && empty($incentive))) {
            unset($this->Incentive);
        } else {
            $this->Incentive = $incentive;
        }
        return $this;
    }
    /**
     * Get LargeImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLargeImageId()
    {
        return isset($this->LargeImageId) ? $this->LargeImageId : null;
    }
    /**
     * Set LargeImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $largeImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setLargeImageId($largeImageId = null)
    {
        // validation for constraint: int
        if (!is_null($largeImageId) && !(is_int($largeImageId) || ctype_digit($largeImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largeImageId, true), gettype($largeImageId)), __LINE__);
        }
        if (is_null($largeImageId) || (is_array($largeImageId) && empty($largeImageId))) {
            unset($this->LargeImageId);
        } else {
            $this->LargeImageId = $largeImageId;
        }
        return $this;
    }
    /**
     * Get MediumImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMediumImageId()
    {
        return isset($this->MediumImageId) ? $this->MediumImageId : null;
    }
    /**
     * Set MediumImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mediumImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setMediumImageId($mediumImageId = null)
    {
        // validation for constraint: int
        if (!is_null($mediumImageId) && !(is_int($mediumImageId) || ctype_digit($mediumImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mediumImageId, true), gettype($mediumImageId)), __LINE__);
        }
        if (is_null($mediumImageId) || (is_array($mediumImageId) && empty($mediumImageId))) {
            unset($this->MediumImageId);
        } else {
            $this->MediumImageId = $mediumImageId;
        }
        return $this;
    }
    /**
     * Get OnlineHeroImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnlineHeroImageId()
    {
        return isset($this->OnlineHeroImageId) ? $this->OnlineHeroImageId : null;
    }
    /**
     * Set OnlineHeroImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onlineHeroImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setOnlineHeroImageId($onlineHeroImageId = null)
    {
        // validation for constraint: int
        if (!is_null($onlineHeroImageId) && !(is_int($onlineHeroImageId) || ctype_digit($onlineHeroImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineHeroImageId, true), gettype($onlineHeroImageId)), __LINE__);
        }
        if (is_null($onlineHeroImageId) || (is_array($onlineHeroImageId) && empty($onlineHeroImageId))) {
            unset($this->OnlineHeroImageId);
        } else {
            $this->OnlineHeroImageId = $onlineHeroImageId;
        }
        return $this;
    }
    /**
     * Get OnlineThumbnailImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnlineThumbnailImageId()
    {
        return isset($this->OnlineThumbnailImageId) ? $this->OnlineThumbnailImageId : null;
    }
    /**
     * Set OnlineThumbnailImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onlineThumbnailImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setOnlineThumbnailImageId($onlineThumbnailImageId = null)
    {
        // validation for constraint: int
        if (!is_null($onlineThumbnailImageId) && !(is_int($onlineThumbnailImageId) || ctype_digit($onlineThumbnailImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineThumbnailImageId, true), gettype($onlineThumbnailImageId)), __LINE__);
        }
        if (is_null($onlineThumbnailImageId) || (is_array($onlineThumbnailImageId) && empty($onlineThumbnailImageId))) {
            unset($this->OnlineThumbnailImageId);
        } else {
            $this->OnlineThumbnailImageId = $onlineThumbnailImageId;
        }
        return $this;
    }
    /**
     * Get PassbookDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPassbookDescription()
    {
        return isset($this->PassbookDescription) ? $this->PassbookDescription : null;
    }
    /**
     * Set PassbookDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $passbookDescription
     * @return \patest\StructType\Ticketing_Media
     */
    public function setPassbookDescription(\patest\StructType\GlobalString $passbookDescription = null)
    {
        if (is_null($passbookDescription) || (is_array($passbookDescription) && empty($passbookDescription))) {
            unset($this->PassbookDescription);
        } else {
            $this->PassbookDescription = $passbookDescription;
        }
        return $this;
    }
    /**
     * Get PassbookImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPassbookImageId()
    {
        return isset($this->PassbookImageId) ? $this->PassbookImageId : null;
    }
    /**
     * Set PassbookImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $passbookImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setPassbookImageId($passbookImageId = null)
    {
        // validation for constraint: int
        if (!is_null($passbookImageId) && !(is_int($passbookImageId) || ctype_digit($passbookImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passbookImageId, true), gettype($passbookImageId)), __LINE__);
        }
        if (is_null($passbookImageId) || (is_array($passbookImageId) && empty($passbookImageId))) {
            unset($this->PassbookImageId);
        } else {
            $this->PassbookImageId = $passbookImageId;
        }
        return $this;
    }
    /**
     * Get ReviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getReviewUrl()
    {
        return isset($this->ReviewUrl) ? $this->ReviewUrl : null;
    }
    /**
     * Set ReviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $reviewUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setReviewUrl(\patest\StructType\GlobalString $reviewUrl = null)
    {
        if (is_null($reviewUrl) || (is_array($reviewUrl) && empty($reviewUrl))) {
            unset($this->ReviewUrl);
        } else {
            $this->ReviewUrl = $reviewUrl;
        }
        return $this;
    }
    /**
     * Get SmallImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSmallImageId()
    {
        return isset($this->SmallImageId) ? $this->SmallImageId : null;
    }
    /**
     * Set SmallImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $smallImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setSmallImageId($smallImageId = null)
    {
        // validation for constraint: int
        if (!is_null($smallImageId) && !(is_int($smallImageId) || ctype_digit($smallImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($smallImageId, true), gettype($smallImageId)), __LINE__);
        }
        if (is_null($smallImageId) || (is_array($smallImageId) && empty($smallImageId))) {
            unset($this->SmallImageId);
        } else {
            $this->SmallImageId = $smallImageId;
        }
        return $this;
    }
    /**
     * Get SocialNetworkImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSocialNetworkImageId()
    {
        return isset($this->SocialNetworkImageId) ? $this->SocialNetworkImageId : null;
    }
    /**
     * Set SocialNetworkImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $socialNetworkImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setSocialNetworkImageId($socialNetworkImageId = null)
    {
        // validation for constraint: int
        if (!is_null($socialNetworkImageId) && !(is_int($socialNetworkImageId) || ctype_digit($socialNetworkImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($socialNetworkImageId, true), gettype($socialNetworkImageId)), __LINE__);
        }
        if (is_null($socialNetworkImageId) || (is_array($socialNetworkImageId) && empty($socialNetworkImageId))) {
            unset($this->SocialNetworkImageId);
        } else {
            $this->SocialNetworkImageId = $socialNetworkImageId;
        }
        return $this;
    }
    /**
     * Get ThumbnailImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getThumbnailImageId()
    {
        return isset($this->ThumbnailImageId) ? $this->ThumbnailImageId : null;
    }
    /**
     * Set ThumbnailImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $thumbnailImageId
     * @return \patest\StructType\Ticketing_Media
     */
    public function setThumbnailImageId($thumbnailImageId = null)
    {
        // validation for constraint: int
        if (!is_null($thumbnailImageId) && !(is_int($thumbnailImageId) || ctype_digit($thumbnailImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thumbnailImageId, true), gettype($thumbnailImageId)), __LINE__);
        }
        if (is_null($thumbnailImageId) || (is_array($thumbnailImageId) && empty($thumbnailImageId))) {
            unset($this->ThumbnailImageId);
        } else {
            $this->ThumbnailImageId = $thumbnailImageId;
        }
        return $this;
    }
    /**
     * Get TrailerUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTrailerUrl()
    {
        return isset($this->TrailerUrl) ? $this->TrailerUrl : null;
    }
    /**
     * Set TrailerUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $trailerUrl
     * @return \patest\StructType\Ticketing_Media
     */
    public function setTrailerUrl(\patest\StructType\GlobalString $trailerUrl = null)
    {
        if (is_null($trailerUrl) || (is_array($trailerUrl) && empty($trailerUrl))) {
            unset($this->TrailerUrl);
        } else {
            $this->TrailerUrl = $trailerUrl;
        }
        return $this;
    }
}
