<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.LimitationGroup StructType
 * @subpackage Structs
 */
class Ticketing_LimitationGroup extends PersistableEntity
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The LimitationAppliesTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitationAppliesTo;
    /**
     * The Limitations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Limitation
     */
    public $Limitations;
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypes
     */
    public $PriceTypes;
    /**
     * The ScopeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScopeId;
    /**
     * The ScopeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScopeNumber;
    /**
     * The ScopeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScopeType;
    /**
     * Constructor method for Ticketing.LimitationGroup
     * @uses Ticketing_LimitationGroup::setDetails()
     * @uses Ticketing_LimitationGroup::setLimitationAppliesTo()
     * @uses Ticketing_LimitationGroup::setLimitations()
     * @uses Ticketing_LimitationGroup::setPriceTypes()
     * @uses Ticketing_LimitationGroup::setScopeId()
     * @uses Ticketing_LimitationGroup::setScopeNumber()
     * @uses Ticketing_LimitationGroup::setScopeType()
     * @param string $details
     * @param string $limitationAppliesTo
     * @param \patest\StructType\RecordSetOfTicketing_Limitation $limitations
     * @param \patest\StructType\PriceTypes $priceTypes
     * @param string $scopeId
     * @param int $scopeNumber
     * @param string $scopeType
     */
    public function __construct($details = null, $limitationAppliesTo = null, \patest\StructType\RecordSetOfTicketing_Limitation $limitations = null, \patest\StructType\PriceTypes $priceTypes = null, $scopeId = null, $scopeNumber = null, $scopeType = null)
    {
        $this
            ->setDetails($details)
            ->setLimitationAppliesTo($limitationAppliesTo)
            ->setLimitations($limitations)
            ->setPriceTypes($priceTypes)
            ->setScopeId($scopeId)
            ->setScopeNumber($scopeNumber)
            ->setScopeType($scopeType);
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Ticketing_LimitationGroup
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get LimitationAppliesTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitationAppliesTo()
    {
        return isset($this->LimitationAppliesTo) ? $this->LimitationAppliesTo : null;
    }
    /**
     * Set LimitationAppliesTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LimitationAppliesToType::valueIsValid()
     * @uses \patest\EnumType\LimitationAppliesToType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitationAppliesTo
     * @return \patest\StructType\Ticketing_LimitationGroup
     */
    public function setLimitationAppliesTo($limitationAppliesTo = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationAppliesToType::valueIsValid($limitationAppliesTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationAppliesToType', is_array($limitationAppliesTo) ? implode(', ', $limitationAppliesTo) : var_export($limitationAppliesTo, true), implode(', ', \patest\EnumType\LimitationAppliesToType::getValidValues())), __LINE__);
        }
        if (is_null($limitationAppliesTo) || (is_array($limitationAppliesTo) && empty($limitationAppliesTo))) {
            unset($this->LimitationAppliesTo);
        } else {
            $this->LimitationAppliesTo = $limitationAppliesTo;
        }
        return $this;
    }
    /**
     * Get Limitations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Limitation|null
     */
    public function getLimitations()
    {
        return isset($this->Limitations) ? $this->Limitations : null;
    }
    /**
     * Set Limitations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Limitation $limitations
     * @return \patest\StructType\Ticketing_LimitationGroup
     */
    public function setLimitations(\patest\StructType\RecordSetOfTicketing_Limitation $limitations = null)
    {
        if (is_null($limitations) || (is_array($limitations) && empty($limitations))) {
            unset($this->Limitations);
        } else {
            $this->Limitations = $limitations;
        }
        return $this;
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypes|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypes $priceTypes
     * @return \patest\StructType\Ticketing_LimitationGroup
     */
    public function setPriceTypes(\patest\StructType\PriceTypes $priceTypes = null)
    {
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
    /**
     * Get ScopeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScopeId()
    {
        return isset($this->ScopeId) ? $this->ScopeId : null;
    }
    /**
     * Set ScopeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scopeId
     * @return \patest\StructType\Ticketing_LimitationGroup
     */
    public function setScopeId($scopeId = null)
    {
        // validation for constraint: string
        if (!is_null($scopeId) && !is_string($scopeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scopeId, true), gettype($scopeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scopeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scopeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scopeId, true)), __LINE__);
        }
        if (is_null($scopeId) || (is_array($scopeId) && empty($scopeId))) {
            unset($this->ScopeId);
        } else {
            $this->ScopeId = $scopeId;
        }
        return $this;
    }
    /**
     * Get ScopeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScopeNumber()
    {
        return isset($this->ScopeNumber) ? $this->ScopeNumber : null;
    }
    /**
     * Set ScopeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scopeNumber
     * @return \patest\StructType\Ticketing_LimitationGroup
     */
    public function setScopeNumber($scopeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($scopeNumber) && !(is_int($scopeNumber) || ctype_digit($scopeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scopeNumber, true), gettype($scopeNumber)), __LINE__);
        }
        if (is_null($scopeNumber) || (is_array($scopeNumber) && empty($scopeNumber))) {
            unset($this->ScopeNumber);
        } else {
            $this->ScopeNumber = $scopeNumber;
        }
        return $this;
    }
    /**
     * Get ScopeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScopeType()
    {
        return isset($this->ScopeType) ? $this->ScopeType : null;
    }
    /**
     * Set ScopeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LimitationScopeType::valueIsValid()
     * @uses \patest\EnumType\LimitationScopeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scopeType
     * @return \patest\StructType\Ticketing_LimitationGroup
     */
    public function setScopeType($scopeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationScopeType::valueIsValid($scopeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationScopeType', is_array($scopeType) ? implode(', ', $scopeType) : var_export($scopeType, true), implode(', ', \patest\EnumType\LimitationScopeType::getValidValues())), __LINE__);
        }
        if (is_null($scopeType) || (is_array($scopeType) && empty($scopeType))) {
            unset($this->ScopeType);
        } else {
            $this->ScopeType = $scopeType;
        }
        return $this;
    }
}
