<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.HallVersion StructType
 * @subpackage Structs
 */
class Ticketing_HallVersion extends Ticketing_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_HallVersionAreaMap
     */
    public $Areas;
    /**
     * The BackgroundImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BackgroundImageId;
    /**
     * The BackgroundImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackgroundImageUrl;
    /**
     * The ConstructionProblems
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConstructionProblems;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The GaCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GaCapacity;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The HasConstructionProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasConstructionProblems;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Notes;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The RsCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RsCapacity;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ViewXaml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewXaml;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.HallVersion
     * @uses Ticketing_HallVersion::setAclSchemeId()
     * @uses Ticketing_HallVersion::setActive()
     * @uses Ticketing_HallVersion::setAreas()
     * @uses Ticketing_HallVersion::setBackgroundImageId()
     * @uses Ticketing_HallVersion::setBackgroundImageUrl()
     * @uses Ticketing_HallVersion::setConstructionProblems()
     * @uses Ticketing_HallVersion::setEntityVersion()
     * @uses Ticketing_HallVersion::setEventGuid()
     * @uses Ticketing_HallVersion::setGaCapacity()
     * @uses Ticketing_HallVersion::setHallId()
     * @uses Ticketing_HallVersion::setHallName()
     * @uses Ticketing_HallVersion::setHasConstructionProblems()
     * @uses Ticketing_HallVersion::setName()
     * @uses Ticketing_HallVersion::setNotes()
     * @uses Ticketing_HallVersion::setOrganizationUnitId()
     * @uses Ticketing_HallVersion::setRsCapacity()
     * @uses Ticketing_HallVersion::setStatus()
     * @uses Ticketing_HallVersion::setViewXaml()
     * @uses Ticketing_HallVersion::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param bool $active
     * @param \patest\StructType\RecordSetOfTicketing_HallVersionAreaMap $areas
     * @param int $backgroundImageId
     * @param string $backgroundImageUrl
     * @param string $constructionProblems
     * @param string $entityVersion
     * @param string $eventGuid
     * @param int $gaCapacity
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param bool $hasConstructionProblems
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $notes
     * @param string $organizationUnitId
     * @param int $rsCapacity
     * @param string $status
     * @param string $viewXaml
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $active = null, \patest\StructType\RecordSetOfTicketing_HallVersionAreaMap $areas = null, $backgroundImageId = null, $backgroundImageUrl = null, $constructionProblems = null, $entityVersion = null, $eventGuid = null, $gaCapacity = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $hasConstructionProblems = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $notes = null, $organizationUnitId = null, $rsCapacity = null, $status = null, $viewXaml = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setActive($active)
            ->setAreas($areas)
            ->setBackgroundImageId($backgroundImageId)
            ->setBackgroundImageUrl($backgroundImageUrl)
            ->setConstructionProblems($constructionProblems)
            ->setEntityVersion($entityVersion)
            ->setEventGuid($eventGuid)
            ->setGaCapacity($gaCapacity)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setHasConstructionProblems($hasConstructionProblems)
            ->setName($name)
            ->setNotes($notes)
            ->setOrganizationUnitId($organizationUnitId)
            ->setRsCapacity($rsCapacity)
            ->setStatus($status)
            ->setViewXaml($viewXaml)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Areas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_HallVersionAreaMap|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * Set Areas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_HallVersionAreaMap $areas
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setAreas(\patest\StructType\RecordSetOfTicketing_HallVersionAreaMap $areas = null)
    {
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Get BackgroundImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBackgroundImageId()
    {
        return isset($this->BackgroundImageId) ? $this->BackgroundImageId : null;
    }
    /**
     * Set BackgroundImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $backgroundImageId
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setBackgroundImageId($backgroundImageId = null)
    {
        // validation for constraint: int
        if (!is_null($backgroundImageId) && !(is_int($backgroundImageId) || ctype_digit($backgroundImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($backgroundImageId, true), gettype($backgroundImageId)), __LINE__);
        }
        if (is_null($backgroundImageId) || (is_array($backgroundImageId) && empty($backgroundImageId))) {
            unset($this->BackgroundImageId);
        } else {
            $this->BackgroundImageId = $backgroundImageId;
        }
        return $this;
    }
    /**
     * Get BackgroundImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackgroundImageUrl()
    {
        return isset($this->BackgroundImageUrl) ? $this->BackgroundImageUrl : null;
    }
    /**
     * Set BackgroundImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backgroundImageUrl
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setBackgroundImageUrl($backgroundImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundImageUrl) && !is_string($backgroundImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundImageUrl, true), gettype($backgroundImageUrl)), __LINE__);
        }
        if (is_null($backgroundImageUrl) || (is_array($backgroundImageUrl) && empty($backgroundImageUrl))) {
            unset($this->BackgroundImageUrl);
        } else {
            $this->BackgroundImageUrl = $backgroundImageUrl;
        }
        return $this;
    }
    /**
     * Get ConstructionProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConstructionProblems()
    {
        return isset($this->ConstructionProblems) ? $this->ConstructionProblems : null;
    }
    /**
     * Set ConstructionProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $constructionProblems
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setConstructionProblems($constructionProblems = null)
    {
        // validation for constraint: string
        if (!is_null($constructionProblems) && !is_string($constructionProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($constructionProblems, true), gettype($constructionProblems)), __LINE__);
        }
        if (is_null($constructionProblems) || (is_array($constructionProblems) && empty($constructionProblems))) {
            unset($this->ConstructionProblems);
        } else {
            $this->ConstructionProblems = $constructionProblems;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get GaCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGaCapacity()
    {
        return isset($this->GaCapacity) ? $this->GaCapacity : null;
    }
    /**
     * Set GaCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gaCapacity
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setGaCapacity($gaCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($gaCapacity) && !(is_int($gaCapacity) || ctype_digit($gaCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gaCapacity, true), gettype($gaCapacity)), __LINE__);
        }
        if (is_null($gaCapacity) || (is_array($gaCapacity) && empty($gaCapacity))) {
            unset($this->GaCapacity);
        } else {
            $this->GaCapacity = $gaCapacity;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HasConstructionProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasConstructionProblems()
    {
        return isset($this->HasConstructionProblems) ? $this->HasConstructionProblems : null;
    }
    /**
     * Set HasConstructionProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasConstructionProblems
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setHasConstructionProblems($hasConstructionProblems = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasConstructionProblems) && !is_bool($hasConstructionProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasConstructionProblems, true), gettype($hasConstructionProblems)), __LINE__);
        }
        if (is_null($hasConstructionProblems) || (is_array($hasConstructionProblems) && empty($hasConstructionProblems))) {
            unset($this->HasConstructionProblems);
        } else {
            $this->HasConstructionProblems = $hasConstructionProblems;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $notes
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setNotes(\patest\StructType\GlobalString $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get RsCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRsCapacity()
    {
        return isset($this->RsCapacity) ? $this->RsCapacity : null;
    }
    /**
     * Set RsCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rsCapacity
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setRsCapacity($rsCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($rsCapacity) && !(is_int($rsCapacity) || ctype_digit($rsCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rsCapacity, true), gettype($rsCapacity)), __LINE__);
        }
        if (is_null($rsCapacity) || (is_array($rsCapacity) && empty($rsCapacity))) {
            unset($this->RsCapacity);
        } else {
            $this->RsCapacity = $rsCapacity;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HallVersionStatus::valueIsValid()
     * @uses \patest\EnumType\HallVersionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallVersionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallVersionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\HallVersionStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get ViewXaml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewXaml()
    {
        return isset($this->ViewXaml) ? $this->ViewXaml : null;
    }
    /**
     * Set ViewXaml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewXaml
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setViewXaml($viewXaml = null)
    {
        // validation for constraint: string
        if (!is_null($viewXaml) && !is_string($viewXaml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewXaml, true), gettype($viewXaml)), __LINE__);
        }
        if (is_null($viewXaml) || (is_array($viewXaml) && empty($viewXaml))) {
            unset($this->ViewXaml);
        } else {
            $this->ViewXaml = $viewXaml;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_HallVersion
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
