<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Hall StructType
 * @subpackage Structs
 */
class Ticketing_Hall extends Ticketing_Base
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_EntityAccessControlData
     */
    public $AccessControlData;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Area
     */
    public $Areas;
    /**
     * The DefaultHallVersionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultHallVersionGuid;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The EventsOverlapPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsOverlapPolicy;
    /**
     * The Gates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Gate
     */
    public $Gates;
    /**
     * The HasActiveVersionsWithConstructionProblems
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasActiveVersionsWithConstructionProblems;
    /**
     * The IsBackgroundImage3D
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBackgroundImage3D;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PrintedName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PrintedName;
    /**
     * The ScannerIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ScannerIds
     */
    public $ScannerIds;
    /**
     * The SeatingPlanDisplaysHallMapFirst
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SeatingPlanDisplaysHallMapFirst;
    /**
     * The StageImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StageImageId;
    /**
     * The Stands
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Stand
     */
    public $Stands;
    /**
     * The Turnstiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Turnstile
     */
    public $Turnstiles;
    /**
     * The VenueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VenueId;
    /**
     * The Versions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_HallVersion
     */
    public $Versions;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.Hall
     * @uses Ticketing_Hall::setAccessControlData()
     * @uses Ticketing_Hall::setAclSchemeId()
     * @uses Ticketing_Hall::setActive()
     * @uses Ticketing_Hall::setAreas()
     * @uses Ticketing_Hall::setDefaultHallVersionGuid()
     * @uses Ticketing_Hall::setDescription()
     * @uses Ticketing_Hall::setDisplayStyleValue()
     * @uses Ticketing_Hall::setEntityVersion()
     * @uses Ticketing_Hall::setEventsOverlapPolicy()
     * @uses Ticketing_Hall::setGates()
     * @uses Ticketing_Hall::setHasActiveVersionsWithConstructionProblems()
     * @uses Ticketing_Hall::setIsBackgroundImage3D()
     * @uses Ticketing_Hall::setName()
     * @uses Ticketing_Hall::setOrdinal()
     * @uses Ticketing_Hall::setOrganizationUnitId()
     * @uses Ticketing_Hall::setPrintedName()
     * @uses Ticketing_Hall::setScannerIds()
     * @uses Ticketing_Hall::setSeatingPlanDisplaysHallMapFirst()
     * @uses Ticketing_Hall::setStageImageId()
     * @uses Ticketing_Hall::setStands()
     * @uses Ticketing_Hall::setTurnstiles()
     * @uses Ticketing_Hall::setVenueId()
     * @uses Ticketing_Hall::setVersions()
     * @uses Ticketing_Hall::setVisibleBySubordinates()
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @param int $aclSchemeId
     * @param bool $active
     * @param \patest\StructType\RecordSetOfTicketing_Area $areas
     * @param string $defaultHallVersionGuid
     * @param \patest\StructType\GlobalString $description
     * @param string $displayStyleValue
     * @param string $entityVersion
     * @param string $eventsOverlapPolicy
     * @param \patest\StructType\RecordSetOfTicketing_Gate $gates
     * @param bool $hasActiveVersionsWithConstructionProblems
     * @param bool $isBackgroundImage3D
     * @param \patest\StructType\GlobalString $name
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param \patest\StructType\GlobalString $printedName
     * @param \patest\StructType\ScannerIds $scannerIds
     * @param bool $seatingPlanDisplaysHallMapFirst
     * @param int $stageImageId
     * @param \patest\StructType\RecordSetOfTicketing_Stand $stands
     * @param \patest\StructType\RecordSetOfTicketing_Turnstile $turnstiles
     * @param string $venueId
     * @param \patest\StructType\RecordSetOfTicketing_HallVersion $versions
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null, $aclSchemeId = null, $active = null, \patest\StructType\RecordSetOfTicketing_Area $areas = null, $defaultHallVersionGuid = null, \patest\StructType\GlobalString $description = null, $displayStyleValue = null, $entityVersion = null, $eventsOverlapPolicy = null, \patest\StructType\RecordSetOfTicketing_Gate $gates = null, $hasActiveVersionsWithConstructionProblems = null, $isBackgroundImage3D = null, \patest\StructType\GlobalString $name = null, $ordinal = null, $organizationUnitId = null, \patest\StructType\GlobalString $printedName = null, \patest\StructType\ScannerIds $scannerIds = null, $seatingPlanDisplaysHallMapFirst = null, $stageImageId = null, \patest\StructType\RecordSetOfTicketing_Stand $stands = null, \patest\StructType\RecordSetOfTicketing_Turnstile $turnstiles = null, $venueId = null, \patest\StructType\RecordSetOfTicketing_HallVersion $versions = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setAclSchemeId($aclSchemeId)
            ->setActive($active)
            ->setAreas($areas)
            ->setDefaultHallVersionGuid($defaultHallVersionGuid)
            ->setDescription($description)
            ->setDisplayStyleValue($displayStyleValue)
            ->setEntityVersion($entityVersion)
            ->setEventsOverlapPolicy($eventsOverlapPolicy)
            ->setGates($gates)
            ->setHasActiveVersionsWithConstructionProblems($hasActiveVersionsWithConstructionProblems)
            ->setIsBackgroundImage3D($isBackgroundImage3D)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrintedName($printedName)
            ->setScannerIds($scannerIds)
            ->setSeatingPlanDisplaysHallMapFirst($seatingPlanDisplaysHallMapFirst)
            ->setStageImageId($stageImageId)
            ->setStands($stands)
            ->setTurnstiles($turnstiles)
            ->setVenueId($venueId)
            ->setVersions($versions)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_EntityAccessControlData|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setAccessControlData(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $active
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Areas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Area|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * Set Areas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Area $areas
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setAreas(\patest\StructType\RecordSetOfTicketing_Area $areas = null)
    {
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Get DefaultHallVersionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultHallVersionGuid()
    {
        return isset($this->DefaultHallVersionGuid) ? $this->DefaultHallVersionGuid : null;
    }
    /**
     * Set DefaultHallVersionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultHallVersionGuid
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setDefaultHallVersionGuid($defaultHallVersionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($defaultHallVersionGuid) && !is_string($defaultHallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultHallVersionGuid, true), gettype($defaultHallVersionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultHallVersionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultHallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultHallVersionGuid, true)), __LINE__);
        }
        if (is_null($defaultHallVersionGuid) || (is_array($defaultHallVersionGuid) && empty($defaultHallVersionGuid))) {
            unset($this->DefaultHallVersionGuid);
        } else {
            $this->DefaultHallVersionGuid = $defaultHallVersionGuid;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get EventsOverlapPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsOverlapPolicy()
    {
        return isset($this->EventsOverlapPolicy) ? $this->EventsOverlapPolicy : null;
    }
    /**
     * Set EventsOverlapPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventsOverlapPolicy::valueIsValid()
     * @uses \patest\EnumType\EventsOverlapPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventsOverlapPolicy
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setEventsOverlapPolicy($eventsOverlapPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventsOverlapPolicy::valueIsValid($eventsOverlapPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventsOverlapPolicy', is_array($eventsOverlapPolicy) ? implode(', ', $eventsOverlapPolicy) : var_export($eventsOverlapPolicy, true), implode(', ', \patest\EnumType\EventsOverlapPolicy::getValidValues())), __LINE__);
        }
        if (is_null($eventsOverlapPolicy) || (is_array($eventsOverlapPolicy) && empty($eventsOverlapPolicy))) {
            unset($this->EventsOverlapPolicy);
        } else {
            $this->EventsOverlapPolicy = $eventsOverlapPolicy;
        }
        return $this;
    }
    /**
     * Get Gates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Gate|null
     */
    public function getGates()
    {
        return isset($this->Gates) ? $this->Gates : null;
    }
    /**
     * Set Gates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Gate $gates
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setGates(\patest\StructType\RecordSetOfTicketing_Gate $gates = null)
    {
        if (is_null($gates) || (is_array($gates) && empty($gates))) {
            unset($this->Gates);
        } else {
            $this->Gates = $gates;
        }
        return $this;
    }
    /**
     * Get HasActiveVersionsWithConstructionProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasActiveVersionsWithConstructionProblems()
    {
        return isset($this->HasActiveVersionsWithConstructionProblems) ? $this->HasActiveVersionsWithConstructionProblems : null;
    }
    /**
     * Set HasActiveVersionsWithConstructionProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasActiveVersionsWithConstructionProblems
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setHasActiveVersionsWithConstructionProblems($hasActiveVersionsWithConstructionProblems = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasActiveVersionsWithConstructionProblems) && !is_bool($hasActiveVersionsWithConstructionProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasActiveVersionsWithConstructionProblems, true), gettype($hasActiveVersionsWithConstructionProblems)), __LINE__);
        }
        if (is_null($hasActiveVersionsWithConstructionProblems) || (is_array($hasActiveVersionsWithConstructionProblems) && empty($hasActiveVersionsWithConstructionProblems))) {
            unset($this->HasActiveVersionsWithConstructionProblems);
        } else {
            $this->HasActiveVersionsWithConstructionProblems = $hasActiveVersionsWithConstructionProblems;
        }
        return $this;
    }
    /**
     * Get IsBackgroundImage3D value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBackgroundImage3D()
    {
        return isset($this->IsBackgroundImage3D) ? $this->IsBackgroundImage3D : null;
    }
    /**
     * Set IsBackgroundImage3D value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBackgroundImage3D
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setIsBackgroundImage3D($isBackgroundImage3D = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBackgroundImage3D) && !is_bool($isBackgroundImage3D)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBackgroundImage3D, true), gettype($isBackgroundImage3D)), __LINE__);
        }
        if (is_null($isBackgroundImage3D) || (is_array($isBackgroundImage3D) && empty($isBackgroundImage3D))) {
            unset($this->IsBackgroundImage3D);
        } else {
            $this->IsBackgroundImage3D = $isBackgroundImage3D;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PrintedName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPrintedName()
    {
        return isset($this->PrintedName) ? $this->PrintedName : null;
    }
    /**
     * Set PrintedName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $printedName
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setPrintedName(\patest\StructType\GlobalString $printedName = null)
    {
        if (is_null($printedName) || (is_array($printedName) && empty($printedName))) {
            unset($this->PrintedName);
        } else {
            $this->PrintedName = $printedName;
        }
        return $this;
    }
    /**
     * Get ScannerIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ScannerIds|null
     */
    public function getScannerIds()
    {
        return isset($this->ScannerIds) ? $this->ScannerIds : null;
    }
    /**
     * Set ScannerIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ScannerIds $scannerIds
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setScannerIds(\patest\StructType\ScannerIds $scannerIds = null)
    {
        if (is_null($scannerIds) || (is_array($scannerIds) && empty($scannerIds))) {
            unset($this->ScannerIds);
        } else {
            $this->ScannerIds = $scannerIds;
        }
        return $this;
    }
    /**
     * Get SeatingPlanDisplaysHallMapFirst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSeatingPlanDisplaysHallMapFirst()
    {
        return isset($this->SeatingPlanDisplaysHallMapFirst) ? $this->SeatingPlanDisplaysHallMapFirst : null;
    }
    /**
     * Set SeatingPlanDisplaysHallMapFirst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $seatingPlanDisplaysHallMapFirst
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setSeatingPlanDisplaysHallMapFirst($seatingPlanDisplaysHallMapFirst = null)
    {
        // validation for constraint: boolean
        if (!is_null($seatingPlanDisplaysHallMapFirst) && !is_bool($seatingPlanDisplaysHallMapFirst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($seatingPlanDisplaysHallMapFirst, true), gettype($seatingPlanDisplaysHallMapFirst)), __LINE__);
        }
        if (is_null($seatingPlanDisplaysHallMapFirst) || (is_array($seatingPlanDisplaysHallMapFirst) && empty($seatingPlanDisplaysHallMapFirst))) {
            unset($this->SeatingPlanDisplaysHallMapFirst);
        } else {
            $this->SeatingPlanDisplaysHallMapFirst = $seatingPlanDisplaysHallMapFirst;
        }
        return $this;
    }
    /**
     * Get StageImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStageImageId()
    {
        return isset($this->StageImageId) ? $this->StageImageId : null;
    }
    /**
     * Set StageImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stageImageId
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setStageImageId($stageImageId = null)
    {
        // validation for constraint: int
        if (!is_null($stageImageId) && !(is_int($stageImageId) || ctype_digit($stageImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stageImageId, true), gettype($stageImageId)), __LINE__);
        }
        if (is_null($stageImageId) || (is_array($stageImageId) && empty($stageImageId))) {
            unset($this->StageImageId);
        } else {
            $this->StageImageId = $stageImageId;
        }
        return $this;
    }
    /**
     * Get Stands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Stand|null
     */
    public function getStands()
    {
        return isset($this->Stands) ? $this->Stands : null;
    }
    /**
     * Set Stands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Stand $stands
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setStands(\patest\StructType\RecordSetOfTicketing_Stand $stands = null)
    {
        if (is_null($stands) || (is_array($stands) && empty($stands))) {
            unset($this->Stands);
        } else {
            $this->Stands = $stands;
        }
        return $this;
    }
    /**
     * Get Turnstiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Turnstile|null
     */
    public function getTurnstiles()
    {
        return isset($this->Turnstiles) ? $this->Turnstiles : null;
    }
    /**
     * Set Turnstiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Turnstile $turnstiles
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setTurnstiles(\patest\StructType\RecordSetOfTicketing_Turnstile $turnstiles = null)
    {
        if (is_null($turnstiles) || (is_array($turnstiles) && empty($turnstiles))) {
            unset($this->Turnstiles);
        } else {
            $this->Turnstiles = $turnstiles;
        }
        return $this;
    }
    /**
     * Get VenueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueId()
    {
        return isset($this->VenueId) ? $this->VenueId : null;
    }
    /**
     * Set VenueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueId
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setVenueId($venueId = null)
    {
        // validation for constraint: string
        if (!is_null($venueId) && !is_string($venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueId, true), gettype($venueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($venueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($venueId, true)), __LINE__);
        }
        if (is_null($venueId) || (is_array($venueId) && empty($venueId))) {
            unset($this->VenueId);
        } else {
            $this->VenueId = $venueId;
        }
        return $this;
    }
    /**
     * Get Versions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_HallVersion|null
     */
    public function getVersions()
    {
        return isset($this->Versions) ? $this->Versions : null;
    }
    /**
     * Set Versions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_HallVersion $versions
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setVersions(\patest\StructType\RecordSetOfTicketing_HallVersion $versions = null)
    {
        if (is_null($versions) || (is_array($versions) && empty($versions))) {
            unset($this->Versions);
        } else {
            $this->Versions = $versions;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_Hall
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
