<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventWorthInSeries StructType
 * @subpackage Structs
 */
class Ticketing_EventWorthInSeries extends PersistableEntity
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The WorthType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorthType;
    /**
     * The WorthValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WorthValue;
    /**
     * Constructor method for Ticketing.EventWorthInSeries
     * @uses Ticketing_EventWorthInSeries::setEventId()
     * @uses Ticketing_EventWorthInSeries::setSeriesId()
     * @uses Ticketing_EventWorthInSeries::setWorthType()
     * @uses Ticketing_EventWorthInSeries::setWorthValue()
     * @param string $eventId
     * @param string $seriesId
     * @param string $worthType
     * @param int $worthValue
     */
    public function __construct($eventId = null, $seriesId = null, $worthType = null, $worthValue = null)
    {
        $this
            ->setEventId($eventId)
            ->setSeriesId($seriesId)
            ->setWorthType($worthType)
            ->setWorthValue($worthValue);
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_EventWorthInSeries
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_EventWorthInSeries
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get WorthType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorthType()
    {
        return isset($this->WorthType) ? $this->WorthType : null;
    }
    /**
     * Set WorthType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketWorthType::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketWorthType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $worthType
     * @return \patest\StructType\Ticketing_EventWorthInSeries
     */
    public function setWorthType($worthType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketWorthType::valueIsValid($worthType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketWorthType', is_array($worthType) ? implode(', ', $worthType) : var_export($worthType, true), implode(', ', \patest\EnumType\SubscriberTicketWorthType::getValidValues())), __LINE__);
        }
        if (is_null($worthType) || (is_array($worthType) && empty($worthType))) {
            unset($this->WorthType);
        } else {
            $this->WorthType = $worthType;
        }
        return $this;
    }
    /**
     * Get WorthValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWorthValue()
    {
        return isset($this->WorthValue) ? $this->WorthValue : null;
    }
    /**
     * Set WorthValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $worthValue
     * @return \patest\StructType\Ticketing_EventWorthInSeries
     */
    public function setWorthValue($worthValue = null)
    {
        // validation for constraint: int
        if (!is_null($worthValue) && !(is_int($worthValue) || ctype_digit($worthValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($worthValue, true), gettype($worthValue)), __LINE__);
        }
        if (is_null($worthValue) || (is_array($worthValue) && empty($worthValue))) {
            unset($this->WorthValue);
        } else {
            $this->WorthValue = $worthValue;
        }
        return $this;
    }
}
