<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventDetailsForSwitchSeriesToPricePerEvent
 * StructType
 * @subpackage Structs
 */
class Ticketing_EventDetailsForSwitchSeriesToPricePerEvent extends PersistableEntity
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventTime
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventTime;
    /**
     * The IsAlreadyLinkedToSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAlreadyLinkedToSeries;
    /**
     * The SeriesDetailsId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesDetailsId;
    /**
     * The SeriesLinkageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesLinkageType;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShowName;
    /**
     * Constructor method for Ticketing.EventDetailsForSwitchSeriesToPricePerEvent
     * @uses Ticketing_EventDetailsForSwitchSeriesToPricePerEvent::setEventDate()
     * @uses Ticketing_EventDetailsForSwitchSeriesToPricePerEvent::setEventId()
     * @uses Ticketing_EventDetailsForSwitchSeriesToPricePerEvent::setEventTime()
     * @uses Ticketing_EventDetailsForSwitchSeriesToPricePerEvent::setIsAlreadyLinkedToSeries()
     * @uses Ticketing_EventDetailsForSwitchSeriesToPricePerEvent::setSeriesDetailsId()
     * @uses Ticketing_EventDetailsForSwitchSeriesToPricePerEvent::setSeriesLinkageType()
     * @uses Ticketing_EventDetailsForSwitchSeriesToPricePerEvent::setShowName()
     * @param string $eventDate
     * @param string $eventId
     * @param string $eventTime
     * @param bool $isAlreadyLinkedToSeries
     * @param string $seriesDetailsId
     * @param string $seriesLinkageType
     * @param \patest\StructType\GlobalString $showName
     */
    public function __construct($eventDate = null, $eventId = null, $eventTime = null, $isAlreadyLinkedToSeries = null, $seriesDetailsId = null, $seriesLinkageType = null, \patest\StructType\GlobalString $showName = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setEventTime($eventTime)
            ->setIsAlreadyLinkedToSeries($isAlreadyLinkedToSeries)
            ->setSeriesDetailsId($seriesDetailsId)
            ->setSeriesLinkageType($seriesLinkageType)
            ->setShowName($showName);
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTime()
    {
        return isset($this->EventTime) ? $this->EventTime : null;
    }
    /**
     * Set EventTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTime
     * @return \patest\StructType\Ticketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public function setEventTime($eventTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventTime) && !is_string($eventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTime, true), gettype($eventTime)), __LINE__);
        }
        if (is_null($eventTime) || (is_array($eventTime) && empty($eventTime))) {
            unset($this->EventTime);
        } else {
            $this->EventTime = $eventTime;
        }
        return $this;
    }
    /**
     * Get IsAlreadyLinkedToSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAlreadyLinkedToSeries()
    {
        return isset($this->IsAlreadyLinkedToSeries) ? $this->IsAlreadyLinkedToSeries : null;
    }
    /**
     * Set IsAlreadyLinkedToSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAlreadyLinkedToSeries
     * @return \patest\StructType\Ticketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public function setIsAlreadyLinkedToSeries($isAlreadyLinkedToSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlreadyLinkedToSeries) && !is_bool($isAlreadyLinkedToSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlreadyLinkedToSeries, true), gettype($isAlreadyLinkedToSeries)), __LINE__);
        }
        if (is_null($isAlreadyLinkedToSeries) || (is_array($isAlreadyLinkedToSeries) && empty($isAlreadyLinkedToSeries))) {
            unset($this->IsAlreadyLinkedToSeries);
        } else {
            $this->IsAlreadyLinkedToSeries = $isAlreadyLinkedToSeries;
        }
        return $this;
    }
    /**
     * Get SeriesDetailsId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesDetailsId()
    {
        return isset($this->SeriesDetailsId) ? $this->SeriesDetailsId : null;
    }
    /**
     * Set SeriesDetailsId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesDetailsId
     * @return \patest\StructType\Ticketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public function setSeriesDetailsId($seriesDetailsId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesDetailsId) && !is_string($seriesDetailsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesDetailsId, true), gettype($seriesDetailsId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesDetailsId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesDetailsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesDetailsId, true)), __LINE__);
        }
        if (is_null($seriesDetailsId) || (is_array($seriesDetailsId) && empty($seriesDetailsId))) {
            unset($this->SeriesDetailsId);
        } else {
            $this->SeriesDetailsId = $seriesDetailsId;
        }
        return $this;
    }
    /**
     * Get SeriesLinkageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesLinkageType()
    {
        return isset($this->SeriesLinkageType) ? $this->SeriesLinkageType : null;
    }
    /**
     * Set SeriesLinkageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSeriesLinkageDisplayType::valueIsValid()
     * @uses \patest\EnumType\EventSeriesLinkageDisplayType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seriesLinkageType
     * @return \patest\StructType\Ticketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public function setSeriesLinkageType($seriesLinkageType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventSeriesLinkageDisplayType::valueIsValid($seriesLinkageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSeriesLinkageDisplayType', is_array($seriesLinkageType) ? implode(', ', $seriesLinkageType) : var_export($seriesLinkageType, true), implode(', ', \patest\EnumType\EventSeriesLinkageDisplayType::getValidValues())), __LINE__);
        }
        if (is_null($seriesLinkageType) || (is_array($seriesLinkageType) && empty($seriesLinkageType))) {
            unset($this->SeriesLinkageType);
        } else {
            $this->SeriesLinkageType = $seriesLinkageType;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $showName
     * @return \patest\StructType\Ticketing_EventDetailsForSwitchSeriesToPricePerEvent
     */
    public function setShowName(\patest\StructType\GlobalString $showName = null)
    {
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
}
