<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ClientTicketSummaryRow StructType
 * @subpackage Structs
 */
class Ticketing_ClientTicketSummaryRow extends AnyEntity
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserved;
    /**
     * The IsSubscription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscription;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleStatus;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowName;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketType;
    /**
     * Constructor method for Ticketing.ClientTicketSummaryRow
     * @uses Ticketing_ClientTicketSummaryRow::setEventDate()
     * @uses Ticketing_ClientTicketSummaryRow::setEventGuid()
     * @uses Ticketing_ClientTicketSummaryRow::setIsReserved()
     * @uses Ticketing_ClientTicketSummaryRow::setIsSubscription()
     * @uses Ticketing_ClientTicketSummaryRow::setQuantity()
     * @uses Ticketing_ClientTicketSummaryRow::setSaleStatus()
     * @uses Ticketing_ClientTicketSummaryRow::setShowName()
     * @uses Ticketing_ClientTicketSummaryRow::setTicketType()
     * @param string $eventDate
     * @param string $eventGuid
     * @param bool $isReserved
     * @param bool $isSubscription
     * @param int $quantity
     * @param string $saleStatus
     * @param string $showName
     * @param string $ticketType
     */
    public function __construct($eventDate = null, $eventGuid = null, $isReserved = null, $isSubscription = null, $quantity = null, $saleStatus = null, $showName = null, $ticketType = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setEventGuid($eventGuid)
            ->setIsReserved($isReserved)
            ->setIsSubscription($isSubscription)
            ->setQuantity($quantity)
            ->setSaleStatus($saleStatus)
            ->setShowName($showName)
            ->setTicketType($ticketType);
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserved
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserved) && !is_bool($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get IsSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscription()
    {
        return isset($this->IsSubscription) ? $this->IsSubscription : null;
    }
    /**
     * Set IsSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscription
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setIsSubscription($isSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscription) && !is_bool($isSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscription, true), gettype($isSubscription)), __LINE__);
        }
        if (is_null($isSubscription) || (is_array($isSubscription) && empty($isSubscription))) {
            unset($this->IsSubscription);
        } else {
            $this->IsSubscription = $isSubscription;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSaleStatus::valueIsValid()
     * @uses \patest\EnumType\TicketSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleStatus
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSaleStatus::valueIsValid($saleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSaleStatus', is_array($saleStatus) ? implode(', ', $saleStatus) : var_export($saleStatus, true), implode(', ', \patest\EnumType\TicketSaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = $saleStatus;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showName
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setShowName($showName = null)
    {
        // validation for constraint: string
        if (!is_null($showName) && !is_string($showName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showName, true), gettype($showName)), __LINE__);
        }
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get TicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketType()
    {
        return isset($this->TicketType) ? $this->TicketType : null;
    }
    /**
     * Set TicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSummaryType::valueIsValid()
     * @uses \patest\EnumType\TicketSummaryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \patest\StructType\Ticketing_ClientTicketSummaryRow
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSummaryType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSummaryType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \patest\EnumType\TicketSummaryType::getValidValues())), __LINE__);
        }
        if (is_null($ticketType) || (is_array($ticketType) && empty($ticketType))) {
            unset($this->TicketType);
        } else {
            $this->TicketType = $ticketType;
        }
        return $this;
    }
}
