<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ClientSubscriptionFilter StructType
 * @subpackage Structs
 */
class Ticketing_ClientSubscriptionFilter extends Ticketing_SaleStatusFilterEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The ClientSubscriptionSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientSubscriptionSaleStatus;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The OBOAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OBOAccountId;
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelTypeId
     */
    public $PriceLevelTypeId;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The RowsGreaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowsGreaterThan;
    /**
     * The RowsLessThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowsLessThan;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeatAllocationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatAllocationId
     */
    public $SeatAllocationId;
    /**
     * The SeatLockId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatLockId
     */
    public $SeatLockId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatTypeId
     */
    public $SeatTypeId;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SectorsGreaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SectorsGreaterThan;
    /**
     * The SectorsLessThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SectorsLessThan;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\StandId
     */
    public $StandId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * Constructor method for Ticketing.ClientSubscriptionFilter
     * @uses Ticketing_ClientSubscriptionFilter::setAreaId()
     * @uses Ticketing_ClientSubscriptionFilter::setAreaIds()
     * @uses Ticketing_ClientSubscriptionFilter::setBarcode()
     * @uses Ticketing_ClientSubscriptionFilter::setClientSubscriptionSaleStatus()
     * @uses Ticketing_ClientSubscriptionFilter::setHallId()
     * @uses Ticketing_ClientSubscriptionFilter::setOBOAccountId()
     * @uses Ticketing_ClientSubscriptionFilter::setPackageId()
     * @uses Ticketing_ClientSubscriptionFilter::setPriceLevelId()
     * @uses Ticketing_ClientSubscriptionFilter::setPriceLevelTypeId()
     * @uses Ticketing_ClientSubscriptionFilter::setPriceTypeIds()
     * @uses Ticketing_ClientSubscriptionFilter::setRowName()
     * @uses Ticketing_ClientSubscriptionFilter::setRowsGreaterThan()
     * @uses Ticketing_ClientSubscriptionFilter::setRowsLessThan()
     * @uses Ticketing_ClientSubscriptionFilter::setSeasonId()
     * @uses Ticketing_ClientSubscriptionFilter::setSeatAllocationId()
     * @uses Ticketing_ClientSubscriptionFilter::setSeatLockId()
     * @uses Ticketing_ClientSubscriptionFilter::setSeatName()
     * @uses Ticketing_ClientSubscriptionFilter::setSeatTypeId()
     * @uses Ticketing_ClientSubscriptionFilter::setSectorId()
     * @uses Ticketing_ClientSubscriptionFilter::setSectorsGreaterThan()
     * @uses Ticketing_ClientSubscriptionFilter::setSectorsLessThan()
     * @uses Ticketing_ClientSubscriptionFilter::setSeriesId()
     * @uses Ticketing_ClientSubscriptionFilter::setStandId()
     * @uses Ticketing_ClientSubscriptionFilter::setSubscriptionNumber()
     * @param string $areaId
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $barcode
     * @param string $clientSubscriptionSaleStatus
     * @param string $hallId
     * @param string $oBOAccountId
     * @param string $packageId
     * @param string $priceLevelId
     * @param \patest\StructType\PriceLevelTypeId $priceLevelTypeId
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @param string $rowName
     * @param int $rowsGreaterThan
     * @param int $rowsLessThan
     * @param string $seasonId
     * @param \patest\StructType\SeatAllocationId $seatAllocationId
     * @param \patest\StructType\SeatLockId $seatLockId
     * @param string $seatName
     * @param \patest\StructType\SeatTypeId $seatTypeId
     * @param string $sectorId
     * @param int $sectorsGreaterThan
     * @param int $sectorsLessThan
     * @param string $seriesId
     * @param \patest\StructType\StandId $standId
     * @param string $subscriptionNumber
     */
    public function __construct($areaId = null, \patest\StructType\AreaIds $areaIds = null, $barcode = null, $clientSubscriptionSaleStatus = null, $hallId = null, $oBOAccountId = null, $packageId = null, $priceLevelId = null, \patest\StructType\PriceLevelTypeId $priceLevelTypeId = null, \patest\StructType\PriceTypeIds $priceTypeIds = null, $rowName = null, $rowsGreaterThan = null, $rowsLessThan = null, $seasonId = null, \patest\StructType\SeatAllocationId $seatAllocationId = null, \patest\StructType\SeatLockId $seatLockId = null, $seatName = null, \patest\StructType\SeatTypeId $seatTypeId = null, $sectorId = null, $sectorsGreaterThan = null, $sectorsLessThan = null, $seriesId = null, \patest\StructType\StandId $standId = null, $subscriptionNumber = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaIds($areaIds)
            ->setBarcode($barcode)
            ->setClientSubscriptionSaleStatus($clientSubscriptionSaleStatus)
            ->setHallId($hallId)
            ->setOBOAccountId($oBOAccountId)
            ->setPackageId($packageId)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelTypeId($priceLevelTypeId)
            ->setPriceTypeIds($priceTypeIds)
            ->setRowName($rowName)
            ->setRowsGreaterThan($rowsGreaterThan)
            ->setRowsLessThan($rowsLessThan)
            ->setSeasonId($seasonId)
            ->setSeatAllocationId($seatAllocationId)
            ->setSeatLockId($seatLockId)
            ->setSeatName($seatName)
            ->setSeatTypeId($seatTypeId)
            ->setSectorId($sectorId)
            ->setSectorsGreaterThan($sectorsGreaterThan)
            ->setSectorsLessThan($sectorsLessThan)
            ->setSeriesId($seriesId)
            ->setStandId($standId)
            ->setSubscriptionNumber($subscriptionNumber);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get ClientSubscriptionSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientSubscriptionSaleStatus()
    {
        return isset($this->ClientSubscriptionSaleStatus) ? $this->ClientSubscriptionSaleStatus : null;
    }
    /**
     * Set ClientSubscriptionSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientSubscriptionSaleStatus
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setClientSubscriptionSaleStatus($clientSubscriptionSaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionStatus::valueIsValid($clientSubscriptionSaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionStatus', is_array($clientSubscriptionSaleStatus) ? implode(', ', $clientSubscriptionSaleStatus) : var_export($clientSubscriptionSaleStatus, true), implode(', ', \patest\EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        if (is_null($clientSubscriptionSaleStatus) || (is_array($clientSubscriptionSaleStatus) && empty($clientSubscriptionSaleStatus))) {
            unset($this->ClientSubscriptionSaleStatus);
        } else {
            $this->ClientSubscriptionSaleStatus = $clientSubscriptionSaleStatus;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get OBOAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOBOAccountId()
    {
        return isset($this->OBOAccountId) ? $this->OBOAccountId : null;
    }
    /**
     * Set OBOAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oBOAccountId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setOBOAccountId($oBOAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($oBOAccountId) && !is_string($oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oBOAccountId, true), gettype($oBOAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oBOAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oBOAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oBOAccountId, true)), __LINE__);
        }
        if (is_null($oBOAccountId) || (is_array($oBOAccountId) && empty($oBOAccountId))) {
            unset($this->OBOAccountId);
        } else {
            $this->OBOAccountId = $oBOAccountId;
        }
        return $this;
    }
    /**
     * Get PackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageId()
    {
        return isset($this->PackageId) ? $this->PackageId : null;
    }
    /**
     * Set PackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageId, true)), __LINE__);
        }
        if (is_null($packageId) || (is_array($packageId) && empty($packageId))) {
            unset($this->PackageId);
        } else {
            $this->PackageId = $packageId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelTypeId|null
     */
    public function getPriceLevelTypeId()
    {
        return isset($this->PriceLevelTypeId) ? $this->PriceLevelTypeId : null;
    }
    /**
     * Set PriceLevelTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelTypeId $priceLevelTypeId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setPriceLevelTypeId(\patest\StructType\PriceLevelTypeId $priceLevelTypeId = null)
    {
        if (is_null($priceLevelTypeId) || (is_array($priceLevelTypeId) && empty($priceLevelTypeId))) {
            unset($this->PriceLevelTypeId);
        } else {
            $this->PriceLevelTypeId = $priceLevelTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get RowsGreaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowsGreaterThan()
    {
        return isset($this->RowsGreaterThan) ? $this->RowsGreaterThan : null;
    }
    /**
     * Set RowsGreaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowsGreaterThan
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setRowsGreaterThan($rowsGreaterThan = null)
    {
        // validation for constraint: int
        if (!is_null($rowsGreaterThan) && !(is_int($rowsGreaterThan) || ctype_digit($rowsGreaterThan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowsGreaterThan, true), gettype($rowsGreaterThan)), __LINE__);
        }
        if (is_null($rowsGreaterThan) || (is_array($rowsGreaterThan) && empty($rowsGreaterThan))) {
            unset($this->RowsGreaterThan);
        } else {
            $this->RowsGreaterThan = $rowsGreaterThan;
        }
        return $this;
    }
    /**
     * Get RowsLessThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowsLessThan()
    {
        return isset($this->RowsLessThan) ? $this->RowsLessThan : null;
    }
    /**
     * Set RowsLessThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowsLessThan
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setRowsLessThan($rowsLessThan = null)
    {
        // validation for constraint: int
        if (!is_null($rowsLessThan) && !(is_int($rowsLessThan) || ctype_digit($rowsLessThan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowsLessThan, true), gettype($rowsLessThan)), __LINE__);
        }
        if (is_null($rowsLessThan) || (is_array($rowsLessThan) && empty($rowsLessThan))) {
            unset($this->RowsLessThan);
        } else {
            $this->RowsLessThan = $rowsLessThan;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeatAllocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatAllocationId|null
     */
    public function getSeatAllocationId()
    {
        return isset($this->SeatAllocationId) ? $this->SeatAllocationId : null;
    }
    /**
     * Set SeatAllocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatAllocationId $seatAllocationId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSeatAllocationId(\patest\StructType\SeatAllocationId $seatAllocationId = null)
    {
        if (is_null($seatAllocationId) || (is_array($seatAllocationId) && empty($seatAllocationId))) {
            unset($this->SeatAllocationId);
        } else {
            $this->SeatAllocationId = $seatAllocationId;
        }
        return $this;
    }
    /**
     * Get SeatLockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatLockId|null
     */
    public function getSeatLockId()
    {
        return isset($this->SeatLockId) ? $this->SeatLockId : null;
    }
    /**
     * Set SeatLockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatLockId $seatLockId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSeatLockId(\patest\StructType\SeatLockId $seatLockId = null)
    {
        if (is_null($seatLockId) || (is_array($seatLockId) && empty($seatLockId))) {
            unset($this->SeatLockId);
        } else {
            $this->SeatLockId = $seatLockId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatTypeId|null
     */
    public function getSeatTypeId()
    {
        return isset($this->SeatTypeId) ? $this->SeatTypeId : null;
    }
    /**
     * Set SeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatTypeId $seatTypeId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSeatTypeId(\patest\StructType\SeatTypeId $seatTypeId = null)
    {
        if (is_null($seatTypeId) || (is_array($seatTypeId) && empty($seatTypeId))) {
            unset($this->SeatTypeId);
        } else {
            $this->SeatTypeId = $seatTypeId;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SectorsGreaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSectorsGreaterThan()
    {
        return isset($this->SectorsGreaterThan) ? $this->SectorsGreaterThan : null;
    }
    /**
     * Set SectorsGreaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sectorsGreaterThan
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSectorsGreaterThan($sectorsGreaterThan = null)
    {
        // validation for constraint: int
        if (!is_null($sectorsGreaterThan) && !(is_int($sectorsGreaterThan) || ctype_digit($sectorsGreaterThan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sectorsGreaterThan, true), gettype($sectorsGreaterThan)), __LINE__);
        }
        if (is_null($sectorsGreaterThan) || (is_array($sectorsGreaterThan) && empty($sectorsGreaterThan))) {
            unset($this->SectorsGreaterThan);
        } else {
            $this->SectorsGreaterThan = $sectorsGreaterThan;
        }
        return $this;
    }
    /**
     * Get SectorsLessThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSectorsLessThan()
    {
        return isset($this->SectorsLessThan) ? $this->SectorsLessThan : null;
    }
    /**
     * Set SectorsLessThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sectorsLessThan
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSectorsLessThan($sectorsLessThan = null)
    {
        // validation for constraint: int
        if (!is_null($sectorsLessThan) && !(is_int($sectorsLessThan) || ctype_digit($sectorsLessThan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sectorsLessThan, true), gettype($sectorsLessThan)), __LINE__);
        }
        if (is_null($sectorsLessThan) || (is_array($sectorsLessThan) && empty($sectorsLessThan))) {
            unset($this->SectorsLessThan);
        } else {
            $this->SectorsLessThan = $sectorsLessThan;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\StandId|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\StandId $standId
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setStandId(\patest\StructType\StandId $standId = null)
    {
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_ClientSubscriptionFilter
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
}
