<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotingResultRow StructType
 * @subpackage Structs
 */
class Ticketing_BallotingResultRow extends PersistableEntity
{
    /**
     * The AllocatedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedSeats;
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationId;
    /**
     * The ApplicationLine
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_BallotApplicationLine
     */
    public $ApplicationLine;
    /**
     * The BallotingResultId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotingResultId;
    /**
     * The CandidateSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CandidateSeatCount;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The IsCandidate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCandidate;
    /**
     * The IsConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConfirmed;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The PreviousWinCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PreviousWinCount;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionItemIds;
    /**
     * The WonSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WonSeatCount;
    /**
     * Constructor method for Ticketing.BallotingResultRow
     * @uses Ticketing_BallotingResultRow::setAllocatedSeats()
     * @uses Ticketing_BallotingResultRow::setApplicationId()
     * @uses Ticketing_BallotingResultRow::setApplicationLine()
     * @uses Ticketing_BallotingResultRow::setBallotingResultId()
     * @uses Ticketing_BallotingResultRow::setCandidateSeatCount()
     * @uses Ticketing_BallotingResultRow::setClientId()
     * @uses Ticketing_BallotingResultRow::setIsCandidate()
     * @uses Ticketing_BallotingResultRow::setIsConfirmed()
     * @uses Ticketing_BallotingResultRow::setNote()
     * @uses Ticketing_BallotingResultRow::setPreviousWinCount()
     * @uses Ticketing_BallotingResultRow::setTransactionId()
     * @uses Ticketing_BallotingResultRow::setTransactionItemIds()
     * @uses Ticketing_BallotingResultRow::setWonSeatCount()
     * @param int $allocatedSeats
     * @param string $applicationId
     * @param \patest\StructType\Ticketing_BallotApplicationLine $applicationLine
     * @param string $ballotingResultId
     * @param int $candidateSeatCount
     * @param string $clientId
     * @param bool $isCandidate
     * @param bool $isConfirmed
     * @param string $note
     * @param int $previousWinCount
     * @param string $transactionId
     * @param string $transactionItemIds
     * @param int $wonSeatCount
     */
    public function __construct($allocatedSeats = null, $applicationId = null, \patest\StructType\Ticketing_BallotApplicationLine $applicationLine = null, $ballotingResultId = null, $candidateSeatCount = null, $clientId = null, $isCandidate = null, $isConfirmed = null, $note = null, $previousWinCount = null, $transactionId = null, $transactionItemIds = null, $wonSeatCount = null)
    {
        $this
            ->setAllocatedSeats($allocatedSeats)
            ->setApplicationId($applicationId)
            ->setApplicationLine($applicationLine)
            ->setBallotingResultId($ballotingResultId)
            ->setCandidateSeatCount($candidateSeatCount)
            ->setClientId($clientId)
            ->setIsCandidate($isCandidate)
            ->setIsConfirmed($isConfirmed)
            ->setNote($note)
            ->setPreviousWinCount($previousWinCount)
            ->setTransactionId($transactionId)
            ->setTransactionItemIds($transactionItemIds)
            ->setWonSeatCount($wonSeatCount);
    }
    /**
     * Get AllocatedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedSeats()
    {
        return isset($this->AllocatedSeats) ? $this->AllocatedSeats : null;
    }
    /**
     * Set AllocatedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedSeats
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setAllocatedSeats($allocatedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedSeats) && !(is_int($allocatedSeats) || ctype_digit($allocatedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedSeats, true), gettype($allocatedSeats)), __LINE__);
        }
        if (is_null($allocatedSeats) || (is_array($allocatedSeats) && empty($allocatedSeats))) {
            unset($this->AllocatedSeats);
        } else {
            $this->AllocatedSeats = $allocatedSeats;
        }
        return $this;
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationId
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationId, true)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get ApplicationLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_BallotApplicationLine|null
     */
    public function getApplicationLine()
    {
        return isset($this->ApplicationLine) ? $this->ApplicationLine : null;
    }
    /**
     * Set ApplicationLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_BallotApplicationLine $applicationLine
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setApplicationLine(\patest\StructType\Ticketing_BallotApplicationLine $applicationLine = null)
    {
        if (is_null($applicationLine) || (is_array($applicationLine) && empty($applicationLine))) {
            unset($this->ApplicationLine);
        } else {
            $this->ApplicationLine = $applicationLine;
        }
        return $this;
    }
    /**
     * Get BallotingResultId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotingResultId()
    {
        return isset($this->BallotingResultId) ? $this->BallotingResultId : null;
    }
    /**
     * Set BallotingResultId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotingResultId
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setBallotingResultId($ballotingResultId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotingResultId) && !is_string($ballotingResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotingResultId, true), gettype($ballotingResultId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotingResultId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotingResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotingResultId, true)), __LINE__);
        }
        if (is_null($ballotingResultId) || (is_array($ballotingResultId) && empty($ballotingResultId))) {
            unset($this->BallotingResultId);
        } else {
            $this->BallotingResultId = $ballotingResultId;
        }
        return $this;
    }
    /**
     * Get CandidateSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCandidateSeatCount()
    {
        return isset($this->CandidateSeatCount) ? $this->CandidateSeatCount : null;
    }
    /**
     * Set CandidateSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $candidateSeatCount
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setCandidateSeatCount($candidateSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($candidateSeatCount) && !(is_int($candidateSeatCount) || ctype_digit($candidateSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($candidateSeatCount, true), gettype($candidateSeatCount)), __LINE__);
        }
        if (is_null($candidateSeatCount) || (is_array($candidateSeatCount) && empty($candidateSeatCount))) {
            unset($this->CandidateSeatCount);
        } else {
            $this->CandidateSeatCount = $candidateSeatCount;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get IsCandidate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCandidate()
    {
        return isset($this->IsCandidate) ? $this->IsCandidate : null;
    }
    /**
     * Set IsCandidate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCandidate
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setIsCandidate($isCandidate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCandidate) && !is_bool($isCandidate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCandidate, true), gettype($isCandidate)), __LINE__);
        }
        if (is_null($isCandidate) || (is_array($isCandidate) && empty($isCandidate))) {
            unset($this->IsCandidate);
        } else {
            $this->IsCandidate = $isCandidate;
        }
        return $this;
    }
    /**
     * Get IsConfirmed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConfirmed()
    {
        return isset($this->IsConfirmed) ? $this->IsConfirmed : null;
    }
    /**
     * Set IsConfirmed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConfirmed
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setIsConfirmed($isConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmed) && !is_bool($isConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmed, true), gettype($isConfirmed)), __LINE__);
        }
        if (is_null($isConfirmed) || (is_array($isConfirmed) && empty($isConfirmed))) {
            unset($this->IsConfirmed);
        } else {
            $this->IsConfirmed = $isConfirmed;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get PreviousWinCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPreviousWinCount()
    {
        return isset($this->PreviousWinCount) ? $this->PreviousWinCount : null;
    }
    /**
     * Set PreviousWinCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $previousWinCount
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setPreviousWinCount($previousWinCount = null)
    {
        // validation for constraint: int
        if (!is_null($previousWinCount) && !(is_int($previousWinCount) || ctype_digit($previousWinCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($previousWinCount, true), gettype($previousWinCount)), __LINE__);
        }
        if (is_null($previousWinCount) || (is_array($previousWinCount) && empty($previousWinCount))) {
            unset($this->PreviousWinCount);
        } else {
            $this->PreviousWinCount = $previousWinCount;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionItemIds()
    {
        return isset($this->TransactionItemIds) ? $this->TransactionItemIds : null;
    }
    /**
     * Set TransactionItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionItemIds
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setTransactionItemIds($transactionItemIds = null)
    {
        // validation for constraint: string
        if (!is_null($transactionItemIds) && !is_string($transactionItemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionItemIds, true), gettype($transactionItemIds)), __LINE__);
        }
        if (is_null($transactionItemIds) || (is_array($transactionItemIds) && empty($transactionItemIds))) {
            unset($this->TransactionItemIds);
        } else {
            $this->TransactionItemIds = $transactionItemIds;
        }
        return $this;
    }
    /**
     * Get WonSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWonSeatCount()
    {
        return isset($this->WonSeatCount) ? $this->WonSeatCount : null;
    }
    /**
     * Set WonSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $wonSeatCount
     * @return \patest\StructType\Ticketing_BallotingResultRow
     */
    public function setWonSeatCount($wonSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($wonSeatCount) && !(is_int($wonSeatCount) || ctype_digit($wonSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wonSeatCount, true), gettype($wonSeatCount)), __LINE__);
        }
        if (is_null($wonSeatCount) || (is_array($wonSeatCount) && empty($wonSeatCount))) {
            unset($this->WonSeatCount);
        } else {
            $this->WonSeatCount = $wonSeatCount;
        }
        return $this;
    }
}
