<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotingResult StructType
 * @subpackage Structs
 */
class Ticketing_BallotingResult extends PersistableEntity
{
    /**
     * The AvailableSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableSeats;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The BallotMinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BallotMinSeats;
    /**
     * The BallotRunMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotRunMode;
    /**
     * The ClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientTypeId;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The MaxWinsPerBallot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxWinsPerBallot;
    /**
     * The MinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeats;
    /**
     * The Results
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotingResultRow
     */
    public $Results;
    /**
     * The ScaleBackMaxTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScaleBackMaxTickets;
    /**
     * The SectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectionId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TemporaryTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TemporaryTransactionId;
    /**
     * Constructor method for Ticketing.BallotingResult
     * @uses Ticketing_BallotingResult::setAvailableSeats()
     * @uses Ticketing_BallotingResult::setBallotId()
     * @uses Ticketing_BallotingResult::setBallotMinSeats()
     * @uses Ticketing_BallotingResult::setBallotRunMode()
     * @uses Ticketing_BallotingResult::setClientTypeId()
     * @uses Ticketing_BallotingResult::setCreationAuditId()
     * @uses Ticketing_BallotingResult::setCreationDateTime()
     * @uses Ticketing_BallotingResult::setMaxSeats()
     * @uses Ticketing_BallotingResult::setMaxWinsPerBallot()
     * @uses Ticketing_BallotingResult::setMinSeats()
     * @uses Ticketing_BallotingResult::setResults()
     * @uses Ticketing_BallotingResult::setScaleBackMaxTickets()
     * @uses Ticketing_BallotingResult::setSectionId()
     * @uses Ticketing_BallotingResult::setStatus()
     * @uses Ticketing_BallotingResult::setTemporaryTransactionId()
     * @param int $availableSeats
     * @param string $ballotId
     * @param int $ballotMinSeats
     * @param string $ballotRunMode
     * @param string $clientTypeId
     * @param int $creationAuditId
     * @param string $creationDateTime
     * @param int $maxSeats
     * @param int $maxWinsPerBallot
     * @param int $minSeats
     * @param \patest\StructType\RecordSetOfTicketing_BallotingResultRow $results
     * @param int $scaleBackMaxTickets
     * @param string $sectionId
     * @param string $status
     * @param string $temporaryTransactionId
     */
    public function __construct($availableSeats = null, $ballotId = null, $ballotMinSeats = null, $ballotRunMode = null, $clientTypeId = null, $creationAuditId = null, $creationDateTime = null, $maxSeats = null, $maxWinsPerBallot = null, $minSeats = null, \patest\StructType\RecordSetOfTicketing_BallotingResultRow $results = null, $scaleBackMaxTickets = null, $sectionId = null, $status = null, $temporaryTransactionId = null)
    {
        $this
            ->setAvailableSeats($availableSeats)
            ->setBallotId($ballotId)
            ->setBallotMinSeats($ballotMinSeats)
            ->setBallotRunMode($ballotRunMode)
            ->setClientTypeId($clientTypeId)
            ->setCreationAuditId($creationAuditId)
            ->setCreationDateTime($creationDateTime)
            ->setMaxSeats($maxSeats)
            ->setMaxWinsPerBallot($maxWinsPerBallot)
            ->setMinSeats($minSeats)
            ->setResults($results)
            ->setScaleBackMaxTickets($scaleBackMaxTickets)
            ->setSectionId($sectionId)
            ->setStatus($status)
            ->setTemporaryTransactionId($temporaryTransactionId);
    }
    /**
     * Get AvailableSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return isset($this->AvailableSeats) ? $this->AvailableSeats : null;
    }
    /**
     * Set AvailableSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableSeats
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !(is_int($availableSeats) || ctype_digit($availableSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeats, true), gettype($availableSeats)), __LINE__);
        }
        if (is_null($availableSeats) || (is_array($availableSeats) && empty($availableSeats))) {
            unset($this->AvailableSeats);
        } else {
            $this->AvailableSeats = $availableSeats;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get BallotMinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBallotMinSeats()
    {
        return isset($this->BallotMinSeats) ? $this->BallotMinSeats : null;
    }
    /**
     * Set BallotMinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ballotMinSeats
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setBallotMinSeats($ballotMinSeats = null)
    {
        // validation for constraint: int
        if (!is_null($ballotMinSeats) && !(is_int($ballotMinSeats) || ctype_digit($ballotMinSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ballotMinSeats, true), gettype($ballotMinSeats)), __LINE__);
        }
        if (is_null($ballotMinSeats) || (is_array($ballotMinSeats) && empty($ballotMinSeats))) {
            unset($this->BallotMinSeats);
        } else {
            $this->BallotMinSeats = $ballotMinSeats;
        }
        return $this;
    }
    /**
     * Get BallotRunMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotRunMode()
    {
        return isset($this->BallotRunMode) ? $this->BallotRunMode : null;
    }
    /**
     * Set BallotRunMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotRunMode::valueIsValid()
     * @uses \patest\EnumType\BallotRunMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotRunMode
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setBallotRunMode($ballotRunMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotRunMode::valueIsValid($ballotRunMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotRunMode', is_array($ballotRunMode) ? implode(', ', $ballotRunMode) : var_export($ballotRunMode, true), implode(', ', \patest\EnumType\BallotRunMode::getValidValues())), __LINE__);
        }
        if (is_null($ballotRunMode) || (is_array($ballotRunMode) && empty($ballotRunMode))) {
            unset($this->BallotRunMode);
        } else {
            $this->BallotRunMode = $ballotRunMode;
        }
        return $this;
    }
    /**
     * Get ClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeId()
    {
        return isset($this->ClientTypeId) ? $this->ClientTypeId : null;
    }
    /**
     * Set ClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeId
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setClientTypeId($clientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeId) && !is_string($clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeId, true), gettype($clientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientTypeId, true)), __LINE__);
        }
        if (is_null($clientTypeId) || (is_array($clientTypeId) && empty($clientTypeId))) {
            unset($this->ClientTypeId);
        } else {
            $this->ClientTypeId = $clientTypeId;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get MaxWinsPerBallot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxWinsPerBallot()
    {
        return isset($this->MaxWinsPerBallot) ? $this->MaxWinsPerBallot : null;
    }
    /**
     * Set MaxWinsPerBallot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxWinsPerBallot
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setMaxWinsPerBallot($maxWinsPerBallot = null)
    {
        // validation for constraint: int
        if (!is_null($maxWinsPerBallot) && !(is_int($maxWinsPerBallot) || ctype_digit($maxWinsPerBallot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxWinsPerBallot, true), gettype($maxWinsPerBallot)), __LINE__);
        }
        if (is_null($maxWinsPerBallot) || (is_array($maxWinsPerBallot) && empty($maxWinsPerBallot))) {
            unset($this->MaxWinsPerBallot);
        } else {
            $this->MaxWinsPerBallot = $maxWinsPerBallot;
        }
        return $this;
    }
    /**
     * Get MinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeats()
    {
        return isset($this->MinSeats) ? $this->MinSeats : null;
    }
    /**
     * Set MinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeats
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setMinSeats($minSeats = null)
    {
        // validation for constraint: int
        if (!is_null($minSeats) && !(is_int($minSeats) || ctype_digit($minSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeats, true), gettype($minSeats)), __LINE__);
        }
        if (is_null($minSeats) || (is_array($minSeats) && empty($minSeats))) {
            unset($this->MinSeats);
        } else {
            $this->MinSeats = $minSeats;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotingResultRow|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotingResultRow $results
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setResults(\patest\StructType\RecordSetOfTicketing_BallotingResultRow $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get ScaleBackMaxTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScaleBackMaxTickets()
    {
        return isset($this->ScaleBackMaxTickets) ? $this->ScaleBackMaxTickets : null;
    }
    /**
     * Set ScaleBackMaxTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scaleBackMaxTickets
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setScaleBackMaxTickets($scaleBackMaxTickets = null)
    {
        // validation for constraint: int
        if (!is_null($scaleBackMaxTickets) && !(is_int($scaleBackMaxTickets) || ctype_digit($scaleBackMaxTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scaleBackMaxTickets, true), gettype($scaleBackMaxTickets)), __LINE__);
        }
        if (is_null($scaleBackMaxTickets) || (is_array($scaleBackMaxTickets) && empty($scaleBackMaxTickets))) {
            unset($this->ScaleBackMaxTickets);
        } else {
            $this->ScaleBackMaxTickets = $scaleBackMaxTickets;
        }
        return $this;
    }
    /**
     * Get SectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionId()
    {
        return isset($this->SectionId) ? $this->SectionId : null;
    }
    /**
     * Set SectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionId
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setSectionId($sectionId = null)
    {
        // validation for constraint: string
        if (!is_null($sectionId) && !is_string($sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionId, true), gettype($sectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectionId, true)), __LINE__);
        }
        if (is_null($sectionId) || (is_array($sectionId) && empty($sectionId))) {
            unset($this->SectionId);
        } else {
            $this->SectionId = $sectionId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotingResultStatusEnum::valueIsValid()
     * @uses \patest\EnumType\BallotingResultStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotingResultStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotingResultStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BallotingResultStatusEnum::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TemporaryTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTemporaryTransactionId()
    {
        return isset($this->TemporaryTransactionId) ? $this->TemporaryTransactionId : null;
    }
    /**
     * Set TemporaryTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $temporaryTransactionId
     * @return \patest\StructType\Ticketing_BallotingResult
     */
    public function setTemporaryTransactionId($temporaryTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($temporaryTransactionId) && !is_string($temporaryTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temporaryTransactionId, true), gettype($temporaryTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($temporaryTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $temporaryTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($temporaryTransactionId, true)), __LINE__);
        }
        if (is_null($temporaryTransactionId) || (is_array($temporaryTransactionId) && empty($temporaryTransactionId))) {
            unset($this->TemporaryTransactionId);
        } else {
            $this->TemporaryTransactionId = $temporaryTransactionId;
        }
        return $this;
    }
}
