<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotVirtualPriceType StructType
 * @subpackage Structs
 */
class Ticketing_BallotVirtualPriceType extends PersistableEntity
{
    /**
     * The AgeRestriction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AgeRestriction;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The MappedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MappedPriceTypes
     */
    public $MappedPriceTypes;
    /**
     * The MaxClientAge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxClientAge;
    /**
     * The MinClientAge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinClientAge;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Ticketing.BallotVirtualPriceType
     * @uses Ticketing_BallotVirtualPriceType::setAgeRestriction()
     * @uses Ticketing_BallotVirtualPriceType::setBallotId()
     * @uses Ticketing_BallotVirtualPriceType::setMappedPriceTypes()
     * @uses Ticketing_BallotVirtualPriceType::setMaxClientAge()
     * @uses Ticketing_BallotVirtualPriceType::setMinClientAge()
     * @uses Ticketing_BallotVirtualPriceType::setName()
     * @param bool $ageRestriction
     * @param string $ballotId
     * @param \patest\StructType\MappedPriceTypes $mappedPriceTypes
     * @param int $maxClientAge
     * @param int $minClientAge
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($ageRestriction = null, $ballotId = null, \patest\StructType\MappedPriceTypes $mappedPriceTypes = null, $maxClientAge = null, $minClientAge = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setAgeRestriction($ageRestriction)
            ->setBallotId($ballotId)
            ->setMappedPriceTypes($mappedPriceTypes)
            ->setMaxClientAge($maxClientAge)
            ->setMinClientAge($minClientAge)
            ->setName($name);
    }
    /**
     * Get AgeRestriction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAgeRestriction()
    {
        return isset($this->AgeRestriction) ? $this->AgeRestriction : null;
    }
    /**
     * Set AgeRestriction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ageRestriction
     * @return \patest\StructType\Ticketing_BallotVirtualPriceType
     */
    public function setAgeRestriction($ageRestriction = null)
    {
        // validation for constraint: boolean
        if (!is_null($ageRestriction) && !is_bool($ageRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ageRestriction, true), gettype($ageRestriction)), __LINE__);
        }
        if (is_null($ageRestriction) || (is_array($ageRestriction) && empty($ageRestriction))) {
            unset($this->AgeRestriction);
        } else {
            $this->AgeRestriction = $ageRestriction;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\Ticketing_BallotVirtualPriceType
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get MappedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MappedPriceTypes|null
     */
    public function getMappedPriceTypes()
    {
        return isset($this->MappedPriceTypes) ? $this->MappedPriceTypes : null;
    }
    /**
     * Set MappedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MappedPriceTypes $mappedPriceTypes
     * @return \patest\StructType\Ticketing_BallotVirtualPriceType
     */
    public function setMappedPriceTypes(\patest\StructType\MappedPriceTypes $mappedPriceTypes = null)
    {
        if (is_null($mappedPriceTypes) || (is_array($mappedPriceTypes) && empty($mappedPriceTypes))) {
            unset($this->MappedPriceTypes);
        } else {
            $this->MappedPriceTypes = $mappedPriceTypes;
        }
        return $this;
    }
    /**
     * Get MaxClientAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxClientAge()
    {
        return isset($this->MaxClientAge) ? $this->MaxClientAge : null;
    }
    /**
     * Set MaxClientAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxClientAge
     * @return \patest\StructType\Ticketing_BallotVirtualPriceType
     */
    public function setMaxClientAge($maxClientAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxClientAge) && !(is_int($maxClientAge) || ctype_digit($maxClientAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxClientAge, true), gettype($maxClientAge)), __LINE__);
        }
        if (is_null($maxClientAge) || (is_array($maxClientAge) && empty($maxClientAge))) {
            unset($this->MaxClientAge);
        } else {
            $this->MaxClientAge = $maxClientAge;
        }
        return $this;
    }
    /**
     * Get MinClientAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinClientAge()
    {
        return isset($this->MinClientAge) ? $this->MinClientAge : null;
    }
    /**
     * Set MinClientAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minClientAge
     * @return \patest\StructType\Ticketing_BallotVirtualPriceType
     */
    public function setMinClientAge($minClientAge = null)
    {
        // validation for constraint: int
        if (!is_null($minClientAge) && !(is_int($minClientAge) || ctype_digit($minClientAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minClientAge, true), gettype($minClientAge)), __LINE__);
        }
        if (is_null($minClientAge) || (is_array($minClientAge) && empty($minClientAge))) {
            unset($this->MinClientAge);
        } else {
            $this->MinClientAge = $minClientAge;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_BallotVirtualPriceType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
