<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotItemOwner StructType
 * @subpackage Structs
 */
class Ticketing_BallotItemOwner extends AnyEntity
{
    /**
     * The AvailableSeatQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableSeatQty;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The LineId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LineId;
    /**
     * The NumOfSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumOfSeats;
    /**
     * Constructor method for Ticketing.BallotItemOwner
     * @uses Ticketing_BallotItemOwner::setAvailableSeatQty()
     * @uses Ticketing_BallotItemOwner::setClientId()
     * @uses Ticketing_BallotItemOwner::setLineId()
     * @uses Ticketing_BallotItemOwner::setNumOfSeats()
     * @param int $availableSeatQty
     * @param string $clientId
     * @param string $lineId
     * @param int $numOfSeats
     */
    public function __construct($availableSeatQty = null, $clientId = null, $lineId = null, $numOfSeats = null)
    {
        $this
            ->setAvailableSeatQty($availableSeatQty)
            ->setClientId($clientId)
            ->setLineId($lineId)
            ->setNumOfSeats($numOfSeats);
    }
    /**
     * Get AvailableSeatQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableSeatQty()
    {
        return isset($this->AvailableSeatQty) ? $this->AvailableSeatQty : null;
    }
    /**
     * Set AvailableSeatQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableSeatQty
     * @return \patest\StructType\Ticketing_BallotItemOwner
     */
    public function setAvailableSeatQty($availableSeatQty = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeatQty) && !(is_int($availableSeatQty) || ctype_digit($availableSeatQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeatQty, true), gettype($availableSeatQty)), __LINE__);
        }
        if (is_null($availableSeatQty) || (is_array($availableSeatQty) && empty($availableSeatQty))) {
            unset($this->AvailableSeatQty);
        } else {
            $this->AvailableSeatQty = $availableSeatQty;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_BallotItemOwner
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get LineId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineId()
    {
        return isset($this->LineId) ? $this->LineId : null;
    }
    /**
     * Set LineId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lineId
     * @return \patest\StructType\Ticketing_BallotItemOwner
     */
    public function setLineId($lineId = null)
    {
        // validation for constraint: string
        if (!is_null($lineId) && !is_string($lineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineId, true), gettype($lineId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lineId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lineId, true)), __LINE__);
        }
        if (is_null($lineId) || (is_array($lineId) && empty($lineId))) {
            unset($this->LineId);
        } else {
            $this->LineId = $lineId;
        }
        return $this;
    }
    /**
     * Get NumOfSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumOfSeats()
    {
        return isset($this->NumOfSeats) ? $this->NumOfSeats : null;
    }
    /**
     * Set NumOfSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numOfSeats
     * @return \patest\StructType\Ticketing_BallotItemOwner
     */
    public function setNumOfSeats($numOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numOfSeats) && !(is_int($numOfSeats) || ctype_digit($numOfSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numOfSeats, true), gettype($numOfSeats)), __LINE__);
        }
        if (is_null($numOfSeats) || (is_array($numOfSeats) && empty($numOfSeats))) {
            unset($this->NumOfSeats);
        } else {
            $this->NumOfSeats = $numOfSeats;
        }
        return $this;
    }
}
