<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotEventSection StructType
 * @subpackage Structs
 */
class Ticketing_BallotEventSection extends PersistableEntity
{
    /**
     * The AllocationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllocationIds
     */
    public $AllocationIds;
    /**
     * The BallotEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotEventId;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceLevelName;
    /**
     * The PriceLevelsPriceTypeMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping
     */
    public $PriceLevelsPriceTypeMapping;
    /**
     * The PriceTypeList
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeList;
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SectionPriceType
     */
    public $PriceTypes;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The VirtualPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceType
     */
    public $VirtualPriceTypes;
    /**
     * Constructor method for Ticketing.BallotEventSection
     * @uses Ticketing_BallotEventSection::setAllocationIds()
     * @uses Ticketing_BallotEventSection::setBallotEventId()
     * @uses Ticketing_BallotEventSection::setMaxSeats()
     * @uses Ticketing_BallotEventSection::setName()
     * @uses Ticketing_BallotEventSection::setPriceLevelId()
     * @uses Ticketing_BallotEventSection::setPriceLevelIds()
     * @uses Ticketing_BallotEventSection::setPriceLevelName()
     * @uses Ticketing_BallotEventSection::setPriceLevelsPriceTypeMapping()
     * @uses Ticketing_BallotEventSection::setPriceTypeList()
     * @uses Ticketing_BallotEventSection::setPriceTypes()
     * @uses Ticketing_BallotEventSection::setPriority()
     * @uses Ticketing_BallotEventSection::setVirtualPriceTypes()
     * @param \patest\StructType\AllocationIds $allocationIds
     * @param string $ballotEventId
     * @param int $maxSeats
     * @param \patest\StructType\GlobalString $name
     * @param string $priceLevelId
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param \patest\StructType\GlobalString $priceLevelName
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelsPriceTypeMapping
     * @param string $priceTypeList
     * @param \patest\StructType\RecordSetOfTicketing_SectionPriceType $priceTypes
     * @param int $priority
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceType $virtualPriceTypes
     */
    public function __construct(\patest\StructType\AllocationIds $allocationIds = null, $ballotEventId = null, $maxSeats = null, \patest\StructType\GlobalString $name = null, $priceLevelId = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, \patest\StructType\GlobalString $priceLevelName = null, \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelsPriceTypeMapping = null, $priceTypeList = null, \patest\StructType\RecordSetOfTicketing_SectionPriceType $priceTypes = null, $priority = null, \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceType $virtualPriceTypes = null)
    {
        $this
            ->setAllocationIds($allocationIds)
            ->setBallotEventId($ballotEventId)
            ->setMaxSeats($maxSeats)
            ->setName($name)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriceLevelName($priceLevelName)
            ->setPriceLevelsPriceTypeMapping($priceLevelsPriceTypeMapping)
            ->setPriceTypeList($priceTypeList)
            ->setPriceTypes($priceTypes)
            ->setPriority($priority)
            ->setVirtualPriceTypes($virtualPriceTypes);
    }
    /**
     * Get AllocationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllocationIds|null
     */
    public function getAllocationIds()
    {
        return isset($this->AllocationIds) ? $this->AllocationIds : null;
    }
    /**
     * Set AllocationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllocationIds $allocationIds
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setAllocationIds(\patest\StructType\AllocationIds $allocationIds = null)
    {
        if (is_null($allocationIds) || (is_array($allocationIds) && empty($allocationIds))) {
            unset($this->AllocationIds);
        } else {
            $this->AllocationIds = $allocationIds;
        }
        return $this;
    }
    /**
     * Get BallotEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotEventId()
    {
        return isset($this->BallotEventId) ? $this->BallotEventId : null;
    }
    /**
     * Set BallotEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotEventId
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setBallotEventId($ballotEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotEventId) && !is_string($ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotEventId, true), gettype($ballotEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotEventId, true)), __LINE__);
        }
        if (is_null($ballotEventId) || (is_array($ballotEventId) && empty($ballotEventId))) {
            unset($this->BallotEventId);
        } else {
            $this->BallotEventId = $ballotEventId;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceLevelName
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setPriceLevelName(\patest\StructType\GlobalString $priceLevelName = null)
    {
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceLevelsPriceTypeMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping|null
     */
    public function getPriceLevelsPriceTypeMapping()
    {
        return isset($this->PriceLevelsPriceTypeMapping) ? $this->PriceLevelsPriceTypeMapping : null;
    }
    /**
     * Set PriceLevelsPriceTypeMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelsPriceTypeMapping
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setPriceLevelsPriceTypeMapping(\patest\StructType\RecordSetOfTicketing_BallotSectionPriceLevelPriceTypeMapping $priceLevelsPriceTypeMapping = null)
    {
        if (is_null($priceLevelsPriceTypeMapping) || (is_array($priceLevelsPriceTypeMapping) && empty($priceLevelsPriceTypeMapping))) {
            unset($this->PriceLevelsPriceTypeMapping);
        } else {
            $this->PriceLevelsPriceTypeMapping = $priceLevelsPriceTypeMapping;
        }
        return $this;
    }
    /**
     * Get PriceTypeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeList()
    {
        return isset($this->PriceTypeList) ? $this->PriceTypeList : null;
    }
    /**
     * Set PriceTypeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeList
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setPriceTypeList($priceTypeList = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeList) && !is_string($priceTypeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeList, true), gettype($priceTypeList)), __LINE__);
        }
        if (is_null($priceTypeList) || (is_array($priceTypeList) && empty($priceTypeList))) {
            unset($this->PriceTypeList);
        } else {
            $this->PriceTypeList = $priceTypeList;
        }
        return $this;
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SectionPriceType|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SectionPriceType $priceTypes
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setPriceTypes(\patest\StructType\RecordSetOfTicketing_SectionPriceType $priceTypes = null)
    {
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get VirtualPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceType|null
     */
    public function getVirtualPriceTypes()
    {
        return isset($this->VirtualPriceTypes) ? $this->VirtualPriceTypes : null;
    }
    /**
     * Set VirtualPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceType $virtualPriceTypes
     * @return \patest\StructType\Ticketing_BallotEventSection
     */
    public function setVirtualPriceTypes(\patest\StructType\RecordSetOfTicketing_BallotSectionVirtualPriceType $virtualPriceTypes = null)
    {
        if (is_null($virtualPriceTypes) || (is_array($virtualPriceTypes) && empty($virtualPriceTypes))) {
            unset($this->VirtualPriceTypes);
        } else {
            $this->VirtualPriceTypes = $virtualPriceTypes;
        }
        return $this;
    }
}
