<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotApplicationRowDetail StructType
 * @subpackage Structs
 */
class Ticketing_BallotApplicationRowDetail extends PersistableEntity
{
    /**
     * The BallotApplicationGroupedSectionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotApplicationGroupedSectionId;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The VirtualPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VirtualPriceTypeId;
    /**
     * Constructor method for Ticketing.BallotApplicationRowDetail
     * @uses Ticketing_BallotApplicationRowDetail::setBallotApplicationGroupedSectionId()
     * @uses Ticketing_BallotApplicationRowDetail::setOwnerId()
     * @uses Ticketing_BallotApplicationRowDetail::setPriority()
     * @uses Ticketing_BallotApplicationRowDetail::setVirtualPriceTypeId()
     * @param string $ballotApplicationGroupedSectionId
     * @param string $ownerId
     * @param int $priority
     * @param string $virtualPriceTypeId
     */
    public function __construct($ballotApplicationGroupedSectionId = null, $ownerId = null, $priority = null, $virtualPriceTypeId = null)
    {
        $this
            ->setBallotApplicationGroupedSectionId($ballotApplicationGroupedSectionId)
            ->setOwnerId($ownerId)
            ->setPriority($priority)
            ->setVirtualPriceTypeId($virtualPriceTypeId);
    }
    /**
     * Get BallotApplicationGroupedSectionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotApplicationGroupedSectionId()
    {
        return isset($this->BallotApplicationGroupedSectionId) ? $this->BallotApplicationGroupedSectionId : null;
    }
    /**
     * Set BallotApplicationGroupedSectionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotApplicationGroupedSectionId
     * @return \patest\StructType\Ticketing_BallotApplicationRowDetail
     */
    public function setBallotApplicationGroupedSectionId($ballotApplicationGroupedSectionId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotApplicationGroupedSectionId) && !is_string($ballotApplicationGroupedSectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotApplicationGroupedSectionId, true), gettype($ballotApplicationGroupedSectionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotApplicationGroupedSectionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotApplicationGroupedSectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotApplicationGroupedSectionId, true)), __LINE__);
        }
        if (is_null($ballotApplicationGroupedSectionId) || (is_array($ballotApplicationGroupedSectionId) && empty($ballotApplicationGroupedSectionId))) {
            unset($this->BallotApplicationGroupedSectionId);
        } else {
            $this->BallotApplicationGroupedSectionId = $ballotApplicationGroupedSectionId;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Ticketing_BallotApplicationRowDetail
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_BallotApplicationRowDetail
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get VirtualPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVirtualPriceTypeId()
    {
        return isset($this->VirtualPriceTypeId) ? $this->VirtualPriceTypeId : null;
    }
    /**
     * Set VirtualPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $virtualPriceTypeId
     * @return \patest\StructType\Ticketing_BallotApplicationRowDetail
     */
    public function setVirtualPriceTypeId($virtualPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($virtualPriceTypeId) && !is_string($virtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualPriceTypeId, true), gettype($virtualPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($virtualPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $virtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($virtualPriceTypeId, true)), __LINE__);
        }
        if (is_null($virtualPriceTypeId) || (is_array($virtualPriceTypeId) && empty($virtualPriceTypeId))) {
            unset($this->VirtualPriceTypeId);
        } else {
            $this->VirtualPriceTypeId = $virtualPriceTypeId;
        }
        return $this;
    }
}
