<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.AwayGameTicketAllotmentRow StructType
 * @subpackage Structs
 */
class Ticketing_AwayGameTicketAllotmentRow extends Ticketing_Ticket
{
    /**
     * The AwayGameAreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AwayGameAreaName;
    /**
     * The AwayGameRowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AwayGameRowName;
    /**
     * The AwayGameSeatName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AwayGameSeatName;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The SentByUser
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SentByUser;
    /**
     * The SentOnDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SentOnDate;
    /**
     * The SentTo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SentTo;
    /**
     * The SentToClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SentToClientId;
    /**
     * The SentToClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SentToClientName;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TravelGroup
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TravelGroup;
    /**
     * Constructor method for Ticketing.AwayGameTicketAllotmentRow
     * @uses Ticketing_AwayGameTicketAllotmentRow::setAwayGameAreaName()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setAwayGameRowName()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setAwayGameSeatName()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setCrmId()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setOwnerName()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setPriceTypeName()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setSentByUser()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setSentOnDate()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setSentTo()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setSentToClientId()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setSentToClientName()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setTransactionDate()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setTransactionNumber()
     * @uses Ticketing_AwayGameTicketAllotmentRow::setTravelGroup()
     * @param string $awayGameAreaName
     * @param string $awayGameRowName
     * @param string $awayGameSeatName
     * @param string $crmId
     * @param string $ownerName
     * @param string $priceTypeName
     * @param string $sentByUser
     * @param string $sentOnDate
     * @param string $sentTo
     * @param string $sentToClientId
     * @param string $sentToClientName
     * @param string $transactionDate
     * @param int $transactionNumber
     * @param int $travelGroup
     */
    public function __construct($awayGameAreaName = null, $awayGameRowName = null, $awayGameSeatName = null, $crmId = null, $ownerName = null, $priceTypeName = null, $sentByUser = null, $sentOnDate = null, $sentTo = null, $sentToClientId = null, $sentToClientName = null, $transactionDate = null, $transactionNumber = null, $travelGroup = null)
    {
        $this
            ->setAwayGameAreaName($awayGameAreaName)
            ->setAwayGameRowName($awayGameRowName)
            ->setAwayGameSeatName($awayGameSeatName)
            ->setCrmId($crmId)
            ->setOwnerName($ownerName)
            ->setPriceTypeName($priceTypeName)
            ->setSentByUser($sentByUser)
            ->setSentOnDate($sentOnDate)
            ->setSentTo($sentTo)
            ->setSentToClientId($sentToClientId)
            ->setSentToClientName($sentToClientName)
            ->setTransactionDate($transactionDate)
            ->setTransactionNumber($transactionNumber)
            ->setTravelGroup($travelGroup);
    }
    /**
     * Get AwayGameAreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAwayGameAreaName()
    {
        return isset($this->AwayGameAreaName) ? $this->AwayGameAreaName : null;
    }
    /**
     * Set AwayGameAreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $awayGameAreaName
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setAwayGameAreaName($awayGameAreaName = null)
    {
        // validation for constraint: string
        if (!is_null($awayGameAreaName) && !is_string($awayGameAreaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awayGameAreaName, true), gettype($awayGameAreaName)), __LINE__);
        }
        if (is_null($awayGameAreaName) || (is_array($awayGameAreaName) && empty($awayGameAreaName))) {
            unset($this->AwayGameAreaName);
        } else {
            $this->AwayGameAreaName = $awayGameAreaName;
        }
        return $this;
    }
    /**
     * Get AwayGameRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAwayGameRowName()
    {
        return isset($this->AwayGameRowName) ? $this->AwayGameRowName : null;
    }
    /**
     * Set AwayGameRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $awayGameRowName
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setAwayGameRowName($awayGameRowName = null)
    {
        // validation for constraint: string
        if (!is_null($awayGameRowName) && !is_string($awayGameRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awayGameRowName, true), gettype($awayGameRowName)), __LINE__);
        }
        if (is_null($awayGameRowName) || (is_array($awayGameRowName) && empty($awayGameRowName))) {
            unset($this->AwayGameRowName);
        } else {
            $this->AwayGameRowName = $awayGameRowName;
        }
        return $this;
    }
    /**
     * Get AwayGameSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAwayGameSeatName()
    {
        return isset($this->AwayGameSeatName) ? $this->AwayGameSeatName : null;
    }
    /**
     * Set AwayGameSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $awayGameSeatName
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setAwayGameSeatName($awayGameSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($awayGameSeatName) && !is_string($awayGameSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awayGameSeatName, true), gettype($awayGameSeatName)), __LINE__);
        }
        if (is_null($awayGameSeatName) || (is_array($awayGameSeatName) && empty($awayGameSeatName))) {
            unset($this->AwayGameSeatName);
        } else {
            $this->AwayGameSeatName = $awayGameSeatName;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get SentByUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentByUser()
    {
        return isset($this->SentByUser) ? $this->SentByUser : null;
    }
    /**
     * Set SentByUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentByUser
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setSentByUser($sentByUser = null)
    {
        // validation for constraint: string
        if (!is_null($sentByUser) && !is_string($sentByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentByUser, true), gettype($sentByUser)), __LINE__);
        }
        if (is_null($sentByUser) || (is_array($sentByUser) && empty($sentByUser))) {
            unset($this->SentByUser);
        } else {
            $this->SentByUser = $sentByUser;
        }
        return $this;
    }
    /**
     * Get SentOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentOnDate()
    {
        return isset($this->SentOnDate) ? $this->SentOnDate : null;
    }
    /**
     * Set SentOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentOnDate
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setSentOnDate($sentOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($sentOnDate) && !is_string($sentOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentOnDate, true), gettype($sentOnDate)), __LINE__);
        }
        if (is_null($sentOnDate) || (is_array($sentOnDate) && empty($sentOnDate))) {
            unset($this->SentOnDate);
        } else {
            $this->SentOnDate = $sentOnDate;
        }
        return $this;
    }
    /**
     * Get SentTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentTo()
    {
        return isset($this->SentTo) ? $this->SentTo : null;
    }
    /**
     * Set SentTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentTo
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setSentTo($sentTo = null)
    {
        // validation for constraint: string
        if (!is_null($sentTo) && !is_string($sentTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentTo, true), gettype($sentTo)), __LINE__);
        }
        if (is_null($sentTo) || (is_array($sentTo) && empty($sentTo))) {
            unset($this->SentTo);
        } else {
            $this->SentTo = $sentTo;
        }
        return $this;
    }
    /**
     * Get SentToClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentToClientId()
    {
        return isset($this->SentToClientId) ? $this->SentToClientId : null;
    }
    /**
     * Set SentToClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentToClientId
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setSentToClientId($sentToClientId = null)
    {
        // validation for constraint: string
        if (!is_null($sentToClientId) && !is_string($sentToClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentToClientId, true), gettype($sentToClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sentToClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sentToClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sentToClientId, true)), __LINE__);
        }
        if (is_null($sentToClientId) || (is_array($sentToClientId) && empty($sentToClientId))) {
            unset($this->SentToClientId);
        } else {
            $this->SentToClientId = $sentToClientId;
        }
        return $this;
    }
    /**
     * Get SentToClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentToClientName()
    {
        return isset($this->SentToClientName) ? $this->SentToClientName : null;
    }
    /**
     * Set SentToClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentToClientName
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setSentToClientName($sentToClientName = null)
    {
        // validation for constraint: string
        if (!is_null($sentToClientName) && !is_string($sentToClientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentToClientName, true), gettype($sentToClientName)), __LINE__);
        }
        if (is_null($sentToClientName) || (is_array($sentToClientName) && empty($sentToClientName))) {
            unset($this->SentToClientName);
        } else {
            $this->SentToClientName = $sentToClientName;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TravelGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTravelGroup()
    {
        return isset($this->TravelGroup) ? $this->TravelGroup : null;
    }
    /**
     * Set TravelGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $travelGroup
     * @return \patest\StructType\Ticketing_AwayGameTicketAllotmentRow
     */
    public function setTravelGroup($travelGroup = null)
    {
        // validation for constraint: int
        if (!is_null($travelGroup) && !(is_int($travelGroup) || ctype_digit($travelGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelGroup, true), gettype($travelGroup)), __LINE__);
        }
        if (is_null($travelGroup) || (is_array($travelGroup) && empty($travelGroup))) {
            unset($this->TravelGroup);
        } else {
            $this->TravelGroup = $travelGroup;
        }
        return $this;
    }
}
