<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.AddSubscriptionToBasketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.AddSubscriptionToBasketRequest
 * @subpackage Structs
 */
class Ticketing_AddSubscriptionToBasketRequest extends AnyEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AutoSetTicketSchemeEnrollment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoSetTicketSchemeEnrollment;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EffectiveAvailabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification
     */
    public $EffectiveAvailabilityFilter;
    /**
     * The EndDateOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateOverride;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The GroupNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupNumber;
    /**
     * The IsAutoAddEventTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoAddEventTickets;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The IsCreateIncompleteTicketsWhenSeatIsUnavailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCreateIncompleteTicketsWhenSeatIsUnavailable;
    /**
     * The IsProceedWhenSeatIsUnavailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProceedWhenSeatIsUnavailable;
    /**
     * The NumberOfBonusTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfBonusTickets;
    /**
     * The NumberOfTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfTickets;
    /**
     * The PrevSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrevSubscriptionInstanceId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The RestrictionIdToUse
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionIdToUse;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatReservationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatReservationMode;
    /**
     * The SeriesOrSeriesGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesOrSeriesGroupId;
    /**
     * The SkipAutoRenewValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipAutoRenewValidation;
    /**
     * The StartDateOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateOverride;
    /**
     * The WaitMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitMode;
    /**
     * Constructor method for Ticketing.AddSubscriptionToBasketRequest
     * @uses Ticketing_AddSubscriptionToBasketRequest::setAction()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setAreaId()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setAutoSetTicketSchemeEnrollment()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setClientId()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setEffectiveAvailabilityFilter()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setEndDateOverride()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setEventIds()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setGroupNumber()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setIsAutoAddEventTickets()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setIsAutoRenewRequested()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setIsCreateIncompleteTicketsWhenSeatIsUnavailable()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setIsProceedWhenSeatIsUnavailable()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setNumberOfBonusTickets()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setNumberOfTickets()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setPrevSubscriptionInstanceId()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setPriceLevelId()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setPriceTypeId()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setRestrictionIdToUse()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setSalesRepId()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setSeatIdInAreaMap()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setSeatReservationMode()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setSeriesOrSeriesGroupId()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setSkipAutoRenewValidation()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setStartDateOverride()
     * @uses Ticketing_AddSubscriptionToBasketRequest::setWaitMode()
     * @param string $action
     * @param string $areaId
     * @param bool $autoSetTicketSchemeEnrollment
     * @param string $clientId
     * @param \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @param string $endDateOverride
     * @param \patest\StructType\EventIds $eventIds
     * @param int $groupNumber
     * @param bool $isAutoAddEventTickets
     * @param bool $isAutoRenewRequested
     * @param bool $isCreateIncompleteTicketsWhenSeatIsUnavailable
     * @param bool $isProceedWhenSeatIsUnavailable
     * @param int $numberOfBonusTickets
     * @param int $numberOfTickets
     * @param string $prevSubscriptionInstanceId
     * @param string $priceLevelId
     * @param string $priceTypeId
     * @param string $restrictionIdToUse
     * @param string $salesRepId
     * @param int $seatIdInAreaMap
     * @param string $seatReservationMode
     * @param string $seriesOrSeriesGroupId
     * @param bool $skipAutoRenewValidation
     * @param string $startDateOverride
     * @param string $waitMode
     */
    public function __construct($action = null, $areaId = null, $autoSetTicketSchemeEnrollment = null, $clientId = null, \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null, $endDateOverride = null, \patest\StructType\EventIds $eventIds = null, $groupNumber = null, $isAutoAddEventTickets = null, $isAutoRenewRequested = null, $isCreateIncompleteTicketsWhenSeatIsUnavailable = null, $isProceedWhenSeatIsUnavailable = null, $numberOfBonusTickets = null, $numberOfTickets = null, $prevSubscriptionInstanceId = null, $priceLevelId = null, $priceTypeId = null, $restrictionIdToUse = null, $salesRepId = null, $seatIdInAreaMap = null, $seatReservationMode = null, $seriesOrSeriesGroupId = null, $skipAutoRenewValidation = null, $startDateOverride = null, $waitMode = null)
    {
        $this
            ->setAction($action)
            ->setAreaId($areaId)
            ->setAutoSetTicketSchemeEnrollment($autoSetTicketSchemeEnrollment)
            ->setClientId($clientId)
            ->setEffectiveAvailabilityFilter($effectiveAvailabilityFilter)
            ->setEndDateOverride($endDateOverride)
            ->setEventIds($eventIds)
            ->setGroupNumber($groupNumber)
            ->setIsAutoAddEventTickets($isAutoAddEventTickets)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setIsCreateIncompleteTicketsWhenSeatIsUnavailable($isCreateIncompleteTicketsWhenSeatIsUnavailable)
            ->setIsProceedWhenSeatIsUnavailable($isProceedWhenSeatIsUnavailable)
            ->setNumberOfBonusTickets($numberOfBonusTickets)
            ->setNumberOfTickets($numberOfTickets)
            ->setPrevSubscriptionInstanceId($prevSubscriptionInstanceId)
            ->setPriceLevelId($priceLevelId)
            ->setPriceTypeId($priceTypeId)
            ->setRestrictionIdToUse($restrictionIdToUse)
            ->setSalesRepId($salesRepId)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatReservationMode($seatReservationMode)
            ->setSeriesOrSeriesGroupId($seriesOrSeriesGroupId)
            ->setSkipAutoRenewValidation($skipAutoRenewValidation)
            ->setStartDateOverride($startDateOverride)
            ->setWaitMode($waitMode);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionAction::valueIsValid()
     * @uses \patest\EnumType\SubscriptionAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriptionAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AutoSetTicketSchemeEnrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoSetTicketSchemeEnrollment()
    {
        return isset($this->AutoSetTicketSchemeEnrollment) ? $this->AutoSetTicketSchemeEnrollment : null;
    }
    /**
     * Set AutoSetTicketSchemeEnrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoSetTicketSchemeEnrollment
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setAutoSetTicketSchemeEnrollment($autoSetTicketSchemeEnrollment = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoSetTicketSchemeEnrollment) && !is_bool($autoSetTicketSchemeEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoSetTicketSchemeEnrollment, true), gettype($autoSetTicketSchemeEnrollment)), __LINE__);
        }
        if (is_null($autoSetTicketSchemeEnrollment) || (is_array($autoSetTicketSchemeEnrollment) && empty($autoSetTicketSchemeEnrollment))) {
            unset($this->AutoSetTicketSchemeEnrollment);
        } else {
            $this->AutoSetTicketSchemeEnrollment = $autoSetTicketSchemeEnrollment;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EffectiveAvailabilityFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification|null
     */
    public function getEffectiveAvailabilityFilter()
    {
        return isset($this->EffectiveAvailabilityFilter) ? $this->EffectiveAvailabilityFilter : null;
    }
    /**
     * Set EffectiveAvailabilityFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setEffectiveAvailabilityFilter(\patest\StructType\Ticketing_EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null)
    {
        if (is_null($effectiveAvailabilityFilter) || (is_array($effectiveAvailabilityFilter) && empty($effectiveAvailabilityFilter))) {
            unset($this->EffectiveAvailabilityFilter);
        } else {
            $this->EffectiveAvailabilityFilter = $effectiveAvailabilityFilter;
        }
        return $this;
    }
    /**
     * Get EndDateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateOverride()
    {
        return isset($this->EndDateOverride) ? $this->EndDateOverride : null;
    }
    /**
     * Set EndDateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateOverride
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setEndDateOverride($endDateOverride = null)
    {
        // validation for constraint: string
        if (!is_null($endDateOverride) && !is_string($endDateOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateOverride, true), gettype($endDateOverride)), __LINE__);
        }
        if (is_null($endDateOverride) || (is_array($endDateOverride) && empty($endDateOverride))) {
            unset($this->EndDateOverride);
        } else {
            $this->EndDateOverride = $endDateOverride;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get GroupNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupNumber()
    {
        return isset($this->GroupNumber) ? $this->GroupNumber : null;
    }
    /**
     * Set GroupNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupNumber
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setGroupNumber($groupNumber = null)
    {
        // validation for constraint: int
        if (!is_null($groupNumber) && !(is_int($groupNumber) || ctype_digit($groupNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupNumber, true), gettype($groupNumber)), __LINE__);
        }
        if (is_null($groupNumber) || (is_array($groupNumber) && empty($groupNumber))) {
            unset($this->GroupNumber);
        } else {
            $this->GroupNumber = $groupNumber;
        }
        return $this;
    }
    /**
     * Get IsAutoAddEventTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoAddEventTickets()
    {
        return isset($this->IsAutoAddEventTickets) ? $this->IsAutoAddEventTickets : null;
    }
    /**
     * Set IsAutoAddEventTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoAddEventTickets
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setIsAutoAddEventTickets($isAutoAddEventTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoAddEventTickets) && !is_bool($isAutoAddEventTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoAddEventTickets, true), gettype($isAutoAddEventTickets)), __LINE__);
        }
        if (is_null($isAutoAddEventTickets) || (is_array($isAutoAddEventTickets) && empty($isAutoAddEventTickets))) {
            unset($this->IsAutoAddEventTickets);
        } else {
            $this->IsAutoAddEventTickets = $isAutoAddEventTickets;
        }
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get IsCreateIncompleteTicketsWhenSeatIsUnavailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCreateIncompleteTicketsWhenSeatIsUnavailable()
    {
        return isset($this->IsCreateIncompleteTicketsWhenSeatIsUnavailable) ? $this->IsCreateIncompleteTicketsWhenSeatIsUnavailable : null;
    }
    /**
     * Set IsCreateIncompleteTicketsWhenSeatIsUnavailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCreateIncompleteTicketsWhenSeatIsUnavailable
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setIsCreateIncompleteTicketsWhenSeatIsUnavailable($isCreateIncompleteTicketsWhenSeatIsUnavailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreateIncompleteTicketsWhenSeatIsUnavailable) && !is_bool($isCreateIncompleteTicketsWhenSeatIsUnavailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCreateIncompleteTicketsWhenSeatIsUnavailable, true), gettype($isCreateIncompleteTicketsWhenSeatIsUnavailable)), __LINE__);
        }
        if (is_null($isCreateIncompleteTicketsWhenSeatIsUnavailable) || (is_array($isCreateIncompleteTicketsWhenSeatIsUnavailable) && empty($isCreateIncompleteTicketsWhenSeatIsUnavailable))) {
            unset($this->IsCreateIncompleteTicketsWhenSeatIsUnavailable);
        } else {
            $this->IsCreateIncompleteTicketsWhenSeatIsUnavailable = $isCreateIncompleteTicketsWhenSeatIsUnavailable;
        }
        return $this;
    }
    /**
     * Get IsProceedWhenSeatIsUnavailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProceedWhenSeatIsUnavailable()
    {
        return isset($this->IsProceedWhenSeatIsUnavailable) ? $this->IsProceedWhenSeatIsUnavailable : null;
    }
    /**
     * Set IsProceedWhenSeatIsUnavailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProceedWhenSeatIsUnavailable
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setIsProceedWhenSeatIsUnavailable($isProceedWhenSeatIsUnavailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProceedWhenSeatIsUnavailable) && !is_bool($isProceedWhenSeatIsUnavailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProceedWhenSeatIsUnavailable, true), gettype($isProceedWhenSeatIsUnavailable)), __LINE__);
        }
        if (is_null($isProceedWhenSeatIsUnavailable) || (is_array($isProceedWhenSeatIsUnavailable) && empty($isProceedWhenSeatIsUnavailable))) {
            unset($this->IsProceedWhenSeatIsUnavailable);
        } else {
            $this->IsProceedWhenSeatIsUnavailable = $isProceedWhenSeatIsUnavailable;
        }
        return $this;
    }
    /**
     * Get NumberOfBonusTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfBonusTickets()
    {
        return isset($this->NumberOfBonusTickets) ? $this->NumberOfBonusTickets : null;
    }
    /**
     * Set NumberOfBonusTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfBonusTickets
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setNumberOfBonusTickets($numberOfBonusTickets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBonusTickets) && !(is_int($numberOfBonusTickets) || ctype_digit($numberOfBonusTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBonusTickets, true), gettype($numberOfBonusTickets)), __LINE__);
        }
        if (is_null($numberOfBonusTickets) || (is_array($numberOfBonusTickets) && empty($numberOfBonusTickets))) {
            unset($this->NumberOfBonusTickets);
        } else {
            $this->NumberOfBonusTickets = $numberOfBonusTickets;
        }
        return $this;
    }
    /**
     * Get NumberOfTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfTickets()
    {
        return isset($this->NumberOfTickets) ? $this->NumberOfTickets : null;
    }
    /**
     * Set NumberOfTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfTickets
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setNumberOfTickets($numberOfTickets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTickets) && !(is_int($numberOfTickets) || ctype_digit($numberOfTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTickets, true), gettype($numberOfTickets)), __LINE__);
        }
        if (is_null($numberOfTickets) || (is_array($numberOfTickets) && empty($numberOfTickets))) {
            unset($this->NumberOfTickets);
        } else {
            $this->NumberOfTickets = $numberOfTickets;
        }
        return $this;
    }
    /**
     * Get PrevSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrevSubscriptionInstanceId()
    {
        return isset($this->PrevSubscriptionInstanceId) ? $this->PrevSubscriptionInstanceId : null;
    }
    /**
     * Set PrevSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prevSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setPrevSubscriptionInstanceId($prevSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($prevSubscriptionInstanceId) && !is_string($prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prevSubscriptionInstanceId, true), gettype($prevSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($prevSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($prevSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($prevSubscriptionInstanceId) || (is_array($prevSubscriptionInstanceId) && empty($prevSubscriptionInstanceId))) {
            unset($this->PrevSubscriptionInstanceId);
        } else {
            $this->PrevSubscriptionInstanceId = $prevSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get RestrictionIdToUse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionIdToUse()
    {
        return isset($this->RestrictionIdToUse) ? $this->RestrictionIdToUse : null;
    }
    /**
     * Set RestrictionIdToUse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionIdToUse
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setRestrictionIdToUse($restrictionIdToUse = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionIdToUse) && !is_string($restrictionIdToUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionIdToUse, true), gettype($restrictionIdToUse)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionIdToUse) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionIdToUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionIdToUse, true)), __LINE__);
        }
        if (is_null($restrictionIdToUse) || (is_array($restrictionIdToUse) && empty($restrictionIdToUse))) {
            unset($this->RestrictionIdToUse);
        } else {
            $this->RestrictionIdToUse = $restrictionIdToUse;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatReservationMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatReservationMode()
    {
        return isset($this->SeatReservationMode) ? $this->SeatReservationMode : null;
    }
    /**
     * Set SeatReservationMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatReservationMode::valueIsValid()
     * @uses \patest\EnumType\SeatReservationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatReservationMode
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setSeatReservationMode($seatReservationMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatReservationMode::valueIsValid($seatReservationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatReservationMode', is_array($seatReservationMode) ? implode(', ', $seatReservationMode) : var_export($seatReservationMode, true), implode(', ', \patest\EnumType\SeatReservationMode::getValidValues())), __LINE__);
        }
        if (is_null($seatReservationMode) || (is_array($seatReservationMode) && empty($seatReservationMode))) {
            unset($this->SeatReservationMode);
        } else {
            $this->SeatReservationMode = $seatReservationMode;
        }
        return $this;
    }
    /**
     * Get SeriesOrSeriesGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesOrSeriesGroupId()
    {
        return isset($this->SeriesOrSeriesGroupId) ? $this->SeriesOrSeriesGroupId : null;
    }
    /**
     * Set SeriesOrSeriesGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesOrSeriesGroupId
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setSeriesOrSeriesGroupId($seriesOrSeriesGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesOrSeriesGroupId) && !is_string($seriesOrSeriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesOrSeriesGroupId, true), gettype($seriesOrSeriesGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesOrSeriesGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesOrSeriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesOrSeriesGroupId, true)), __LINE__);
        }
        if (is_null($seriesOrSeriesGroupId) || (is_array($seriesOrSeriesGroupId) && empty($seriesOrSeriesGroupId))) {
            unset($this->SeriesOrSeriesGroupId);
        } else {
            $this->SeriesOrSeriesGroupId = $seriesOrSeriesGroupId;
        }
        return $this;
    }
    /**
     * Get SkipAutoRenewValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipAutoRenewValidation()
    {
        return isset($this->SkipAutoRenewValidation) ? $this->SkipAutoRenewValidation : null;
    }
    /**
     * Set SkipAutoRenewValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipAutoRenewValidation
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setSkipAutoRenewValidation($skipAutoRenewValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipAutoRenewValidation) && !is_bool($skipAutoRenewValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipAutoRenewValidation, true), gettype($skipAutoRenewValidation)), __LINE__);
        }
        if (is_null($skipAutoRenewValidation) || (is_array($skipAutoRenewValidation) && empty($skipAutoRenewValidation))) {
            unset($this->SkipAutoRenewValidation);
        } else {
            $this->SkipAutoRenewValidation = $skipAutoRenewValidation;
        }
        return $this;
    }
    /**
     * Get StartDateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateOverride()
    {
        return isset($this->StartDateOverride) ? $this->StartDateOverride : null;
    }
    /**
     * Set StartDateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateOverride
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setStartDateOverride($startDateOverride = null)
    {
        // validation for constraint: string
        if (!is_null($startDateOverride) && !is_string($startDateOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateOverride, true), gettype($startDateOverride)), __LINE__);
        }
        if (is_null($startDateOverride) || (is_array($startDateOverride) && empty($startDateOverride))) {
            unset($this->StartDateOverride);
        } else {
            $this->StartDateOverride = $startDateOverride;
        }
        return $this;
    }
    /**
     * Get WaitMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitMode()
    {
        return isset($this->WaitMode) ? $this->WaitMode : null;
    }
    /**
     * Set WaitMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketWaitMode::valueIsValid()
     * @uses \patest\EnumType\TicketWaitMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waitMode
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public function setWaitMode($waitMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketWaitMode::valueIsValid($waitMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketWaitMode', is_array($waitMode) ? implode(', ', $waitMode) : var_export($waitMode, true), implode(', ', \patest\EnumType\TicketWaitMode::getValidValues())), __LINE__);
        }
        if (is_null($waitMode) || (is_array($waitMode) && empty($waitMode))) {
            unset($this->WaitMode);
        } else {
            $this->WaitMode = $waitMode;
        }
        return $this;
    }
}
