<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketWithVersionsAndExchangeOutEligibilityState
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketWithVersionsAndExchangeOutEligibilityState
 * @subpackage Structs
 */
class TicketWithVersionsAndExchangeOutEligibilityState extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_TicketWithVersions
     */
    public $Ticket;
    /**
     * The TicketExchangeOutState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketExchangeOutState;
    /**
     * Constructor method for TicketWithVersionsAndExchangeOutEligibilityState
     * @uses TicketWithVersionsAndExchangeOutEligibilityState::setTicket()
     * @uses TicketWithVersionsAndExchangeOutEligibilityState::setTicketExchangeOutState()
     * @param \patest\StructType\Ticketing_TicketWithVersions $ticket
     * @param string $ticketExchangeOutState
     */
    public function __construct(\patest\StructType\Ticketing_TicketWithVersions $ticket = null, $ticketExchangeOutState = null)
    {
        $this
            ->setTicket($ticket)
            ->setTicketExchangeOutState($ticketExchangeOutState);
    }
    /**
     * Get Ticket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_TicketWithVersions|null
     */
    public function getTicket()
    {
        return isset($this->Ticket) ? $this->Ticket : null;
    }
    /**
     * Set Ticket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_TicketWithVersions $ticket
     * @return \patest\StructType\TicketWithVersionsAndExchangeOutEligibilityState
     */
    public function setTicket(\patest\StructType\Ticketing_TicketWithVersions $ticket = null)
    {
        if (is_null($ticket) || (is_array($ticket) && empty($ticket))) {
            unset($this->Ticket);
        } else {
            $this->Ticket = $ticket;
        }
        return $this;
    }
    /**
     * Get TicketExchangeOutState value
     * @return string|null
     */
    public function getTicketExchangeOutState()
    {
        return $this->TicketExchangeOutState;
    }
    /**
     * Set TicketExchangeOutState value
     * @uses \patest\EnumType\ExchangeOutState::valueIsValid()
     * @uses \patest\EnumType\ExchangeOutState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketExchangeOutState
     * @return \patest\StructType\TicketWithVersionsAndExchangeOutEligibilityState
     */
    public function setTicketExchangeOutState($ticketExchangeOutState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ExchangeOutState::valueIsValid($ticketExchangeOutState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExchangeOutState', is_array($ticketExchangeOutState) ? implode(', ', $ticketExchangeOutState) : var_export($ticketExchangeOutState, true), implode(', ', \patest\EnumType\ExchangeOutState::getValidValues())), __LINE__);
        }
        $this->TicketExchangeOutState = $ticketExchangeOutState;
        return $this;
    }
}
