<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewAssociationCriteriaItemResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewAssociationCriteriaItemResponse
 * @subpackage Structs
 */
class TicketViewAssociationCriteriaItemResponse extends TicketViewAssociationCriteriaItem
{
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The ClientTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypeName;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The HallVersionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallVersionName;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The SeatTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeName;
    /**
     * The VenueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VenueId;
    /**
     * The VenueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VenueName;
    /**
     * Constructor method for TicketViewAssociationCriteriaItemResponse
     * @uses TicketViewAssociationCriteriaItemResponse::setAreaName()
     * @uses TicketViewAssociationCriteriaItemResponse::setClientTypeName()
     * @uses TicketViewAssociationCriteriaItemResponse::setHallName()
     * @uses TicketViewAssociationCriteriaItemResponse::setHallVersionName()
     * @uses TicketViewAssociationCriteriaItemResponse::setPriceLevelName()
     * @uses TicketViewAssociationCriteriaItemResponse::setPriceTypeName()
     * @uses TicketViewAssociationCriteriaItemResponse::setSeatTypeName()
     * @uses TicketViewAssociationCriteriaItemResponse::setVenueId()
     * @uses TicketViewAssociationCriteriaItemResponse::setVenueName()
     * @param string $areaName
     * @param string $clientTypeName
     * @param string $hallName
     * @param string $hallVersionName
     * @param string $priceLevelName
     * @param string $priceTypeName
     * @param string $seatTypeName
     * @param string $venueId
     * @param string $venueName
     */
    public function __construct($areaName = null, $clientTypeName = null, $hallName = null, $hallVersionName = null, $priceLevelName = null, $priceTypeName = null, $seatTypeName = null, $venueId = null, $venueName = null)
    {
        $this
            ->setAreaName($areaName)
            ->setClientTypeName($clientTypeName)
            ->setHallName($hallName)
            ->setHallVersionName($hallVersionName)
            ->setPriceLevelName($priceLevelName)
            ->setPriceTypeName($priceTypeName)
            ->setSeatTypeName($seatTypeName)
            ->setVenueId($venueId)
            ->setVenueName($venueName);
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get ClientTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeName()
    {
        return isset($this->ClientTypeName) ? $this->ClientTypeName : null;
    }
    /**
     * Set ClientTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setClientTypeName($clientTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeName) && !is_string($clientTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeName, true), gettype($clientTypeName)), __LINE__);
        }
        if (is_null($clientTypeName) || (is_array($clientTypeName) && empty($clientTypeName))) {
            unset($this->ClientTypeName);
        } else {
            $this->ClientTypeName = $clientTypeName;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HallVersionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionName()
    {
        return isset($this->HallVersionName) ? $this->HallVersionName : null;
    }
    /**
     * Set HallVersionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setHallVersionName($hallVersionName = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionName) && !is_string($hallVersionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionName, true), gettype($hallVersionName)), __LINE__);
        }
        if (is_null($hallVersionName) || (is_array($hallVersionName) && empty($hallVersionName))) {
            unset($this->HallVersionName);
        } else {
            $this->HallVersionName = $hallVersionName;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get SeatTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeName()
    {
        return isset($this->SeatTypeName) ? $this->SeatTypeName : null;
    }
    /**
     * Set SeatTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setSeatTypeName($seatTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeName) && !is_string($seatTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeName, true), gettype($seatTypeName)), __LINE__);
        }
        if (is_null($seatTypeName) || (is_array($seatTypeName) && empty($seatTypeName))) {
            unset($this->SeatTypeName);
        } else {
            $this->SeatTypeName = $seatTypeName;
        }
        return $this;
    }
    /**
     * Get VenueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueId()
    {
        return isset($this->VenueId) ? $this->VenueId : null;
    }
    /**
     * Set VenueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueId
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setVenueId($venueId = null)
    {
        // validation for constraint: string
        if (!is_null($venueId) && !is_string($venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueId, true), gettype($venueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($venueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($venueId, true)), __LINE__);
        }
        if (is_null($venueId) || (is_array($venueId) && empty($venueId))) {
            unset($this->VenueId);
        } else {
            $this->VenueId = $venueId;
        }
        return $this;
    }
    /**
     * Get VenueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueName()
    {
        return isset($this->VenueName) ? $this->VenueName : null;
    }
    /**
     * Set VenueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueName
     * @return \patest\StructType\TicketViewAssociationCriteriaItemResponse
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        if (is_null($venueName) || (is_array($venueName) && empty($venueName))) {
            unset($this->VenueName);
        } else {
            $this->VenueName = $venueName;
        }
        return $this;
    }
}
