<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketStyleOverrideWithUrls StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketStyleOverrideWithUrls
 * @subpackage Structs
 */
class TicketStyleOverrideWithUrls extends TicketStyleOverride
{
    /**
     * The TicketBackgroundImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBackgroundImageUrl;
    /**
     * The TicketSponsorshipLogoUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketSponsorshipLogoUrl;
    /**
     * Constructor method for TicketStyleOverrideWithUrls
     * @uses TicketStyleOverrideWithUrls::setTicketBackgroundImageUrl()
     * @uses TicketStyleOverrideWithUrls::setTicketSponsorshipLogoUrl()
     * @param string $ticketBackgroundImageUrl
     * @param string $ticketSponsorshipLogoUrl
     */
    public function __construct($ticketBackgroundImageUrl = null, $ticketSponsorshipLogoUrl = null)
    {
        $this
            ->setTicketBackgroundImageUrl($ticketBackgroundImageUrl)
            ->setTicketSponsorshipLogoUrl($ticketSponsorshipLogoUrl);
    }
    /**
     * Get TicketBackgroundImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBackgroundImageUrl()
    {
        return isset($this->TicketBackgroundImageUrl) ? $this->TicketBackgroundImageUrl : null;
    }
    /**
     * Set TicketBackgroundImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBackgroundImageUrl
     * @return \patest\StructType\TicketStyleOverrideWithUrls
     */
    public function setTicketBackgroundImageUrl($ticketBackgroundImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBackgroundImageUrl) && !is_string($ticketBackgroundImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBackgroundImageUrl, true), gettype($ticketBackgroundImageUrl)), __LINE__);
        }
        if (is_null($ticketBackgroundImageUrl) || (is_array($ticketBackgroundImageUrl) && empty($ticketBackgroundImageUrl))) {
            unset($this->TicketBackgroundImageUrl);
        } else {
            $this->TicketBackgroundImageUrl = $ticketBackgroundImageUrl;
        }
        return $this;
    }
    /**
     * Get TicketSponsorshipLogoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSponsorshipLogoUrl()
    {
        return isset($this->TicketSponsorshipLogoUrl) ? $this->TicketSponsorshipLogoUrl : null;
    }
    /**
     * Set TicketSponsorshipLogoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSponsorshipLogoUrl
     * @return \patest\StructType\TicketStyleOverrideWithUrls
     */
    public function setTicketSponsorshipLogoUrl($ticketSponsorshipLogoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSponsorshipLogoUrl) && !is_string($ticketSponsorshipLogoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSponsorshipLogoUrl, true), gettype($ticketSponsorshipLogoUrl)), __LINE__);
        }
        if (is_null($ticketSponsorshipLogoUrl) || (is_array($ticketSponsorshipLogoUrl) && empty($ticketSponsorshipLogoUrl))) {
            unset($this->TicketSponsorshipLogoUrl);
        } else {
            $this->TicketSponsorshipLogoUrl = $ticketSponsorshipLogoUrl;
        }
        return $this;
    }
}
